function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2022 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * API Status: **Private**
 * @module nmodule/signingService/rc/wb/mgr/SessionTokenManager
 * @since Niagara 4.13
 */
define(['baja!', 'baja!signingService:SessionToken,platCrypto:ApprovalState', 'Promise', 'underscore', 'nmodule/webEditors/rc/wb/mgr/Manager', 'bajaux/mixin/subscriberMixIn', 'nmodule/webEditors/rc/fe/baja/util/DepthSubscriber', 'nmodule/webEditors/rc/wb/mgr/model/columns/IconMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/NameMgrColumn', 'nmodule/webEditors/rc/wb/mgr/model/columns/PropertyMgrColumn', 'nmodule/signingService/rc/wb/mgr/column/MetadataColumn', 'nmodule/signingService/rc/wb/mgr/column/ProfileColumn', 'nmodule/webEditors/rc/wb/mgr/MgrTypeInfo', 'nmodule/signingService/rc/wb/mgr/model/SessionTokenMgrModel', 'nmodule/webEditors/rc/wb/table/model/source/ContainerComponentSource', 'bajaux/commands/CommandGroup', 'nmodule/signingService/rc/wb/mgr/command/ApproveCommand', 'nmodule/signingService/rc/wb/mgr/command/RejectCommand', 'nmodule/webEditors/rc/wb/mgr/mgrUtils', 'log!nmodule.signingService.rc.SessionTokenManager', 'lex!signingService'], function (baja, types, Promise, _, Manager, subscriberMixIn, DepthSubscriber, IconMgrColumn, NameMgrColumn, PropertyMgrColumn, MetadataColumn, ProfileColumn, MgrTypeInfo, SessionTokenMgrModel, ContainerComponentSource, CommandGroup, ApproveCommand, RejectCommand, mgrUtils, log, lexs) {
  'use strict';

  var getMainTableSelection = mgrUtils.getMainTableSelection,
    getMainTableSelectedSubjects = mgrUtils.getMainTableSelectedSubjects,
    findCommand = mgrUtils.findCommand,
    _lexs = _slicedToArray(lexs, 1),
    signingServiceLex = _lexs[0],
    logSevere = log.severe.bind(log),
    TOKEN_TYPE_SPEC = baja.lt('signingService:SessionToken'),
    TOKEN_TYPE = baja.lt(TOKEN_TYPE_SPEC),
    APPROVAL_STATE = baja.$('platCrypto:ApprovalState'),
    APPROVAL_STATE_EXPIRED = APPROVAL_STATE.get('expired');

  /**
   * @class
   * @alias module:nmodule/signingService/rc/wb/mgr/SessionTokenManager
   * @extends module:nmodule/webEditors/rc/wb/mgr/Manager
   * @param {Object} params
   */
  return /*#__PURE__*/function (_Manager) {
    function SessionTokenManager(params) {
      var _this;
      _classCallCheck(this, SessionTokenManager);
      _this = _callSuper(this, SessionTokenManager, [{
        params: params,
        moduleName: 'signingService',
        keyName: 'SessionTokenManager'
      }]);
      _this.$subscriber = new DepthSubscriber(3);
      subscriberMixIn(_this);
      return _this;
    }

    /**
     * @param {baja.Component} store The ('signingService:SessionTokenStore') value to be loaded.
     * @returns {Promise}
     */
    _inherits(SessionTokenManager, _Manager);
    return _createClass(SessionTokenManager, [{
      key: "doLoad",
      value: function doLoad(store) {
        var _this2 = this;
        return Manager.prototype.doLoad.apply(this, arguments).then(function () {
          _this2.getSubscriber().attach('changed added removed', function () {
            _this2.$updateRows();
            _this2.$updateColumns()["catch"](logSevere);
          });
          var mainTableSelection = getMainTableSelection(_this2);
          mainTableSelection.on('changed', function () {
            _this2.$getApproveCommand().setEnabled(_this2.$canApproveOrRejectSelectedTokens());
            _this2.$getRejectCommand().setEnabled(_this2.$canApproveOrRejectSelectedTokens());
            return false;
          });
        });
      }

      /**
       * Create a `MgrModel` instance with the appropriate columns.
       *
       * @param {baja.Component} container, the 'signingService:SessionTokenStore' instance this view sits on.
       * @returns {Promise.<module:nmodule/webEditors/rc/wb/mgr/model/MgrModel>}
       */
    }, {
      key: "makeModel",
      value: function makeModel(container) {
        var _this3 = this;
        this.$metadataColumnKeys = SessionTokenManager.$getMetadataKeys(container);
        return MgrTypeInfo.make(TOKEN_TYPE).then(function (mgrTypeInfo) {
          return new SessionTokenMgrModel({
            componentSource: new ContainerComponentSource({
              container: container
            }),
            newTypes: [mgrTypeInfo],
            columns: _this3.$makeColumns()
          });
        });
      }

      /**
       * Returns the default set of Tag Manager Commands.
       *
       * @returns {Array.<module:bajaux/commands/Command>}
       */
    }, {
      key: "makeCommands",
      value: function makeCommands() {
        return [new ApproveCommand(this), new RejectCommand(this)];
      }

      /**
       * updates the dynamic columns in the model.
       *
       * @returns {Promise} to be resolved if the update is successful
       * @private
       */
    }, {
      key: "$updateColumns",
      value: function $updateColumns() {
        var _this4 = this;
        var container = this.value();
        var beforeKeys = this.$metadataColumnKeys;
        var afterKeys = SessionTokenManager.$getMetadataKeys(container);
        if (!SessionTokenManager.$keysHaveChanged(beforeKeys, afterKeys)) {
          return Promise.resolve();
        }

        // update the dynamic columns
        this.$metadataColumnKeys = afterKeys;
        var model = this.getModel();

        // remove the current dynamic columns, and insert the updated ones
        return Promise.resolve(model.getColumns().length > this.$numberOfFixedColumns &&
        // there may be no dynamic columns currently
        model.removeColumns(this.$numberOfFixedColumns, model.getColumns().length)).then(function () {
          return model.insertColumns(_this4.$getDynamicColumns());
        });
      }

      /**
       * updates the icon for rows in the model.
       *
       * @private
       */
    }, {
      key: "$updateRows",
      value: function $updateRows() {
        // the icon's badge may have changed -
        // the subject's icon is the correct one, the row does not update its icon automatically.
        _.each(this.getModel().getRows(), function (row) {
          row.$icon = row.getSubject().getIcon();
        });
      }

      /**
       * Returns a list of columns for this view.
       *
       * @private
       * @returns {Array.<module:nmodule/webEditors/rc/wb/table/model/Column>}
       */
    }, {
      key: "$makeColumns",
      value: function $makeColumns() {
        // Fixed columns
        var columns = this.$getFixedColumns();

        // Dynamic columns
        _.each(this.$getDynamicColumns(), function (col) {
          columns.push(col);
        });
        return columns;
      }

      /**
       * Returns a list of fixed columns for this view.
       *
       * @private
       * @returns {Array.<module:nmodule/webEditors/rc/wb/table/model/Column>}
       */
    }, {
      key: "$getFixedColumns",
      value: function $getFixedColumns() {
        var columns = [new IconMgrColumn(), new NameMgrColumn(), new PropertyMgrColumn('state', {
          displayName: signingServiceLex.get('tokenStore.column.state.displayName')
        }), new ProfileColumn()];
        this.$numberOfFixedColumns = columns.length;
        return columns;
      }

      /**
       * Returns a list of dynamic columns for this view.
       *
       * @private
       * @returns {Array.<module:nmodule/webEditors/rc/wb/table/model/Column>}
       */
    }, {
      key: "$getDynamicColumns",
      value: function $getDynamicColumns() {
        var columns = [];
        _.each(this.$metadataColumnKeys, function (metadataField) {
          columns.push(new MetadataColumn('metadata', metadataField));
        });
        return columns;
      }

      /**
       * Return the 'ApproveCommand' instance from the command group.
       *
       * @private
       * @returns  {module:nmodule/signingService/rc/wb/mgr/command/ApproveCommand}
       */
    }, {
      key: "$getApproveCommand",
      value: function $getApproveCommand() {
        return findCommand(this, ApproveCommand);
      }

      /**
       * Return the 'RejectCommand' instance from the command group.
       *
       * @private
       * @returns  {module:nmodule/signingService/rc/wb/mgr/command/RejectCommand}
       */
    }, {
      key: "$getRejectCommand",
      value: function $getRejectCommand() {
        return findCommand(this, RejectCommand);
      }

      /**
       * returns true if no token in the selection is expired,
       * and all tokens have AdminInvoke permission.
       *
       * @private
       * @returns  {Boolean}
       */
    }, {
      key: "$canApproveOrRejectSelectedTokens",
      value: function $canApproveOrRejectSelectedTokens() {
        var selectedTokens = getMainTableSelectedSubjects(this);
        if (selectedTokens.length > 0) {
          return _.every(selectedTokens, function (token) {
            return token.getState() !== APPROVAL_STATE_EXPIRED && token.getPermissions().hasAdminInvoke();
          });
        }
        return false;
      }

      /**
       * returns a list of distinct metadata keys that are used in the
       * metadata (baja:String) slot of all the tokens in this view.
       * The expectation is that the metadata string will consist
       * of 'key: value' pairs each separated by a line break ('\n')
       *
       * @private
       * @param {baja.Component} container, the 'signingService:SessionTokenStore' instance this view sits on
       * @returns  {Array.<String>}
       */
    }], [{
      key: "$getMetadataKeys",
      value: function $getMetadataKeys(container) {
        var metadataKeys = [],
          components = container.getSlots().properties().is(TOKEN_TYPE_SPEC).toValueArray();
        var metadataLines, index, metadataKey;
        _.each(components, function (component) {
          metadataLines = component.getMetadata().split('\n');
          _.each(metadataLines, function (line) {
            index = line.indexOf(':');
            if (index > 0) {
              // presumably we should ignore zero as that would be a line starting with ':' so there's no key?
              metadataKey = line.substring(0, index);
              if (!metadataKeys.includes(metadataKey)) {
                metadataKeys.push(metadataKey);
              }
            }
          });
        });
        return metadataKeys;
      }

      /**
       * whether keys1 and keys2 contain different values.
       *
       * @private
       * @param {Array.<String>} keys1
       * @param {Array.<String>} keys2
       * @returns  {Boolean}
       */
    }, {
      key: "$keysHaveChanged",
      value: function $keysHaveChanged(keys1, keys2) {
        if (keys1.length !== keys2.length) {
          return true;
        }
        var union = _.union(keys1, keys2);
        if (union.length !== keys1.length) {
          return true;
        }
        return false;
      }
    }]);
  }(Manager);
});
