/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * BajaScript representation of a TagGroupInfo value
 * - sort of equivalent to the TagGroupInfo.java interface.
 *
 * API Status: **Private**
 * @module nmodule/tagdictionary/rc/taginfo/TagGroupInfoMixin
 */
define(['baja!', 'nmodule/tagdictionary/rc/taginfo/BaseTagInfoMixin'], function (baja, BaseTagInfoMixin) {
  'use strict';

  /**
   * BajaScript representation of an a TagGroupInfo value.
   *
   * @class
   * @alias module:nmodule/tagdictionary/rc/taginfo/TagGroupInfoMixin
   */
  var TagGroupInfoMixin = function TagGroupInfoMixin() {
    BaseTagInfoMixin.apply(this, arguments);
    this.$isTagGroup = true;
  };
  TagGroupInfoMixin.prototype = Object.create(BaseTagInfoMixin.prototype);
  TagGroupInfoMixin.prototype.constructor = TagGroupInfoMixin;
  TagGroupInfoMixin.prototype.getTagGroupName = function () {
    return this.getTagName();
  };
  return TagGroupInfoMixin;
});
