/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Andy Sutton
 */

/**
 * BajaScript representation of a TagInfo value
 * - sort of equivalent to the TagInfo.java interface.
 *
 * API Status: **Private**
 * @module nmodule/tagdictionary/rc/taginfo/TagInfoMixin
 */
define(['baja!', 'nmodule/tagdictionary/rc/taginfo/BaseTagInfoMixin'], function (baja, BaseTagInfoMixin) {
  'use strict';

  /**
   * BajaScript representation of an a TagInfo value.
   *
   * @class
   * @alias module:nmodule/tagdictionary/rc/taginfo/TagInfoMixin
   */
  var TagInfoMixin = function TagInfoMixin() {
    BaseTagInfoMixin.apply(this, arguments);
  };
  TagInfoMixin.prototype = Object.create(BaseTagInfoMixin.prototype);
  TagInfoMixin.prototype.constructor = TagInfoMixin;
  return TagInfoMixin;
});
