function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2023 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/platDataRecovery/rc/baja/DataRecoveryPersistenceCapacity
 */
define(["baja!", 'lex!platDataRecovery'], function (baja, lexs) {
  "use strict";

  var _lexs = _slicedToArray(lexs, 1),
    platDataRecoveryLex = _lexs[0];

  /**
   * DataRecoveryPersistenceCapacity defines the maximum capacity of the persistent
   * directory before a specified action (i.e. saving) takes place.
   * @class
   * @alias module:nmodule/platDataRecovery/rc/baja/DataRecoveryPersistenceCapacity
   * @extends baja.Simple
   * @author Christopher Zelaya on Jul 11, 2023
   * @since Niagara 4.14
   */
  var DataRecoveryPersistenceCapacity = /*#__PURE__*/function (_baja$Simple) {
    /**
     * Represents a DataRecoveryPersistenceCapacity object that extends a baja.simple.
     * @constructor
     * @param {number} restrictBy - Describes how the capacity is restricted
     * @param {number} maxBytes - Capacity size in bytes to enforce
     */
    function DataRecoveryPersistenceCapacity(restrictBy, maxBytes) {
      var _this;
      _classCallCheck(this, DataRecoveryPersistenceCapacity);
      _this = _callSuper(this, DataRecoveryPersistenceCapacity);
      _this.$restrictBy = restrictBy;
      _this.$maxBytes = maxBytes;
      return _this;
    }

    /**
     * Required by the framework to create a new instance
     * @param {number} restrictBy - Describes how the capacity is restricted
     * @param {number} maxBytes - Capacity size in bytes to enforce
     * @return {module:nmodule/platDataRecovery/rc/baja/DataRecoveryPersistenceCapacity} new instance of DataRecoveryPersistenceCapacity with
     * respected restrictBy and maxBytes values
     */
    _inherits(DataRecoveryPersistenceCapacity, _baja$Simple);
    return _createClass(DataRecoveryPersistenceCapacity, [{
      key: "make",
      value: function make(restrictBy, maxBytes) {
        return DataRecoveryPersistenceCapacity.make.apply(DataRecoveryPersistenceCapacity, arguments);
      }

      /**
       * Required by the framework to create a new instance
       * @param {number} restrictBy - Describes how the capacity is restricted
       * @param {number} maxBytes - Capacity size in bytes to enforce
       * @return {module:nmodule/platDataRecovery/rc/baja/DataRecoveryPersistenceCapacity} new instance of DataRecoveryPersistenceCapacity with
       * respected restrictBy and maxBytes values
       */
    }, {
      key: "decodeFromString",
      value:
      /**
       * Decode the specified string
       * @param {string} encodedString - the encoded string value
       * @return {module:nmodule/platDataRecovery/rc/baja/DataRecoveryPersistenceCapacity} new instance of DataRecoveryPersistenceCapacity with
       * respected restrictBy and maxBytes values
       */
      function decodeFromString(encodedString) {
        if (!/^\d+:\d+$/.exec(encodedString)) {
          throw new Error("Does not follow input restrictBy:max");
        }
        var arr = encodedString.split(":");
        var _arr$map = arr.map(function (string) {
            return parseInt(string, 10);
          }),
          _arr$map2 = _slicedToArray(_arr$map, 2),
          restrictBy = _arr$map2[0],
          maxBytes = _arr$map2[1];
        return new DataRecoveryPersistenceCapacity(restrictBy, maxBytes);
      }

      /**
       * Encode this instance to a string that can be decoded using
       * decodeFromString().
       * @return {string} string in format restrictBy:maxBytes
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        return String(this.$restrictBy) + ":" + String(this.$maxBytes);
      }

      /**
       * String the maxBytes value
       * @return {string} string in format number + "KB" or "B"
       */
    }, {
      key: "toString",
      value: function toString() {
        if (this.isUnlimited()) {
          return platDataRecoveryLex.get("unlimited");
        }
        var maxBytes = this.$maxBytes;
        if (maxBytes >= 1024) {
          return Math.floor(maxBytes / 1024) + " KB";
        } else {
          return maxBytes + " B";
        }
      }

      /**
       * Is this capacity unlimited?  If so, the max capacity should be ignored.
       *@return {boolean} true if restrictBy is equal to RESTRICT_NONE false otherwise
       */
    }, {
      key: "isUnlimited",
      value: function isUnlimited() {
        return this.$restrictBy === DataRecoveryPersistenceCapacity.RESTRICT_NONE;
      }

      /**
       * Is the capacity restricted by storage size?
       * @return {boolean} true if restrictBy is equal to RESTRICT_STORAGE_SIZE
       */
    }, {
      key: "isByStorageSize",
      value: function isByStorageSize() {
        return this.$restrictBy === DataRecoveryPersistenceCapacity.RESTRICT_STORAGE_SIZE;
      }

      /**
       * Get the maximum number of bytes if limited by storage size.
       * @return {number} Returns the maximum number of bytes or -1 if no
       * maximum is defined.
       */
    }, {
      key: "getMaxStorage",
      value: function getMaxStorage() {
        if (this.$restrictBy === DataRecoveryPersistenceCapacity.RESTRICT_NONE) {
          return -1;
        }
        return this.$maxBytes;
      }

      /**
       * Constant for unrestricted storage
       * @return {number}
       */
    }], [{
      key: "make",
      value: function make(restrictBy, maxBytes) {
        return new DataRecoveryPersistenceCapacity(restrictBy, maxBytes);
      }
    }, {
      key: "RESTRICT_NONE",
      get: function get() {
        return 0;
      }

      /**
       * Constant for restricted storage size
       * @return {number}
       */
    }, {
      key: "RESTRICT_STORAGE_SIZE",
      get: function get() {
        return 1;
      }
    }]);
  }(baja.Simple);
  DataRecoveryPersistenceCapacity.UNLIMITED = new DataRecoveryPersistenceCapacity(DataRecoveryPersistenceCapacity.RESTRICT_NONE, 0);
  DataRecoveryPersistenceCapacity.DEFAULT = DataRecoveryPersistenceCapacity.UNLIMITED;
  return DataRecoveryPersistenceCapacity;
});
