function _toConsumableArray(r) { return _arrayWithoutHoles(r) || _iterableToArray(r) || _unsupportedIterableToArray(r) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _iterableToArray(r) { if ("undefined" != typeof Symbol && null != r[Symbol.iterator] || null != r["@@iterator"]) return Array.from(r); }
function _arrayWithoutHoles(r) { if (Array.isArray(r)) return _arrayLikeToArray(r); }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * SpectrumChart.js
 * This javascript creates a SpectrumChart/HeatMap using d3 javascript.
 */
define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'Promise', 'jquery', 'underscore', 'd3', 'moment', 'nmodule/analytics/rc/chart/base/AnalyticC3BaseChart', 'nmodule/analytics/rc/chart/fe/AnalyticWCUxWebChartSettingsFE', 'nmodule/analytics/rc/chart/equipop/AnalyticsTabConfigEqOpModel', 'nmodule/analytics/rc/chart/fe/EqOpConfigurationSettingsFE', 'nmodule/analytics/rc/util/analyticsUtil', 'nmodule/webEditors/rc/wb/util/ICollectionSupport', 'lex!analytics', 'baja!analytics:AnalyticsTabConfigEqOpModel', 'baja!analytics:C3ChartTypeParams', 'css!nmodule/analytics/ext/c3/c3'], function (baja, Widget, subscriberMixIn, Promise, $, _, d3, moment, AnalyticC3BaseChart, AnalyticWCUxWebChartSettingsFE, AnalyticsTabConfigEqOpModel, EqOpConfigurationSettingsFE, analyticsUtil, ICollectionSupport, lexicon) {
  "use strict";

  var lex = lexicon[0];
  /**
   *
   * @class
   * @alias module:nmodule/analytics/rc/chart/analyticwebchart/AnalyticWebChart
   * @extends module:nmodule/analytics/rc/chart/base/AnalyticC3BaseChart
   * @mixes module:nmodule/webEditors/rc/wb/util/ICollectionSupport
   * @param {Object} [params]
   */
  var AnalyticWebChart = function AnalyticWebChart(params) {
    AnalyticC3BaseChart.call(this, $.extend({}, params));
    ICollectionSupport(this);
  };
  AnalyticWebChart.prototype = Object.create(AnalyticC3BaseChart.prototype);
  AnalyticWebChart.prototype.constructor = AnalyticWebChart;

  /**
   * This method should be overridden by subclasses to return respective chart types.
   * The default implementation retruns "none".
   * @returns {string}
   */
  AnalyticWebChart.prototype.getSupportedExportTypes = function () {
    return ["awchart", "csv"];
  };

  /**
   *
   * @param chartSettingsCollection
   */
  AnalyticWebChart.prototype.processData = function (chartSettingsCollection) {
    var that = this,
      seriesList = [];
    return AnalyticC3BaseChart.prototype.processData.apply(that, arguments).then(function (chartColl) {
      chartSettingsCollection = chartColl;
      for (var i = 0; i < chartSettingsCollection.length; i++) {
        var model = chartSettingsCollection[i];
        var series = {
          name: model.getSeriesName(),
          chartType: model.getChartType(),
          showOnY2: model.getShowOnY2(),
          data: model.getAnalyticTrendArray(),
          color: model.getBrush(),
          unit: model.getUnit().getSymbol(),
          ord: model.getOrd()
        };
        seriesList.push(series);
        if (model.getBaseline() && model.getBaseline().baselineEnabled) {
          var baselineData = _toConsumableArray(model.getAnalyticChartBaselineTrendArray());
          if (baselineData.length) {
            analyticsUtil.updateWebChartBaselineData(baselineData, model.getAnalyticTrendArray());
          }
          var nameExtension = lex.get("chart.series.append.baseline");
          if (baselineData.length > 0) {
            nameExtension += " TR [" + baselineData[0].blDate.toDateString() + " :: ";
            nameExtension += baselineData[baselineData.length - 1].blDate.toDateString() + "]";
          }
          var baselineSeries = {
            name: model.getSeriesName() + nameExtension,
            chartType: model.getChartType(),
            showOnY2: model.getShowOnY2(),
            data: baselineData,
            color: model.getBaseline().baselineColor,
            unit: model.getUnit().getSymbol(),
            ord: model.getOrd()
          };
          seriesList.push(baselineSeries);
        }
      }
      that.series = seriesList; // each series now has only one record
      return analyticsUtil.getRenderableC3Data(that, that.series);
    });
  };
  AnalyticWebChart.prototype.getMetaData = function (data) {
    return {
      interpolationStatus: data.interpolationStatus,
      blDate: data.blDate
    };
  };

  /**
   *
   * @returns {string[]}
   */
  AnalyticWebChart.prototype.getColorCodedColKeys = function () {
    return ['grpName'];
  };

  /**
   *
   * @returns {boolean}
   */
  AnalyticWebChart.prototype.needsBreakOnOneIteration = function () {
    return false;
  };

  /**
   *
   * @returns {string}
   */
  AnalyticWebChart.prototype.getTableDataStructure = function () {
    return 'aggregatedData';
  };

  /**
   *
   * @returns {string[]}
   */
  AnalyticWebChart.prototype.getColumnNames = function () {
    return this.columnNames;
  };

  /**
   *
   * @returns {string[]}
   */
  AnalyticWebChart.prototype.getColumnKeys = function () {
    return this.columnKeys;
  };

  /**
   * Open for the children to override.
   * Should return the Y Axis label.
   * @param text
   */
  AnalyticWebChart.prototype.getY2AxisType = function () {};

  /**
   *
   * @param data
   * @param timeRange
   * @returns {*}
   */
  AnalyticWebChart.prototype.buildModel = function (data, timeRange) {
    var model = AnalyticC3BaseChart.prototype.buildModel.apply(this, arguments);
    model.setShowOnY2(data.getShowOnY2());
    return model;
  };

  /**
   * Get Settings Editor Type
   * @returns {*}
   */
  AnalyticWebChart.prototype.getSettingsEditorType = function () {
    return AnalyticWCUxWebChartSettingsFE;
  };
  AnalyticWebChart.prototype.getName = function () {
    return "AnalyticWebChart";
  };

  /**
   *
   * @returns {object}
   */
  AnalyticWebChart.prototype.getDefaultSettings = function () {
    var defObj = AnalyticC3BaseChart.prototype.getDefaultSettings.apply(this, arguments);
    defObj.chartType = "line";
    return defObj;
  };
  AnalyticWebChart.prototype.getDefaultOrdScheme = function () {
    return "analyticBaselineTrend:";
  };
  return AnalyticWebChart;
});
