/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 * @author : Upender Paravastu & Komaravolu, sai
 * @file Model for Chart Data for analytics views
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/chart/base/AnalyticsBaseDataModel
 */
define(['baja!', 'nmodule/analytics/rc/util/analyticsUtil', 'lex!analytics'], function (baja, analyticsUtil, lexicon) {
  "use strict";

  var lex = lexicon[0];
  var BRUSH_DEFAULT = '#ff0000',
    BRUSH2_DEFAULT = '#0000ff',
    MIDBRUSH_DEFAULT = '#ebe9d8';

  /**
   * Represents a model for chart settings and corresponding series data
   * Always update toString method when adding a new property
   * @class
   * @alias module:nmodule/analytics/rc/chart/base/AnalyticsBaseDataModel
   * @param chartSettings
   */
  var AnalyticsBaseDataModel = function AnalyticsBaseDataModel(chartSettings) {
    this.$unit = baja.Unit.NULL;
    if (chartSettings) {
      // Fail safe for units. For any String type unit, default encoding will be performed inside the model.
      var unit = chartSettings.unit && chartSettings.unit.getType ? chartSettings.unit.getType().getTypeSpec() === "baja:String" ? baja.$("baja:Unit").decodeFromString(chartSettings.unit) : chartSettings.unit : undefined;
      this.$seriesName = chartSettings.seriesName || "";
      this.$seriesNameBFormat = chartSettings.seriesNameBFormat || "%node.navDisplayName%-%data.name%";
      this.$timeRange = chartSettings.timeRange;
      this.$daysToExclude = chartSettings.daysToExclude;
      this.$interval = chartSettings.interval;
      this.$isIntervalSelected = chartSettings.isIntervalSelected;
      this.$baseline = chartSettings.baseline;
      this.$isRollupSelected = chartSettings.isRollupSelected;
      this.$isAggregationSelected = chartSettings.isAggregationSelected;
      this.$ord = chartSettings.ord;
      this.$data = chartSettings.data;
      this.$rollup = chartSettings.rollup;
      this.$aggregation = chartSettings.aggregation;
      this.$analyticTrendArray = [];
      this.$analyticChartBaselineTrendArray = [];
      this.$chartSpecificSettings = {};
      this.$startTime = baja.AbsTime.DEFAULT;
      this.$endTime = baja.AbsTime.now();
      this.$dataFilter = chartSettings.dataFilter;
      this.setBrush(chartSettings.brush);
      this.setBrush2(chartSettings.brush2);
      this.setMidBrush(chartSettings.midBrush);
      this.$dataSource = chartSettings.dataSource;
      this.$dataSourceName = chartSettings.dataSourceName;
      this.$uniqueKey = chartSettings.uniqueKey;
      this.$node = chartSettings.node;
      this.$unit = unit || baja.Unit.NULL;
      this.$hisTotEnabled = chartSettings.hisTotEnabled;
      this.$interpolationStatus = chartSettings.interpolationStatus;
      this.$areaCfg = {
        req: false
      };
      this.$degreeDayCfg = {
        req: false
      };
      this.$missingDataCfg = chartSettings.missingDataCfg;
    }
  };
  AnalyticsBaseDataModel.prototype = Object.create(Object.prototype);
  AnalyticsBaseDataModel.prototype.constructor = AnalyticsBaseDataModel;
  AnalyticsBaseDataModel.prototype.getTimeRange = function () {
    return this.$timeRange;
  };
  AnalyticsBaseDataModel.prototype.getStartTime = function () {
    return this.$startTime;
  };
  AnalyticsBaseDataModel.prototype.getEndTime = function () {
    return this.$endTime;
  };
  AnalyticsBaseDataModel.prototype.getInterval = function () {
    return this.$interval;
  };
  AnalyticsBaseDataModel.prototype.isIntervalSelected = function () {
    return !!this.$isIntervalSelected;
  };
  AnalyticsBaseDataModel.prototype.setIsIntervalSelected = function (intervalSelected) {
    this.$isIntervalSelected = intervalSelected;
  };
  AnalyticsBaseDataModel.prototype.isRollupSelected = function () {
    return !!this.$isRollupSelected;
  };
  AnalyticsBaseDataModel.prototype.setIsRollupSelected = function (isRollupSelected) {
    this.$isRollupSelected = isRollupSelected;
  };
  AnalyticsBaseDataModel.prototype.isAggregationSelected = function () {
    return !!this.$isAggregationSelected;
  };
  AnalyticsBaseDataModel.prototype.setIsAggregationSelected = function (isAggregationSelected) {
    this.$isAggregationSelected = isAggregationSelected;
  };
  AnalyticsBaseDataModel.prototype.getOrd = function () {
    return this.$ord;
  };
  AnalyticsBaseDataModel.prototype.getAggregation = function () {
    return this.$aggregation;
  };
  AnalyticsBaseDataModel.prototype.getRollup = function () {
    return this.$rollup;
  };
  AnalyticsBaseDataModel.prototype.getData = function () {
    return this.$data;
  };
  AnalyticsBaseDataModel.prototype.getUnit = function () {
    return this.$unit;
  };
  AnalyticsBaseDataModel.prototype.getAnalyticTrendArray = function () {
    return this.$analyticTrendArray;
  };
  AnalyticsBaseDataModel.prototype.getAnalyticChartBaselineTrendArray = function () {
    return this.$analyticChartBaselineTrendArray;
  };
  AnalyticsBaseDataModel.prototype.getSeriesName = function () {
    return this.$seriesName;
  };
  AnalyticsBaseDataModel.prototype.getSeriesNameBFormat = function () {
    return this.$seriesNameBFormat;
  };
  AnalyticsBaseDataModel.prototype.getChartSpecificSettings = function () {
    return this.$chartSpecificSettings;
  };
  AnalyticsBaseDataModel.prototype.getDataFilter = function () {
    return this.$dataFilter;
  };
  AnalyticsBaseDataModel.prototype.getDataSource = function () {
    return this.$dataSource;
  };
  AnalyticsBaseDataModel.prototype.getBrush = function () {
    return this.$brush;
  };
  AnalyticsBaseDataModel.prototype.getBrush2 = function () {
    return this.$brush2;
  };
  AnalyticsBaseDataModel.prototype.getMidBrush = function () {
    return this.$midBrush;
  };
  AnalyticsBaseDataModel.prototype.getDataSourceName = function () {
    return this.$dataSourceName;
  };
  AnalyticsBaseDataModel.prototype.getOrd = function () {
    return this.$ord;
  };
  AnalyticsBaseDataModel.prototype.getUniqueKey = function () {
    return this.$uniqueKey;
  };
  AnalyticsBaseDataModel.prototype.getNode = function () {
    return this.$node;
  };
  AnalyticsBaseDataModel.prototype.getDaysToExclude = function () {
    return this.$daysToExclude;
  };
  AnalyticsBaseDataModel.prototype.setDaysToExclude = function (daysToExclude) {
    this.$daysToExclude = daysToExclude;
  };
  AnalyticsBaseDataModel.prototype.setTimeRange = function (timeRangeP) {
    this.$timeRange = timeRangeP;
  };
  AnalyticsBaseDataModel.prototype.setStartTime = function (startTimeP) {
    this.$startTime = startTimeP;
  };
  AnalyticsBaseDataModel.prototype.setEndTime = function (endTimeP) {
    this.$endTime = endTimeP;
  };
  AnalyticsBaseDataModel.prototype.setInterval = function (intervalP) {
    this.$interval = intervalP;
  };
  AnalyticsBaseDataModel.prototype.setOrd = function (ordP) {
    this.$ord = ordP;
  };
  AnalyticsBaseDataModel.prototype.setAggregation = function (aggregationP) {
    this.$aggregation = aggregationP;
  };
  AnalyticsBaseDataModel.prototype.setRollup = function (rollupP) {
    this.$rollup = rollupP;
  };
  AnalyticsBaseDataModel.prototype.setData = function (dataP) {
    this.$data = dataP;
  };
  AnalyticsBaseDataModel.prototype.setUnit = function (unitP) {
    this.$unit = unitP;
  };
  AnalyticsBaseDataModel.prototype.setAnalyticTrendArray = function (analyticTrendArrayP) {
    this.$analyticTrendArray = analyticTrendArrayP;
  };
  AnalyticsBaseDataModel.prototype.setAnalyticChartBaselineTrendArray = function (analyticChartBaselineTrendArrayP) {
    this.$analyticChartBaselineTrendArray = analyticChartBaselineTrendArrayP;
  };
  AnalyticsBaseDataModel.prototype.setChartSpecificSettings = function (chartSpecificSettingsP) {
    this.$chartSpecificSettings = chartSpecificSettingsP;
  };
  AnalyticsBaseDataModel.prototype.setDataFilter = function (dataFilterP) {
    this.$dataFilter = dataFilterP;
  };
  AnalyticsBaseDataModel.prototype.setBrush = function (brushP) {
    this.$brush = brushP ? String(brushP) : BRUSH_DEFAULT;
  };
  AnalyticsBaseDataModel.prototype.setBrush2 = function (brushP) {
    this.$brush2 = brushP ? String(brushP) : BRUSH2_DEFAULT;
  };
  AnalyticsBaseDataModel.prototype.setMidBrush = function (brushP) {
    this.$midBrush = brushP ? String(brushP) : MIDBRUSH_DEFAULT;
  };
  AnalyticsBaseDataModel.prototype.setDataSource = function (dataSourceP) {
    this.$dataSource = dataSourceP;
  };
  AnalyticsBaseDataModel.prototype.setDataSourceName = function (dataSourceNameP) {
    this.$dataSourceName = dataSourceNameP;
  };
  AnalyticsBaseDataModel.prototype.setOrd = function (ordP) {
    this.$ord = ordP;
  };
  AnalyticsBaseDataModel.prototype.setSeriesName = function (setSeriesP) {
    this.$seriesName = setSeriesP;
  };
  AnalyticsBaseDataModel.prototype.setSeriesNameBFormat = function (setSeriesP) {
    this.$seriesNameBFormat = setSeriesP;
  };
  AnalyticsBaseDataModel.prototype.setUniqueKey = function (uniqueKey) {
    this.$uniqueKey = uniqueKey;
  };
  AnalyticsBaseDataModel.prototype.setNode = function (node) {
    this.$node = node;
  };
  AnalyticsBaseDataModel.prototype.getHisTotEnabled = function () {
    return this.$hisTotEnabled !== undefined ? this.$hisTotEnabled : true;
  };
  AnalyticsBaseDataModel.prototype.setHisTotEnabled = function (status) {
    this.$hisTotEnabled = status;
  };
  AnalyticsBaseDataModel.prototype.getInterpolationStatus = function () {
    return this.$interpolationStatus !== undefined ? this.$interpolationStatus : true;
  };
  AnalyticsBaseDataModel.prototype.setInterpolationStatus = function (status) {
    this.$interpolationStatus = status;
  };
  AnalyticsBaseDataModel.prototype.getAreaCfg = function () {
    return this.$areaCfg;
  };
  AnalyticsBaseDataModel.prototype.setAreaCfg = function (areaCfg) {
    this.$areaCfg = areaCfg;
  };
  AnalyticsBaseDataModel.prototype.getDegreeDayCfg = function () {
    return this.$degreeDayCfg;
  };
  AnalyticsBaseDataModel.prototype.setDegreeDayCfg = function (degreeDayCfg) {
    this.$degreeDayCfg = degreeDayCfg;
  };
  /**
   * Re - build the ORD from scratch using the parameters in 'this' instance.
   */
  AnalyticsBaseDataModel.prototype.rebuildOrd = function () {
    var ord = analyticsUtil.getReconstructedOrd(this);
    this.setOrd(ord);
  };
  AnalyticsBaseDataModel.prototype.getMissingDataConfig = function () {
    return this.$missingDataCfg;
  };
  AnalyticsBaseDataModel.prototype.setMissingDataConfig = function (missingDataCfg) {
    this.$missingDataCfg = missingDataCfg;
  };
  AnalyticsBaseDataModel.prototype.getBaseline = function () {
    return this.$baseline;
  };
  AnalyticsBaseDataModel.prototype.setBaseline = function (baselineP) {
    this.$baseline = baselineP;
  };
  /**
   * Get the unit to be displayed in the analytic widgets
   */
  AnalyticsBaseDataModel.prototype.getUnitDisplay = function () {
    var unitSymbol = this.getUnit().getSymbol();
    var areaCfg = this.getAreaCfg();
    var degreeDayCfg = this.getDegreeDayCfg();
    var unitArr = [];
    if (unitSymbol && unitSymbol !== "null") {
      unitArr.push(unitSymbol);
    }
    if (areaCfg && areaCfg.value > 0) {
      unitArr.push(lex.get("report.unit.label.separator"));
      if (areaCfg.units && areaCfg.units.toString() !== "null") {
        unitArr.push(areaCfg.units.getSymbol());
      } else {
        unitArr.push(lex.get("report.area.nounit.label"));
      }
    }
    if (degreeDayCfg && degreeDayCfg.oatValues) {
      unitArr.push(lex.get("report.unit.label.separator"));
      if (degreeDayCfg.oatUnits) {
        unitArr.push(lex.get({
          key: "report.degreeDay.label",
          args: [degreeDayCfg.oatUnits.getSymbol()]
        }));
      } else {
        unitArr.push(lex.get("report.degreeDay.nounit.label"));
      }
    }
    unitSymbol = lex.get({
      key: "report.unit.normalized.format." + unitArr.length,
      args: unitArr
    });
    return unitSymbol && unitSymbol !== "null" ? unitSymbol : "";
  };
  AnalyticsBaseDataModel.prototype.toString = function () {
    var temp = {
      seriesName: this.$seriesName || "",
      seriesNameBFormat: this.$seriesNameBFormat || "%node.navDisplayName%-%data.name%",
      timeRange: this.$timeRange,
      daysToExclude: this.$daysToExclude,
      isIntervalSelected: this.$isIntervalSelected,
      isRollupSelected: this.$isRollupSelected,
      isAggregationSelected: this.$isAggregationSelected,
      interval: this.$interval,
      ord: this.$ord,
      data: this.$data,
      baseline: this.$baseline,
      rollup: this.$rollup,
      aggregation: this.$aggregation,
      analyticTrendArray: [],
      analyticChartBaselineTrendArray: [],
      chartSpecificSettings: {},
      startTime: baja.AbsTime.DEFAULT,
      endTime: baja.AbsTime.now(),
      dataFilter: "",
      brush: this.$brush || "#ff0000",
      // Give a a default
      brush2: this.$brush2 || "#0000ff",
      // Give a a default
      midBrush: this.$midBrush || "#ebe9d8",
      // Give a a default
      dataSource: this.$dataSource,
      dataSourceName: this.$dataSourceName,
      uniqueKey: this.$uniqueKey,
      node: this.$node,
      unit: this.$unit.encodeToString(),
      hisTotEnabled: this.$hisTotEnabled,
      interpolationStatus: this.$interpolationStatus,
      areaCfg: this.$areaCfg,
      degreeDayCfg: this.$degreeDayCfg,
      missingDataCfg: this.$missingDataCfg
    };
    return temp;
  };
  return AnalyticsBaseDataModel;
});
