/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 *@file Model for Chart Data for analytics views
 * @author : Upender Paravastu & Komaravolu, sai
 *
 */
define(['baja!', 'nmodule/analytics/rc/util/analyticsUtil', 'underscore', 'lex!analytics'], function (baja, analyticsUtil, _, lexicon) {
  "use strict";

  var lex = lexicon[0];

  /**
   * Represents a model for chart settings and corresponding series data
   * @param chartSettings
   * @constructor
   */
  var AnalyticsMultiNodeDataModel = function AnalyticsMultiNodeDataModel(chartSettings) {
    this.$unit = baja.Unit.NULL;
    if (chartSettings) {
      this.$unit = chartSettings.unit || baja.Unit.NULL;
      this.$aggMode = chartSettings.aggMode;
      this.$isIntervalSelected = chartSettings.isIntervalSelected;
      this.$aggregation = chartSettings.aggregation;
      this.$data = chartSettings.data || chartSettings.dataTag;
      this.$dow = chartSettings.daysToExclude;
      this.$nodeModel = chartSettings.nodeModel;
      this.$ord = chartSettings.ord || [];
      this.$rollup = chartSettings.rollup;
      this.$dataFilter = chartSettings.dataFilter;
      this.$interval = chartSettings.interval;
      this.$brush = chartSettings.brush || "#ff0000"; // Give a a default
      this.$brush2 = chartSettings.brush2 || "#0000ff"; // Give a a default
      this.$midBrush = chartSettings.midBrush || "#ebe9d8"; // Give a a default
      this.$seriesName = chartSettings.seriesName;
      this.$seriesNameBFormat = chartSettings.seriesNameBFormat;
      this.$timeRange = chartSettings.timeRange;
      this.$uniqueKey = chartSettings.uniqueKey;
      this.$dataSource = chartSettings.dataSource;
      this.$hisTotEnabled = chartSettings.hisTotEnabled;
      this.$normalization = chartSettings.normalization;
      this.$areaTag = chartSettings.areaTag;
      this.$oatTag = chartSettings.oatTag;
      this.$missingDataCfg = chartSettings.missingDataCfg;
    }
  };
  AnalyticsMultiNodeDataModel.prototype = Object.create(Object.prototype);
  AnalyticsMultiNodeDataModel.prototype.constructor = AnalyticsMultiNodeDataModel;
  AnalyticsMultiNodeDataModel.prototype.setAggMode = function ($aggMode) {
    this.$aggMode = $aggMode;
  };
  AnalyticsMultiNodeDataModel.prototype.getAggMode = function () {
    return this.$aggMode;
  };
  AnalyticsMultiNodeDataModel.prototype.setAggregation = function ($aggregation) {
    this.$aggregation = $aggregation;
  };
  AnalyticsMultiNodeDataModel.prototype.isIntervalSelected = function () {
    return this.$isIntervalSelected;
  };
  AnalyticsMultiNodeDataModel.prototype.setIsIntervalSelected = function (intervalSelected) {
    this.$isIntervalSelected = intervalSelected;
  };
  AnalyticsMultiNodeDataModel.prototype.getAggregation = function () {
    return this.$aggregation;
  };
  AnalyticsMultiNodeDataModel.prototype.setData = function ($data) {
    this.$data = $data;
  };
  AnalyticsMultiNodeDataModel.prototype.getData = function () {
    return this.$data;
  };
  AnalyticsMultiNodeDataModel.prototype.setDow = function ($dow) {
    this.$dow = $dow;
  };
  AnalyticsMultiNodeDataModel.prototype.getDow = function () {
    return this.$dow;
  };
  AnalyticsMultiNodeDataModel.prototype.setNodeModel = function ($nodeModel) {
    this.$nodeModel = $nodeModel;
  };
  AnalyticsMultiNodeDataModel.prototype.getNodeModel = function () {
    return this.$nodeModel;
  };
  AnalyticsMultiNodeDataModel.prototype.setOrd = function ($ord) {
    this.$ord = $ord;
  };
  AnalyticsMultiNodeDataModel.prototype.getOrd = function () {
    return this.$ord;
  };
  AnalyticsMultiNodeDataModel.prototype.setSeriesName = function ($seriesName) {
    this.$seriesName = $seriesName;
  };
  AnalyticsMultiNodeDataModel.prototype.getSeriesName = function () {
    return this.$seriesName;
  };
  AnalyticsMultiNodeDataModel.prototype.setSeriesNameBFormat = function ($seriesNameBFormat) {
    this.$seriesNameBFormat = $seriesNameBFormat;
  };
  AnalyticsMultiNodeDataModel.prototype.getSeriesNameBFormat = function () {
    return this.$seriesNameBFormat;
  };
  AnalyticsMultiNodeDataModel.prototype.setTimeRange = function ($timeRange) {
    this.$timeRange = $timeRange;
  };
  AnalyticsMultiNodeDataModel.prototype.getTimeRange = function () {
    return this.$timeRange;
  };
  AnalyticsMultiNodeDataModel.prototype.getUniqueKey = function () {
    return this.$uniqueKey;
  };
  AnalyticsMultiNodeDataModel.prototype.setUniqueKey = function (uniqueKey) {
    this.$uniqueKey = uniqueKey;
  };
  AnalyticsMultiNodeDataModel.prototype.getDataSource = function () {
    return this.$dataSource;
  };
  AnalyticsMultiNodeDataModel.prototype.setDataSource = function (dataSourceP) {
    this.$dataSource = dataSourceP;
  };
  AnalyticsMultiNodeDataModel.prototype.getUnit = function () {
    return this.$unit;
  };
  AnalyticsMultiNodeDataModel.prototype.setUnit = function (unitP) {
    this.$unit = unitP;
  };
  AnalyticsMultiNodeDataModel.prototype.getHisTotEnabled = function () {
    return this.$hisTotEnabled || true;
  };
  AnalyticsMultiNodeDataModel.prototype.setHisTotEnabled = function (status) {
    this.$hisTotEnabled = status;
  };
  AnalyticsMultiNodeDataModel.prototype.getAreaTag = function () {
    return this.$areaTag || "hs:area";
  };
  AnalyticsMultiNodeDataModel.prototype.setAreaTag = function (areaTag) {
    this.$areaTag = areaTag;
  };
  AnalyticsMultiNodeDataModel.prototype.getOatTag = function () {
    return this.$oatTag || "hs:outsideAirTempSensor";
  };
  AnalyticsMultiNodeDataModel.prototype.setOatTag = function (oatTag) {
    this.$oatTag = oatTag;
  };
  AnalyticsMultiNodeDataModel.prototype.getNormalizations = function () {
    return this.$normalization;
  };
  AnalyticsMultiNodeDataModel.prototype.setNormalizations = function (normalization) {
    this.$normalization = normalization;
  };
  AnalyticsMultiNodeDataModel.prototype.getMissingDataConfig = function () {
    return this.$missingDataCfg;
  };
  AnalyticsMultiNodeDataModel.prototype.setMissingDataConfig = function (missingDataCfg) {
    this.$missingDataCfg = missingDataCfg;
  };
  AnalyticsMultiNodeDataModel.prototype.isUnitBasedCombination = function () {
    var unitfulCombinations = ["avg", "first", "last", "max", "median", "min", "mode", "range", "sum"];
    var rollup = this.$rollup,
      agg = this.$aggregation;
    return (rollup === undefined || _.contains(unitfulCombinations, rollup)) && (agg === undefined || _.contains(unitfulCombinations, agg));
  };
  /**
   * Re - build the ORD from scratch using the parameters in 'this' instance.
   */
  AnalyticsMultiNodeDataModel.prototype.rebuildOrd = function (ordScheme) {
    this.setNodeModel(analyticsUtil.getMultiNodeOrd(this, ordScheme));
  };
  /**
   * Re - build the ORD from scratch using the parameters in 'this' instance.
   */
  AnalyticsMultiNodeDataModel.prototype.updateWithBaselineModel = function (baselineModel) {
    var nodeModel = this.getNodeModel();
    _.each(baselineModel.getNodeModel(), function (value, key) {
      value.bl = true;
      var unescapedKey = lex.get({
        key: "report.settings.baseline.format",
        args: [baja.SlotPath.unescape(key), baselineModel.getBaselineTimeRange().getDisplayTag()]
      });
      value.dn = lex.get({
        key: "report.settings.baseline.format",
        args: [key, baselineModel.getBaselineTimeRange().getDisplayTag()]
      });
      nodeModel[baja.SlotPath.escape(unescapedKey)] = value;
    });
  };
  return AnalyticsMultiNodeDataModel;
});
