/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 * @author Sai, Komaravolu & Upender, Paravastu
 */

define(['baja!', 'nmodule/analytics/rc/util/analyticsUtil', 'underscore'], function (baja, analyticsUtil, _) {
  "use strict";

  /**
   * Represents a model for chart settings and corresponding series data
   * @param chartSettings
   * @constructor
   */
  var AnalyticsMultiOrdDataModel = function AnalyticsMultiOrdDataModel(chartSettings) {
    var that = this;
    this.$unit = baja.Unit.NULL;
    this.$isIntervalSelected = chartSettings.isIntervalSelected;
    this.$dataSource = chartSettings.dataSource;
    this.$uniqueKey = chartSettings.uniqueKey;
    if (chartSettings) {
      this.$analyticTrendArray = [];
      this.$multiOrdArray = [];
      this.$ord = chartSettings.ord;
      _.each(chartSettings.multiOrd, function (ord) {
        var ob = {};
        _.keys(ord, function (key) {
          ob["$" + key] = ord[key];
        });
        that.$multiOrdArray.push(ob);
      });
    }
  };
  AnalyticsMultiOrdDataModel.prototype = Object.create(Object.prototype);
  AnalyticsMultiOrdDataModel.prototype.constructor = AnalyticsMultiOrdDataModel;
  AnalyticsMultiOrdDataModel.prototype.getAnalyticTrendArray = function () {
    return this.$analyticTrendArray;
  };
  AnalyticsMultiOrdDataModel.prototype.isIntervalSelected = function () {
    return this.$isIntervalSelected;
  };
  AnalyticsMultiOrdDataModel.prototype.setIsIntervalSelected = function (intervalSelected) {
    this.$isIntervalSelected = intervalSelected;
  };
  AnalyticsMultiOrdDataModel.prototype.setAnalyticTrendArray = function (analyticTrendArrayP) {
    this.$analyticTrendArray = analyticTrendArrayP;
  };
  AnalyticsMultiOrdDataModel.prototype.getMultiOrdArray = function () {
    return this.$multiOrdArray;
  };
  AnalyticsMultiOrdDataModel.prototype.setMultiOrdArray = function ($multiOrdArray) {
    this.$multiOrdArray = $multiOrdArray;
  };
  AnalyticsMultiOrdDataModel.prototype.getOrd = function () {
    return this.$ord;
  };
  AnalyticsMultiOrdDataModel.prototype.setOrd = function ($ord) {
    this.$ord = $ord;
  };
  AnalyticsMultiOrdDataModel.prototype.getUniqueKey = function () {
    return this.$uniqueKey;
  };
  AnalyticsMultiOrdDataModel.prototype.setUniqueKey = function (uniqueKey) {
    this.$uniqueKey = uniqueKey;
  };
  AnalyticsMultiOrdDataModel.prototype.getDataSource = function () {
    return this.$dataSource;
  };
  AnalyticsMultiOrdDataModel.prototype.setDataSource = function (dataSourceP) {
    this.$dataSource = dataSourceP;
  };
  AnalyticsMultiOrdDataModel.prototype.getUnit = function () {
    return this.$unit;
  };
  AnalyticsMultiOrdDataModel.prototype.setUnit = function (unitP) {
    this.$unit = unitP;
  };

  /**
   * Re - build the ORD from scratch using the parameters in 'this' instance.
   */
  AnalyticsMultiOrdDataModel.prototype.rebuildOrd = function () {
    var ord = analyticsUtil.getReconstructedOrd(this);
    this.setOrd(ord);
  };
  return AnalyticsMultiOrdDataModel;
});
