/*
 * Copyright 2022 Tridium, Inc. All Rights Reserved.
 */

/**
 * Created by H402747 on 8/7/2022.
 */
define(['baja!', 'lex!analytics', 'jquery', 'Promise', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/fe', 'bajaux/events', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/gx/rc/fe/ColorEditor', 'nmodule/webEditors/rc/fe/baja/DynamicEnumEditor', 'nmodule/webEditors/rc/fe/baja/FrozenEnumEditor', 'nmodule/analytics/rc/report/util/reportUtils', 'hbs!nmodule/analytics/rc/chart/templates/fe/UxAnalyticChartBaselineDetails', 'baja!analytics:BaselineTimeRangeEnum', 'css!nmodule/analytics/rc/report/styles/uxstyles'], function (baja, lexs, $, Promise, Widget, fe, events, BaseEditor, ColorEditor, DynamicEnumEditor, FrozenEnumEditor, reportUtils, UxAnalyticChartBaselineDetails, types) {
  'use strict';

  var lex = lexs[0];
  var endDtEnblElem = ".end-time-cont input.end-time-enbl",
    dowEnblElem = ".dow-enbl-cont input.dow-enbl";
  /**
   * @param params
   * @constructor
   */
  var AnalyticChartBaselineDetailsFE = function AnalyticChartBaselineDetailsFE(params) {
    BaseEditor.apply(this, arguments);
  };
  AnalyticChartBaselineDetailsFE.prototype = Object.create(BaseEditor.prototype);
  AnalyticChartBaselineDetailsFE.prototype.constructor = AnalyticChartBaselineDetailsFE;

  /**
   * Creates the template for Analytic Data Tag Selector.
   * @param {jQuery} dom
   */
  AnalyticChartBaselineDetailsFE.prototype.doInitialize = function (dom) {
    dom.html(UxAnalyticChartBaselineDetails({
      nodeColor: lex.get("report.settings.baseline.color"),
      timeRange: lex.get("report.settings.baseline.time"),
      startTimeLbl: lex.get("time.start"),
      endTimeLbl: lex.get("time.end"),
      alignDOW: lex.get("report.settings.dow.align")
    }));
    return BaseEditor.prototype.doInitialize.apply(this, arguments);
  };

  /**
   * Load the baseline configuration details in to the view
   * @param val
   */
  AnalyticChartBaselineDetailsFE.prototype.doLoad = function (val) {
    var that = this;
    var endTimeEnabler = $(endDtEnblElem, that.jq());
    endTimeEnabler.prop("checked", val.getEndTimeEnabled());
    return Promise.all(that.$getBaselineEditors(val)).then(function () {
      if (!that.$registered) {
        that.registerEvents();
        that.$registered = true;
        return that.$populateBaselineDtls();
      }
    });
  };

  /**
   * Returns the selected baseline configuration.
   * @returns {String} the selected data tag
   */
  AnalyticChartBaselineDetailsFE.prototype.doRead = function () {
    var that = this,
      baselineDtls = that.value();
    var endTimeEnabler = $(endDtEnblElem, that.jq()),
      dowEnabler = $(dowEnblElem, that.jq());
    return that.getChildWidgets().readAll().then(function (editorValues) {
      baselineDtls.setBaselineColor(editorValues[0]);
      baselineDtls.setTimeRange(editorValues[1]);
      var ssSt = reportUtils.getHourMinuteOnly(editorValues[2]);
      var ssEt = reportUtils.getHourMinuteOnly(editorValues[3]);
      baselineDtls.setStartTime(ssSt);
      baselineDtls.setEndTime(ssEt);
      baselineDtls.setEndTimeEnabled(endTimeEnabler.is(":checked"));
      baselineDtls.setAlignDOW(dowEnabler.is(":checked"));
      // eslint-disable-next-line promise/no-return-wrap
      return Promise.resolve(baselineDtls);
    });
  };
  /**
   * Register events for handling the time range options
   */
  AnalyticChartBaselineDetailsFE.prototype.registerEvents = function () {
    var that = this;
    var editors = that.getChildWidgets(),
      baselineEditor = editors[1];
    baselineEditor.jq().on(events.MODIFY_EVENT, function () {
      return that.$populateBaselineDtls();
    });
    var endTimeEnabler = $(endDtEnblElem, that.jq());
    var alignDOWEnabler = $(dowEnblElem, that.jq());
    endTimeEnabler.change(function () {
      var checked = $(this).is(":checked");
      return baselineEditor.read().then(function (baselineVal) {
        var enabled = baselineVal.getOrdinal() === 0;
        if (enabled && !checked) {
          // eslint-disable-next-line promise/catch-or-return
          editors[2].read().then(function (stLoaded) {
            return Promise.all([that.$loadBaselineTimeRanges(0, alignDOWEnabler.is(":checked")), editors[3].setReadonly(!checked || !enabled)]);
          });
        } else {
          return editors[3].setReadonly(!checked || !enabled);
        }
      });
    });
    alignDOWEnabler.change(function () {
      var checked = $(this).is(":checked");
      return baselineEditor.read().then(function (baselineVal) {
        return that.$loadBaselineTimeRanges(baselineVal.getOrdinal(), checked);
      });
    });
  };

  /**
   * Populate the details in baseline editor
   */

  AnalyticChartBaselineDetailsFE.prototype.$populateBaselineDtls = function () {
    var that = this,
      editors = that.getChildWidgets(),
      baselineEditor = editors[1],
      val = that.value();
    var endTimeEnabler = $(endDtEnblElem, that.jq()),
      endTimeChecked = endTimeEnabler.is(":checked");
    editors[3].setReadonly(!endTimeChecked);
    var blEditorPromise = baselineEditor.read().then(function (baselineVal) {
      var isCustomTimeRange = baselineVal.getOrdinal() === 0;
      var dowElem = $(dowEnblElem, that.jq());
      dowElem.prop("disabled", isCustomTimeRange);
      endTimeEnabler.prop('disabled', !isCustomTimeRange);
      dowElem.prop('checked', val.getAlignDOW());
      if (!isCustomTimeRange) {
        endTimeEnabler.prop('checked', true);
      }
      return Promise.all([editors[2].setReadonly(!isCustomTimeRange), editors[3].setReadonly(!endTimeChecked || !isCustomTimeRange), Promise.resolve(baselineVal)]);
    });
    return blEditorPromise.then(function (ret) {
      return that.$loadBaselineTimeRanges(ret[2].getOrdinal() || 0, val.getAlignDOW());
    });
  };
  /**
   *
   * @param baselineOrdinal
   * @param alignDOWEnabled
   */
  AnalyticChartBaselineDetailsFE.prototype.$loadBaselineTimeRanges = function (baselineOrdinal, alignDOWChecked) {
    var that = this,
      val = that.value(),
      editors = that.getChildWidgets();
    var props = this.properties(),
      timeRange = props.getValue("timeRange");
    return reportUtils.getDatesFromTimeRange(timeRange).then(function (comp) {
      var st = comp.getStartTime(),
        et = comp.getEndTime(),
        obj = {
          blSt: val.getStartTime(),
          blEt: val.getEndTime()
        };
      if (baselineOrdinal === 1) {
        // One week prior
        obj = reportUtils.getOneWeekPriorDates(st, et);
      } else if (baselineOrdinal === 2) {
        // One month prior
        obj = reportUtils.getOneMonthPriorDates(st, et, alignDOWChecked);
      } else if (baselineOrdinal === 3) {
        // One year prior
        obj = reportUtils.getOneYearPriorDates(st, et, alignDOWChecked);
      } else if (baselineOrdinal === 0) {
        // Custom Time range
        var endTimeEnabler = $(endDtEnblElem, that.jq()),
          endTimeChecked = endTimeEnabler.is(":checked");
        if (!endTimeChecked) {
          // If end time is not checked auto calculate end date by adding the time range to start baseline time
          obj.blEt = reportUtils.getCalculatedEndTime(st, et, obj.blSt);
        }
      }
      return Promise.all([editors[2].load(obj.blSt), editors[3].load(obj.blEt)]);
    });
  };
  AnalyticChartBaselineDetailsFE.prototype.$getBaselineEditors = function (val) {
    var that = this,
      jq = that.jq();
    var colorFePromise = fe.buildFor({
      dom: $(".node-color-fe", jq),
      value: val.getBaselineColor(),
      properties: {
        uxFieldEditor: 'gx:ColorEditor'
      },
      formFactor: 'mini'
    });
    var baseLineFE = fe.buildFor({
      dom: $(".baseline-time-fe", jq),
      value: val.getTimeRange(),
      type: FrozenEnumEditor,
      formFactor: 'mini'
    });
    var startTimeFE = fe.buildFor({
      dom: $(".start-time", jq),
      value: val.getStartTime(),
      formFactor: 'mini'
    });
    var endTimeFE = fe.buildFor({
      dom: $(".end-time", jq),
      value: val.getEndTime(),
      readonly: true,
      formFactor: 'mini'
    });
    return [colorFePromise, baseLineFE, startTimeFE, endTimeFE];
  };
  return AnalyticChartBaselineDetailsFE;
});
