/* eslint-disable no-irregular-whitespace */
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/report/command/AnalyticNodeDeleteCommand
 */
define(['baja!', 'lex!webEditors', 'underscore', 'jquery', 'Promise', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/analytics/rc/util/analyticsUtil', 'nmodule/webEditors/rc/wb/commands/ComponentEditorCommand', 'nmodule/webEditors/rc/wb/commands/DeleteCommand', 'nmodule/analytics/rc/report/util/reportWidgetEvents'], function (baja, lexs, _, $, Promise, feDialogs, analyticsUtil, ComponentEditorCommand, DeleteCommand, reportWidgetEvents) {
  'use strict';

  ////////////////////////////////////////////////////////////////
  // Exports
  ////////////////////////////////////////////////////////////////

  /**
   * A command for deleting an analytic node or a group
   * @class
   * @alias module:nmodule/analytics/rc/report/command/AnalyticNodeDeleteCommand
   * @extends module:nmodule/webEditors/rc/wb/commands/ComponentEditorCommand
   * @param ed
   * @param component
   */
  var AnalyticNodeDeleteCommand = function AnalyticNodeDeleteCommand(ed, component, params) {
    var that = this;
    that.$ed = ed;
    this.$slots = params && params.slots || false;
    ComponentEditorCommand.call(that, {
      module: 'webEditors',
      lex: 'commands.delete'
    }, component);
    that.$deleteCommand = new DeleteCommand(ed, component);
  };
  AnalyticNodeDeleteCommand.prototype = Object.create(ComponentEditorCommand.prototype);
  AnalyticNodeDeleteCommand.prototype.constructor = AnalyticNodeDeleteCommand;

  /**
   * Make sure we have admin write permissions and we're not renaming a
   * frozen slot.
   *
   * @param {baja.Component} comp
   * @param {baja.Slot} slot
   * @returns {Boolean} true if I can rename this slot
   */
  AnalyticNodeDeleteCommand.prototype.canPerformCommand = function (comp, slot) {
    return this.$deleteCommand.canPerformCommand(comp, slot);
  };

  /**
   * Shows a dialog for the component's currently configured slot name,
   * and renames the slot after the user clicks OK.
   *
   * @param {baja.Component} comp
   * @param {Array.<baja.Slot>} slots the slots to rename (*Note*: only the
   * first given slot will be renamed)
   * @returns {Promise}
   */
  AnalyticNodeDeleteCommand.prototype.performCommand = function (node, slots, params) {
    var that = this;
    var jsonNode = that.$ed.value();
    var toBeDeleted = this.$slots || slots;
    var performCommand = this.$deleteCommand.performCommand(node, toBeDeleted);
    // var parentRenameNeeded = true;
    var slotFlags = {};
    _.each(toBeDeleted, function (item, index) {
      if (node.getType().is("analytics:AnalyticNodeGroup")) {
        slotFlags[item.getName()] = true;
      } else {
        slotFlags[item] = true;
      }
    });
    return performCommand.then(function (obj) {
      var action = obj[1] ? obj[1] : "cancel";
      if (action === "ok") {
        var dnObj = node.get('displayNames'),
          dMap = {};
        var keys = dnObj.list();
        _.each(keys, function (key) {
          if (!slotFlags[key]) {
            dMap[key] = dnObj.get(key).valueOf();
          }
        });
        if (!node.getType().is("analytics:AnalyticNodeGroup")) {
          // This is when the parent is root
          if (dnObj) {
            // Update the existing map
            return node.set({
              slot: "displayNames",
              value: baja.NameMap.make(dMap)
            }).then(function () {
              return that.$ed.jq().trigger(reportWidgetEvents.DELETE_GROUP_REQUEST, node);
            });
          }
        } else {
          _.each(slots, function (slot) {
            jsonNode.removeKid(slot.getName());
          });
          // eslint-disable-next-line promise/catch-or-return
          jsonNode.getKids().then(function (kidList) {
            var groupComponent = node.getParent();
            if (kidList.length === 0) {
              var gcMap = {};
              var rcObj = groupComponent.get("displayNames");
              if (rcObj) {
                var keys = rcObj.list();
                _.each(keys, function (key) {
                  if (key !== node.getName()) {
                    gcMap[key] = rcObj.get(key).valueOf();
                  }
                });
              }
              return groupComponent.remove({
                slot: node.getName()
              }).then(function () {
                return groupComponent.set({
                  slot: "displayNames",
                  value: baja.NameMap.make(gcMap)
                }).then(function () {
                  return that.$ed.jq().trigger(reportWidgetEvents.DELETE_GROUP_REQUEST, groupComponent);
                });
              });
            } else {
              if (dnObj) {
                // Update the existing map
                return node.set({
                  slot: "displayNames",
                  value: baja.NameMap.make(dMap)
                }).then(function () {
                  if (kidList.length === 1) {
                    var remainingComponent = kidList[0].getComponent();
                    if (remainingComponent.getDisplayName() === node.getDisplayName()) {
                      jsonNode.removeKid(remainingComponent.getName());
                      return node.setFlags({
                        slot: remainingComponent.getName(),
                        flags: baja.Flags.HIDDEN
                      }).then(function () {
                        return that.$ed.jq().trigger(reportWidgetEvents.DELETE_GROUP_REQUEST, {
                          data: groupComponent
                        });
                      })["catch"](baja.error);
                    }
                  }
                  return that.$ed.jq().trigger(reportWidgetEvents.RE_RENDER_NODES_REQUEST, {
                    data: jsonNode
                  });
                });
              }
            }
          });
        }
      }
    });
  };

  /**
   * Merge only if it is a delete command
   * @param comp
   * @param slot
   */
  AnalyticNodeDeleteCommand.prototype.merge = function (cmd) {
    if (cmd instanceof AnalyticNodeDeleteCommand && cmd.$slots) {
      this.$slots = _.flatten([this.$slots, cmd.$slots]);
      return this;
    }
    return null;
  };
  return AnalyticNodeDeleteCommand;
});
