/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */
define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'Promise', 'jquery', 'moment', 'dialogs', 'underscore', 'd3', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/analytics/rc/chart/utils/AnalyticsDataUtils', 'nmodule/analytics/rc/report/container/base/AnalyticsBaseReport', 'nmodule/analytics/rc/chart/aggregation/AggregationChart', 'nmodule/analytics/rc/table/AnalyticsBaseTable', 'lex!analytics', 'css!nmodule/js/rc/dialogs/dialogs'], function (baja, Widget, subscriberMixIn, Promise, $, moment, dialogs, _, d3, fe, feDialogs, AnalyticsDataUtils, AnalyticsBaseReport, AggregationChart, AnalyticsBaseTable, lexicon) {
  "use strict";

  var lex = lexicon[0];
  var AggregationReport = function AggregationReport(params) {
    AnalyticsBaseReport.apply(this, $.extend({}, params));
  };
  AggregationReport.prototype = Object.create(AnalyticsBaseReport.prototype);
  AggregationReport.prototype.constructor = AggregationReport;
  AggregationReport.prototype.getChartType = function () {
    return AggregationChart;
  };
  AggregationReport.prototype.getTableType = function () {
    return AnalyticsBaseTable;
  };

  /**
   * Get the list of settings applicable for Aggregation Chart
   * @returns {*}
   */

  AggregationReport.prototype.getApplicableSettings = function () {
    var baseSettings = AnalyticsBaseReport.prototype.getApplicableSettings.apply(this, arguments);
    return $.extend(baseSettings, {
      rollup: {
        req: false,
        value: "",
        selected: false
      },
      dataTag: {
        req: false,
        value: "hs:energy"
      },
      // rollup: {req: false, value: "last"},
      units: {
        req: false,
        value: ""
      },
      hisTotEnabled: {
        req: true,
        value: "true"
      },
      combinationMap: {
        req: true,
        value: {
          sum: ["hs:energy"],
          min: ["hs:power"],
          max: ["hs:power"],
          loadFactor: ["hs:power"]
        }
      },
      chartValue: {
        req: true,
        value: "sum"
      },
      normalization: {
        req: true,
        value: [{
          type: 'area',
          selected: false,
          value: null
        }]
      },
      extras: {
        groupLimit: 1,
        groupLimitMessage: lex.get({
          key: "aggregation.settings.nodecountlimit.content",
          args: [1]
        }),
        showColorSelector: true
      }
    });
  };

  /**
   * Returns the configuration type of the chart.
   */
  AggregationReport.prototype.getConfigType = function () {
    return "analytics:AnalyticMultiBindingReportConfiguration";
  };

  /**
   * Overridden Report name
   */
  AggregationReport.prototype.getReportName = function () {
    return lex.get("report.aggregation");
  };

  /**
   * Returns the requirement of the report to aggregate the MultiNode or MultiOrd Requests.
   * @returns {boolean}
   */
  AggregationReport.prototype.getAggMode = function () {
    return true;
  };

  /**
   * Some child reports might support multi part rollup and data tags.
   * @returns {boolean}
   */
  AggregationReport.prototype.isMultiPartSupported = function () {
    return true;
  };

  /**
   * Returns the report name
   * @returns {string}
   */
  AggregationReport.prototype.getName = function () {
    return "AggregationReport";
  };

  /**
   * This aggregates the data for Aggregation report
   * @param chartDataModel
   * @param source
   */
  AggregationReport.prototype.processDataForTable = function (chart, source) {
    return AnalyticsDataUtils.wrapDataForAggMultiChart(chart.getModel(), source.combinationMap);
  };
  return AggregationReport;
});
