/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */
define(['baja!', 'bajaux/Widget', 'bajaux/mixin/subscriberMixIn', 'Promise', 'jquery', 'moment', 'dialogs', 'underscore', 'd3', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/feDialogs', 'nmodule/analytics/rc/report/container/base/AnalyticsBaseReport', 'nmodule/analytics/rc/chart/ranking/RankingChart', 'nmodule/analytics/rc/table/AnalyticsBaseTable', 'lex!analytics', 'css!nmodule/js/rc/dialogs/dialogs'], function (baja, Widget, subscriberMixIn, Promise, $, moment, dialogs, _, d3, fe, feDialogs, AnalyticsBaseReport, RankingChart, AnalyticsBaseTable, lexicon) {
  "use strict";

  var lex = lexicon[0];
  var RankingReport = function RankingReport(params) {
    AnalyticsBaseReport.apply(this, $.extend({}, params));
  };
  RankingReport.prototype = Object.create(AnalyticsBaseReport.prototype);
  RankingReport.prototype.constructor = RankingReport;
  RankingReport.prototype.getChartType = function () {
    return RankingChart;
  };
  RankingReport.prototype.getTableType = function () {
    return AnalyticsBaseTable;
  };

  /**
   * Get the list of settings applicable for RankingReport
   * @returns {*}
   */
  /**
   * Get the list of settings applicable for RankingReport
   * @returns {*}
   */
  RankingReport.prototype.getApplicableSettings = function () {
    var baseSettings = AnalyticsBaseReport.prototype.getApplicableSettings.apply(this, arguments);
    return $.extend(baseSettings, {
      dataTag: {
        req: true,
        value: "hs:energy"
      },
      // rollup: {req: true, value: "last"},
      normalization: {
        req: true,
        value: [{
          type: 'area',
          selected: false,
          value: null
        }]
      },
      extras: {
        showColorSelector: true
      }
    });
  };

  /**
   * Overridden Report name
   */
  RankingReport.prototype.getReportName = function () {
    return lex.get("report.ranking");
  };

  /**
   * Returns the requirement of the report to aggregate the MultiNode or MultiOrd Requests.
   * @returns {boolean}
   */
  RankingReport.prototype.getAggMode = function () {
    return true;
  };

  /**
   * Returns the report name
   * @returns {string}
   */
  RankingReport.prototype.getName = function () {
    return "RankingReport";
  };
  RankingReport.prototype.showLegend = function () {
    return true;
  };

  /**
   * Returns the ord scheme specific to RelativeContributionReport.s
   * @returns {string}
   */
  RankingReport.prototype.getOrdScheme = function () {
    return "analyticMultiRollup:";
  };
  return RankingReport;
});
