/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module rc/report/fe/AnalyticDayOfWeekFE.js
 */
define(['baja!', 'lex!analytics', 'jquery', 'Promise', 'underscore', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/fe', 'bajaux/events', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor', 'nmodule/webEditors/rc/fe/baja/BooleanEditor', 'nmodule/webEditors/rc/fe/baja/FrozenEnumEditor', 'nmodule/webEditors/rc/fe/baja/NumericEditor', 'nmodule/analytics/rc/report/util/reportConstants', 'nmodule/analytics/rc/report/fe/DegreeDayGroupMapEditor', 'hbs!nmodule/analytics/rc/report/templates/UxDegreeDayEditor', 'baja!analytics:DegreeDayUnits', 'nmodule/webEditors/rc/fe/feDialogs', 'css!nmodule/analytics/rc/report/styles/uxstyles'], function (baja, lexs, $, Promise, _, Widget, fe, events, BaseEditor, ComplexCompositeEditor, BooleanEditor, FrozenEnumEditor, NumericEditor, reportConstants, DegreeDayGroupMapEditor, UxDegreeDayEditor, types, feDialogs) {
  'use strict';

  var lex = lexs[0];
  /**
   * A field editor to be used in Analytics module for selecting min, average and max color bands
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/baja/ComplexCompositeEditor
   * @alias module:nmodule/analytics/rc/report/fe/AnalyticDayOfWeekEditor
   */
  var AnalyticDegreeDayEditor = function AnalyticDegreeDayEditor(params) {
    ComplexCompositeEditor.call(this, $.extend({
      keyName: 'AnalyticDegreeDayEditor'
    }, params));
  };

  // AnalyticDegreeDayEditor.prototype = Object.create(BaseEditor.prototype);
  AnalyticDegreeDayEditor.prototype = Object.create(ComplexCompositeEditor.prototype);
  AnalyticDegreeDayEditor.prototype.constructor = AnalyticDegreeDayEditor;
  AnalyticDegreeDayEditor.prototype.getSlotFilter = function (value) {
    this.$value = value;
    return [{
      slot: 'selected',
      type: BooleanEditor,
      properties: {
        trueText: lex.get('degreeDay'),
        falseText: lex.get('degreeDay')
      }
    }, {
      slot: 'value',
      type: NumericEditor
    }, {
      slot: 'valueUnits',
      type: FrozenEnumEditor
    }, {
      slot: 'ddtype',
      type: FrozenEnumEditor
    }];
  };
  /**
   * Creates the template for Color Range Editor.
   * @param {jQuery} dom
   */
  AnalyticDegreeDayEditor.prototype.doInitialize = function (dom) {
    dom.html(UxDegreeDayEditor({
      ddtype: lex.get("degreeday.type")
    }));
    this.registerEvents();
    return ComplexCompositeEditor.prototype.doInitialize.apply(this, arguments);
  };
  AnalyticDegreeDayEditor.prototype.makeBuilder = function () {
    var that = this;
    that.builder = ComplexCompositeEditor.prototype.makeBuilder.apply(that, arguments);
    that.builder.getDomFor = function (key) {
      var jq = that.jq(),
        elem = $(".normalize-container", jq);
      switch (key) {
        case 'selected':
          return $('.degree-selected', elem);
        case 'value':
          return $('.degree-value', elem);
        case 'valueUnits':
          return $('.degree-unit', elem);
        case 'ddtype':
          return $('.degree-ddtype', elem);
      }
    };
    return that.builder;
  };
  /**
   * Register events for handling the mapping between groups and the rote node for
   * selecting 'Outside Air Temperature' for performing degree day normalization.
   */
  AnalyticDegreeDayEditor.prototype.registerEvents = function () {
    var jq = this.jq(),
      that = this;
    $('.node-map-launcher', jq).click(function (e) {
      var editor = that.getChildEditors()[0]; // Can assume safely that it points to enable/disable toggler
      // eslint-disable-next-line promise/catch-or-return
      editor.read().then(function (flag) {
        var val = that.$value;
        if (flag && val) {
          var grpList = that.properties().getValue("groups");
          return feDialogs.showFor({
            type: DegreeDayGroupMapEditor,
            title: lex.get("degreeday.map.details.title"),
            formFactor: "max",
            properties: {
              groups: grpList
            },
            value: val.getGroupMapping()
          }).then(function (ret) {
            // _.each(grpList, function (grp) {
            //     grp.tag = grp.display;
            // });
          });
        }
      });
    });
  };

  /**
   * Update the properties
   */
  AnalyticDegreeDayEditor.prototype.doUpdate = function (groupList) {
    var that = this;
    that.properties().setValue("groups", groupList);
    return Promise.resolve(true);
  };
  return AnalyticDegreeDayEditor;
});
