/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * Created by E845876 on 5/9/2017.
 */
define(['baja!', 'lex!analytics', 'jquery', 'Promise', 'underscore', 'bajaux/Widget', 'nmodule/webEditors/rc/fe/fe', 'bajaux/events', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/analytics/rc/report/fe/AnalyticUnitValueFE', 'nmodule/webEditors/rc/fe/baja/FrozenEnumEditor', 'nmodule/analytics/rc/report/fe/AnalyticDataTagEditor', 'nmodule/analytics/rc/report/fe/AnalyticDataTagSelector', 'css!nmodule/analytics/rc/report/styles/uxstyles'], function (baja, lexs, $, Promise, _, Widget, fe, events, BaseEditor, AnalyticUnitValueFE, FrozenEnumEditor, AnalyticDataTagEditor, AnalyticDataTagSelector) {
  'use strict';

  /**
   * <pre> CombinationDataMapEditor </pre>
   * This field editor is used to edit key value pairs of rollup combination like
   * min, max avg etc to a corresponding data tag like hs:energy etc.
   * <p>
   *  This will be used as an advanced setting in reports that bank on multiple exclusive
   *  bindings that need to be invoked to fetch data from station.
   * @param params
   * @constructor
   */
  var CombinationDataMapEditor = function CombinationDataMapEditor(params) {
    BaseEditor.apply(this, arguments);
  };
  CombinationDataMapEditor.prototype = Object.create(BaseEditor.prototype);
  CombinationDataMapEditor.prototype.constructor = CombinationDataMapEditor;

  /**
   * Creates the template for Combination data map Editor.
   * @param {jQuery} dom
   */
  CombinationDataMapEditor.prototype.doInitialize = function (dom) {
    var elem = $("<div class = 'cdm-container'>");
    dom.append(elem);
    return BaseEditor.prototype.doInitialize.apply(this, arguments);
  };
  /**
   * Creates the template for Combination data map Editor.
   * @param {jQuery} dom
   */
  CombinationDataMapEditor.prototype.doLoad = function (value) {
    var elem = $(".cdm-container", this.jq());
    var combinations = value.getSlots().properties().dynamic().is("analytics:AnalyticRollupDataTagItem").toValueArray();
    var promiseList = [];
    _.each(combinations, function (combination, i) {
      var combinationContainer = $("<div class = 'combo-container'>");
      combinationContainer.appendTo(elem);
      var fe1 = fe.buildFor({
        dom: $("<div class = 'dataTag-container'>").appendTo(combinationContainer),
        value: combination.getDataTag(),
        type: AnalyticDataTagSelector
      });
      var fe2 = fe.buildFor({
        dom: $("<div class = 'rollup-container'>").appendTo(combinationContainer),
        value: combination.getRollup(),
        type: FrozenEnumEditor,
        readonly: true
      });
      var fe3 = fe.buildFor({
        dom: $("<div class = 'dataUnit-container'>").appendTo(combinationContainer),
        value: {
          value: combination.getUnits(),
          isSelected: true
        },
        type: AnalyticUnitValueFE,
        properties: {
          label: "Units"
        }
      });
      promiseList.push(fe1);
      promiseList.push(fe2);
      promiseList.push(fe3);
    });
    return Promise.all(promiseList);
  };

  /**
   * Read the map of AnalyticRollupDataTagItem components.
   */
  CombinationDataMapEditor.prototype.doRead = function () {
    var that = this;
    var map = this.value(),
      itemType = "analytics:AnalyticRollupDataTagItem";
    var removeList = [];
    map.getSlots().is(itemType).each(function (slot) {
      removeList.push(map.remove(slot));
    });
    return Promise.all(removeList).then(function () {
      return that.getChildEditors().readAll().then(function (editorValues) {
        var promiseList = [];
        for (var i = 0; i < editorValues.length; i += 3) {
          var item = baja.$(itemType);
          item.setDataTag(editorValues[i]);
          var rollup = editorValues[i + 1].getOrdinal();
          item.setRollup(baja.$("analytics:Combination").make(rollup));
          var unitEditorVal = editorValues[i + 2];
          var dUnit = unitEditorVal.isSelected && unitEditorVal.value ? baja.$("baja:Unit").decodeFromString(unitEditorVal.value) : baja.Unit.DEFAULT;
          item.setUnits(dUnit);
          promiseList.push(map.add({
            value: item
          }));
        }
        return Promise.all(promiseList).then(function () {
          return map;
        });
      });
    });
  };
  return CombinationDataMapEditor;
});
