/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 *
 * Menu agent for analytics nodes. Used to register the 'Delete' and 'Rename' command.
 *
 * @module nmodule/analytics/rc/report/util/analyticGroupMenuAgent
 */
define(['bajaux/commands/Command', 'bajaux/commands/CommandGroup', 'nmodule/js/rc/asyncUtils/asyncUtils', 'baja!'], function (Command, CommandGroup, asyncUtils, baja) {
  'use strict';

  var doRequire = asyncUtils.doRequire;
  /**
   *  Return the meny agent for analytic node and group
   */
  return function analyticGroupMenuAgent(widget, nodeWrapper) {
    return doRequire(['nmodule/analytics/rc/report/command/AnalyticNodeRenameCommand', 'nmodule/analytics/rc/report/command/AnalyticNodeDeleteCommand', 'nmodule/analytics/rc/report/command/AnalyticUngroupNodesCommand', 'nmodule/analytics/rc/report/command/AnalyticNodeGroupCommand']).spread(function (AnalyticNodeRenameCommand, AnalyticNodeDeleteCommand, AnalyticUngroupNodesCommand, AnalyticNodeGroupCommand) {
      var deleteCommand;
      var group = new CommandGroup();
      var node = nodeWrapper.getComponent();
      if (node && node.getType().is("analytics:AnalyticNodeGroup")) {
        var groupSize = node.getParent().getSlots().properties().is("analytics:AnalyticNode").getSize();
        if (groupSize >= widget.groupLimit) {
          var groupCommand = new AnalyticNodeGroupCommand(widget, node);
          group.add(groupCommand);
          groupCommand.setEnabled(false);
          var unGroupCommand = new AnalyticUngroupNodesCommand(widget, node);
          group.add(unGroupCommand);
          var childrenSize = node.getSlots().properties().is("analytics:AnalyticNode").getSize();
          // Enable ungroup if you have more than 1 children.
          unGroupCommand.setEnabled(childrenSize > 1);
        }
        var renameCommand = new AnalyticNodeRenameCommand(widget, node, nodeWrapper.getIndex());
        group.add(renameCommand);
        renameCommand.setEnabled(true);
        deleteCommand = new AnalyticNodeDeleteCommand(widget, node.getParent(), {
          slots: [node.getName()]
        });
        group.add(deleteCommand);
        deleteCommand.setEnabled(true);
      } else {
        deleteCommand = new AnalyticNodeDeleteCommand(widget, node);
        group.add(deleteCommand);
        deleteCommand.setEnabled(true);
      }
      return group;
    });
  };
});
