function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/* eslint-disable no-undef */
/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/analytics/rc/command/ExportWizardCommand
 */
define(['baja!', 'jquery', 'Promise', 'dialogs', 'nmodule/js/rc/csrf/csrfUtil', 'nmodule/analytics/rc/util/analyticsUtil', 'nmodule/analytics/rc/util/DialogWizardCommand', 'bajaux/commands/Command', 'nmodule/analytics/rc/util/Tab', 'nmodule/analytics/rc/util/SimplePropertySheet', 'baja!' + 'baja:NameMap'], function (baja, $, Promise, dialogs, csrfUtil, analyticsUtil, DialogWizardCommand, Command, Tab, SimplePropertySheet) {
  "use strict";

  var CSRF_TOKEN_HEADER_KEY = csrfUtil.CSRF_TOKEN_HEADER_KEY,
    getCsrfToken = csrfUtil.getCsrfToken;

  /**
   * ExportWizardCommand helps users add additional histories to a view.
   *
   * @class
   * @alias module:nmodule/analytics/rc/command/ExportWizardCommand
   * @extends module:bajaux/commands/Command
   */
  var ExportWizardCommand = function ExportWizardCommand(widget) {
    var that = this;
    that.$widget = widget;

    //TODO: bajascript access to BIFile mime types
    this.$defaultMimeTypes = {
      csv: "text/csv;charset=utf-8",
      chart: "application/json;charset=utf-8"
    };
    DialogWizardCommand.apply(this, arguments);
  };
  ExportWizardCommand.prototype = Object.create(DialogWizardCommand.prototype);
  ExportWizardCommand.prototype.constructor = ExportWizardCommand;

  /**
   * Override resolveTab to resolve to a tab for the content.
   * @return {Promise}
   */
  ExportWizardCommand.prototype.resolveTab = function () {
    var that = this,
      widget = that.$widget;
    return analyticsUtil.resolveTitleInfo(widget).then(function (titleInfo) {
      var actionInfo = new baja.Component(),
        isWb = window.niagara && window.niagara.env && window.niagara.env.type === "wb",
        isIe = window.navigator && window.navigator.userAgent && window.navigator.userAgent.indexOf("MSIE ") > 0,
        destinationOptions = ["station"];
      actionInfo.add({
        slot: 'fileName',
        value: titleInfo.title
      });
      if (!isWb && !isIe) {
        destinationOptions.push("print");
        destinationOptions.unshift("download");
      }
      analyticsUtil.setEnumChoice(actionInfo, "destination", destinationOptions);
      analyticsUtil.setEnumChoice(actionInfo, "fileType", widget.supportedExportTypes);
      analyticsUtil.setIntegerChoice(actionInfo, "precision", 2);
      analyticsUtil.setBooleanChoice(actionInfo, "statusColumn", false);
      analyticsUtil.setBooleanChoice(actionInfo, "viewOnExport");
      var tab = new Tab({
        item: new SimplePropertySheet(),
        value: actionInfo,
        //default formalize exportSettings
        title: analyticsUtil.lex.get("analytics.ExportWizardCommand.displayName"),
        modified: function modified(modifiedActionInfo) {
          //
          that.updateOptions(modifiedActionInfo, tab);
        }
      });
      tab.loaded = function () {
        //
        that.updateOptions(actionInfo, tab);
      };
      analyticsUtil.setDisplayNames(actionInfo);
      return tab;
    });
  };
  ExportWizardCommand.prototype.updateOptions = function (actionInfo, tab) {
    var sheet = tab.widget,
      print = analyticsUtil.getChoice(actionInfo, "destination") === "print",
      toStation = analyticsUtil.getChoice(actionInfo, "destination") === "station",
      toCsv = analyticsUtil.getChoice(actionInfo, "fileType") === "csv";
    if (!sheet.jq()) {
      return;
    }
    sheet.$getRowForKey('fileType').jq().toggle(!print);
    sheet.$getRowForKey('fileName').jq().toggle(!print);
    sheet.$getRowForKey('viewOnExport').jq().toggle(toStation);
    sheet.$getRowForKey('viewOnExport').jq().toggle(toStation);
    sheet.$getRowForKey('statusColumn').jq().toggle(toCsv);
    sheet.$getRowForKey('statusColumn').jq().toggle(toCsv);
    return actionInfo;
  };
  ExportWizardCommand.prototype.handleRead = function (tab) {
    var that = this,
      widget = that.$widget;
    return tab.read().then(function (actionInfo) {
      var fileName = actionInfo.get("fileName"),
        fileType = analyticsUtil.getChoice(actionInfo, "fileType"),
        destination = analyticsUtil.getChoice(actionInfo, "destination"),
        fullFileName = fileName + "." + fileType,
        checkFilePath,
        saveFilePath,
        lex = analyticsUtil.bajaLex,
        analyticsLex = analyticsUtil.lex,
        precision = actionInfo.get("precision"),
        lexText;
      if (precision && precision < 0) {
        lexText = analyticsLex.get("precisionCannotBeNegative");
        analyticsUtil.showError(lexText);
        throw new Error(lexText);
      }
      if (destination === "download" && !analyticsUtil.isValidName(fileName) || destination === "station" && !analyticsUtil.isValidPath(fileName)) {
        lexText = lex.get("IllegalNameException.name", fileName);
        widget.jq().trigger("analytics:error", lexText);
        // eslint-disable-next-line promise/no-return-wrap
        return Promise.reject(lexText);
      }
      if (destination === "print") {
        setTimeout(function () {
          window.print();
        }, 100);
        return;
      }
      if (destination === "station") {
        checkFilePath = "/file/charts/" + fullFileName;
        saveFilePath = "/analytics/file/save/charts/" + fullFileName;
        //TODO: file path chooser when file space is supported in nav tree
        return analyticsUtil.checkPermissions("file:^charts/" + fullFileName, baja.Permissions.ADMIN_WRITE).then(function () {
          return analyticsUtil.confirmServerFileWrite(checkFilePath);
        }).then(function (confirmed) {
          if (confirmed) {
            return Promise.resolve(widget.makeExport(fileType, actionInfo)).then(function (content) {
              return analyticsUtil.ajax(saveFilePath, {
                type: "POST",
                headers: _defineProperty({}, CSRF_TOKEN_HEADER_KEY, getCsrfToken()),
                contentType: that.getMimeType(fileType),
                data: content
              });
            }).then(function () {
              if (analyticsUtil.getChoice(actionInfo, "viewOnExport")) {
                var hyperlinkLocation = "file:^charts/" + fullFileName,
                  isWb = window.niagara && window.niagara.env && window.niagara.env.type === "wb";
                if (!isWb) {
                  hyperlinkLocation = "/ord?" + analyticsUtil.safeOrd(hyperlinkLocation);
                }
                if (fileType === "achart") {
                  hyperlinkLocation += "|view:analytics:SpectrumUxChart";
                } else if (fileType === "csv" && !isWb) {
                  hyperlinkLocation = checkFilePath; //use file servlet in browser
                }
                if (window.niagara && window.niagara.env && isWb) {
                  window.niagara.env.hyperlink(hyperlinkLocation);
                } else {
                  var top = baja.topWindow();
                  if (window.self !== top) {
                    top.location.assign(hyperlinkLocation);
                  } else {
                    window.location.assign(hyperlinkLocation);
                  }
                }
              }
            });
          } else {
            // eslint-disable-next-line promise/no-return-wrap,prefer-promise-reject-errors
            return Promise.reject("");
          }
        })["catch"](function (err) {
          if (err) {
            lexText = analyticsLex.get("analytics.exportFailure", fullFileName, err);
            widget.jq().trigger("analytics:error", lexText);
            baja.error(err);
          }
        });
      }
      if (destination === "download") {
        // Download the chart.

        Promise.resolve(widget.makeExport(fileType, actionInfo)).then(function (content) {
          that.download(content, fileType, fullFileName);
        })["catch"](baja.error);
      }
    })["catch"](function (err) {
      baja.error(err);
      throw err;
    });
  };
  ExportWizardCommand.prototype.download = function (content, fileType, fileName) {
    var that = this,
      blob = analyticsUtil.createBlob([content], {
        type: that.getMimeType(fileType)
      }),
      a = $("<a/>").attr("href", URL.createObjectURL(blob)).attr('download', fileName);

    //IE11 requires this; Edge is uses this too because it ends up with a uuid as the fileName for the a.download
    if (window.navigator && typeof window.navigator.msSaveBlob === 'function') {
      window.navigator.msSaveBlob(blob, fileName);
    } else {
      analyticsUtil.click(a);
    }
  };
  ExportWizardCommand.prototype.getMimeType = function (fileType) {
    return this.$defaultMimeTypes[fileType];
  };

  /**
   * Override to set lexicon parameters
   * @param obj
   * @returns {{}}
   */
  ExportWizardCommand.prototype.lexParams = function (obj) {
    return {
      module: "analytics",
      lex: "analytics.ExportWizardCommand"
    };
  };
  ExportWizardCommand.prototype.options = function () {
    return baja.Facets.make();
  };
  return ExportWizardCommand;
});
