/**
 * @copyright 2018 Tridium, Inc. All Rights Reserved.
 */

/**
 * Created by H129264 on 14-Jun-16.
 */
define(['d3', 'jquery', 'underscore', 'moment', 'nmodule/analytics/rc/util/analyticsUtil', 'lex!analytics', 'baja!' + 'gx:Color,' + 'baja:Status'], function (d3, $, _, moment, analyticsUtil, lexicon) {
  "use strict";

  var ModelFactory = {},
    lex = lexicon[0];
  var FULL_TIMESTAMP_FORMAT = 'MMMM Do YYYY, h:mm:ss a';
  /**
   *
   * @param chart
   * @param params
   */
  ModelFactory.newBaseDataModel = function (chart, params) {
    var ChartObject = chart.getDataModel ? chart.getDataModel() : chart.prototype.getDataModel();
    return new ChartObject(params);
  };

  /**
   *
   * @param chart
   * @param params
   */
  ModelFactory.newConfigModel = function (chart, params) {
    var ChartObject = chart.getTabModelType ? chart.getTabModelType() : chart.prototype.getTabModelType();
    return new ChartObject(params);
  };

  /**
   *
   * @param chart
   * @param params
   */
  ModelFactory.newMultiNodeDataModel = function (chart, params) {};
  function getTooltip(data, defTitleFrmt, defValFrmt, color, metaData, chart, showInterpolationStatus) {
    var curMetaObj = {},
      inData = data[0];
    _.each(metaData, function (eachMeta) {
      if (eachMeta[0] === inData.id) {
        curMetaObj = eachMeta[1];
      }
    });
    var metaString = showInterpolationStatus ? '<td class="metaData">' + curMetaObj.interpolationStatus + '</td>' : "",
      relContribString = "";
    if (chart === "RelativeContributionChart") {
      relContribString = inData.ratio ? '<td class="value">' + defValFrmt(inData.value, inData.ratio, inData.id) + '</td>' : "";
    }
    return '<table class="c3-tooltip">' + '<tbody>' + '<tr class="c3-tooltip-name--' + inData.id + '">' + '<td class="name">' + '<span style="background-color:' + color(inData.id) + '"></span>' + inData.name + '</td>' + '<td class="value">' + analyticsUtil.standardizeInput(inData.value) + '</td>' + relContribString + metaString + '</tr>' + '</tbody>' + '</table>';
  }
  function getGroupedTooltip(data, defTitleFrmt, defValFrmt, color, metaData, chart, showInterpolationStatus) {
    _.each(metaData, function (eachMeta) {
      _.each(data, function (inData) {
        if (eachMeta[0] === inData.id) {
          inData.metaData = eachMeta[inData.index + 1];
        }
      });
    });
    if (chart === "AggregationChart" || chart === "AnalyticWebChart") {
      defTitleFrmt = function defTitleFrmt(d) {
        return moment(d).format(FULL_TIMESTAMP_FORMAT);
      };
    }
    //Check for Baseline data if present increase column by 1
    var defCols = 2,
      isBaseline = false;
    _.find(data, function (inD) {
      if (inD.metaData.blDate) {
        defCols += 1;
        isBaseline = true;
        return false;
      }
    });
    var headerString = '<tr><th colspan="' + (showInterpolationStatus ? defCols + 1 : defCols) + '">' + defTitleFrmt(data[0].x) + '</th></tr>';
    var x1 = '<table class="c3-tooltip">' + '<tbody>' + headerString;
    _.each(data, function (inD) {
      var metaString = showInterpolationStatus ? '<td class="metaData">' + inD.metaData.interpolationStatus + '</td>' : "";
      //If Baseline present fill the tooltip data for baseline
      if (isBaseline) {
        if (inD.metaData.blDate) {
          x1 += '<tr class="c3-tooltip-name--' + inD.id + '">' + '<td class="name">' + '<span style="background-color:' + color(inD.id) + '"></span>' + inD.name.split(" TR [")[0] + '</td>' + '<td class="value">' + analyticsUtil.standardizeInput(inD.value) + '</td>' + metaString;
          x1 += '<td class="metaData">' + moment(inD.metaData.blDate).format(FULL_TIMESTAMP_FORMAT) + '</td>' + '</tr>';
        } else {
          x1 += '<tr class="c3-tooltip-name--' + inD.id + '">' + '<td class="name">' + '<span style="background-color:' + color(inD.id) + '"></span>' + inD.name + '</td>' + '<td class="value">' + analyticsUtil.standardizeInput(inD.value) + '</td>' + metaString;
          x1 += '<td class="metaData"> </td>' + '</tr>';
        }
      } else {
        x1 += '<tr class="c3-tooltip-name--' + inD.id + '">' + '<td class="name">' + '<span style="background-color:' + color(inD.id) + '"></span>' + inD.name + '</td>' + '<td class="value">' + analyticsUtil.standardizeInput(inD.value) + '</td>' + metaString;
      }
    });
    return x1 + '</tbody>' + '</table>';
  }
  function trimGrpName(chart, grpName) {
    if (chart === "RankingChart" && grpName.length > 14) {
      grpName = grpName.substring(0, 14) + lex.get("report.chart.tickMaxSize.delimiter");
    }
    return grpName;
  }
  function yTickFormat(value) {
    return analyticsUtil.standardizeInput(value);
  }
  function applySpecificConfig(c3Ob, baseChart, inputObj) {
    var types = inputObj.types,
      colors = inputObj.colors,
      chart = baseChart.getName(),
      metaData = inputObj.metaData;

    //data
    c3Ob.data.types = types;
    c3Ob.data.colors = colors;
    c3Ob.axis.x = {
      tick: {
        centered: true
      }
    };
    if (_.contains(["RankingChart", "RelativeContributionChart"], chart)) {
      c3Ob.tooltip.grouped = false;
      c3Ob.data.groups = [inputObj.groups];
      c3Ob.data.names = inputObj.names;
      c3Ob.axis.x.tick = {
        format: function format(d) {
          return trimGrpName(chart, inputObj.names[inputObj.groups[d]]);
        },
        culling: false
      };
      //TODO: Have to put a proper scale
      if (inputObj.columns.length > 10) {
        c3Ob.axis.x.tick.culling = true;
      }
      if (chart === "RelativeContributionChart") {
        c3Ob.pie = {
          label: {
            threshold: 0.01
          }
        };
      }
      c3Ob.tooltip.contents = function (data, defTitleFrmt, defValFrmt, color) {
        return getTooltip(data, defTitleFrmt, defValFrmt, color, metaData, chart, baseChart.showInterpolationStatus);
      };
    } else {
      c3Ob.tooltip.grouped = true;
      c3Ob.data.xs = inputObj.xs;
      c3Ob.data.xFormat = '%d-%b-%y %I:%M %p';
      c3Ob.data.names = inputObj.names;

      //x axis
      if (chart !== "AnalyticWebChart") {
        if (baseChart.getXTickFormat) {
          c3Ob.axis.x.tick.format = baseChart.getXTickFormat;
        }
      }
      if (chart === "AggregationChart") {
        if (inputObj.columns && inputObj.columns[0]) {
          var columnLength = inputObj.columns[0].length - 1,
            allocationPerBar = baseChart.availableWidth() / columnLength,
            paddingRatio = 1 - 0.7,
            barWidth = paddingRatio * allocationPerBar; // 50% of the fitting width, will provide padding space.
          c3Ob.bar = {
            width: barWidth
          };
        }
        c3Ob.axis.x.type = "timeseries";
        c3Ob.axis.x.tick.fit = false;
      }
      c3Ob.axis.x.type = baseChart.getXAxisType();
      c3Ob.axis.x.label = {
        text: baseChart.getXAxisLabel(),
        position: baseChart.getXAxisLabelPosition()
      };
      c3Ob.tooltip.contents = function (data, defTitleFrmt, defValFrmt, color) {
        return getGroupedTooltip(data, defTitleFrmt, defValFrmt, color, metaData, chart, baseChart.showInterpolationStatus);
      };
      if (chart === "AverageProfileChart" || chart === "AnalyticWebChart") {
        if (baseChart.getXTickFormat === undefined || baseChart.getXTickFormat) {
          c3Ob.axis.x.type = "timeseries";
          c3Ob.axis.x.tick.fit = false;
        }
      }
    }
    //y axis
    c3Ob.axis.y.tick = {
      format: yTickFormat
    };
    c3Ob.axis.y.label = {
      text: '',
      position: baseChart.getYAxisLabelPosition()
    };

    //y2 axis
    c3Ob.axis.y2.tick = {
      format: yTickFormat
    };
    c3Ob.axis.y2.label = {
      text: '',
      position: baseChart.getY2AxisLabelPosition()
    };
    return c3Ob;
  }

  //@returns {{size: {width: (number|*), height: (number|*)}, bindto: *, data: {xs: *, xFormat: string, columns: *, colors: *, types: *, axes, names: *}, tooltip: {format: {value: (n: (number | {valueOf(): number})) => string}}, grid: {x: {show: boolean}, y: {show: boolean}}, legend: {position: string}, zoom: {enabled: boolean}, axis: {x: {type: (string), label: {text: *, position: (string|*)}, tick: {centered: boolean}}, y: {show: boolean, tick: {format: (n: (number | {valueOf(): number})) => string}, label: {text: (Array|*), position: (string|*)}}, y2: {show: boolean, tick: {format: (n: (number | {valueOf(): number})) => string}, label: {text: (Array|*), position: (string|*)}}}}}
  /**
   *
   * @param baseChart
   * @param series
   * @param inputObj
   * @returns {object}
   */
  ModelFactory.getC3RenderObj = function (baseChart, series, inputObj) {
    var dom = baseChart.jq().find(".chartArea")[0],
      columns = inputObj.columns,
      y2 = inputObj.y2,
      c3Ob = {
        size: {
          width: baseChart.availableWidth(),
          height: baseChart.availableHeight()
        },
        bindto: dom,
        data: {
          columns: columns,
          axes: function () {
            var ob = {};
            _.each(y2, function (eachY2, index) {
              ob[eachY2] = 'y2';
            });
            return ob;
          }()
        },
        tooltip: {},
        grid: {
          x: {
            show: true
          },
          y: {
            show: true
          }
        },
        legend: {
          position: baseChart.getTabConfigDataModel().getLegendPosition(),
          show: baseChart.getTabConfigDataModel().getLegendPosition() !== "none"
        },
        zoom: {
          enabled: true
        },
        axis: {
          y: {
            label: '',
            show: !_.isEmpty(inputObj.yLabel)
          },
          y2: {
            label: '',
            show: !_.isEmpty(y2)
          }
        }
      };
    return applySpecificConfig(c3Ob, baseChart, inputObj);
  };
  return ModelFactory;
});
