function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/schedule/rc/baja/fe/ActiveDatesCalendar
 */
define(['baja!', 'lex!schedule', 'bajaux/commands/Command', 'bajaux/mixin/responsiveMixIn', 'bajaux/util/CommandButtonGroup', 'jquery', 'moment', 'Promise', 'underscore', 'nmodule/js/rc/switchboard/switchboard', 'nmodule/schedule/rc/servlets/ssc', 'nmodule/schedule/rc/util/scheduleUtils', 'nmodule/webEditors/rc/fe/baja/compat/PikadayDateEditor', 'nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/config/CompositeBuilder'], function (baja, lexs, Command, responsiveMixIn, CommandButtonGroup, $, moment, Promise, _, switchboard, ssc, scheduleUtils, PikadayDateEditor, CompositeEditor, CompositeBuilder) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    scheduleLex = _lexs[0];
  var tpl = function tpl(ed) {
    return "\n    <div class=\"commands\"></div>\n    <div class=\"calendars\"></div>";
  };
  var widgetDefaults = function widgetDefaults() {
    var startDate = moment().startOf('month').toDate();
    return {
      properties: {
        startDate: startDate,
        endDate: moment(startDate).add(6, 'months').toDate()
      }
    };
  };

  /**
   * This calendar retrieves and displays the effective/highlighted dates for
   * a particular schedule and date range. It will show one calendar widget
   * per month with the dates highlighted.
   *
   * It uses the `bajaux` `Properties` `startDate` and `endDate` to indicate
   * the date range to display. These `Properties` can be changed at any time
   * to change the displayed range.
   *
   * If this calendar is not readonly, emits 'dateSelected' tinyevent when a
   * date is selected.
   *
   * @class
   * @alias module:nmodule/schedule/rc/baja/fe/ActiveDatesCalendar
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   * @param {Object} params
   * @param {Boolean} [params.readonly]
   * @param {Object} [params.properties]
   * @param {baja.Date} [params.properties.startDate]
   * @param {baja.Date} [params.properties.endDate]
   */
  var ActiveDatesCalendar = function ActiveDatesCalendar(params) {
    var _this = this;
    CompositeEditor.call(this, {
      params: params,
      defaults: widgetDefaults()
    });
    var props = this.properties(),
      startDate = props.getValue('startDate'),
      endDate = props.getValue('endDate');
    if (startDate > endDate) {
      throw new Error('start date cannot be after end date');
    }
    this.$getEvents = _.memoize(function () {
      var sched = _this.value();
      if (!sched) {
        return Promise.resolve([]);
      }
      return ssc.getHighlightedDates(_this.properties().getValue('sourceOrd'), scheduleUtils.appendRefBase(sched, _this.properties().getValue('refBase')), momentToBajaDate(_this.$getStartMoment()), momentToBajaDate(_this.$getEndMoment())).then(function (dates) {
        return dates.map(isoToBajaDate);
      });
    });
    this.getCommandGroup().add(new Command({
      displayName: scheduleLex.get('calendar.prevPage'),
      icon: scheduleLex.get('commands.prevPage.icon'),
      func: function func() {
        return _this.$moveMonths(-_this.$getPageSize());
      }
    }), new Command({
      displayName: scheduleLex.get('calendar.prevMonth'),
      icon: scheduleLex.get('commands.prevMonth.icon'),
      func: function func() {
        return _this.$moveMonths(-1);
      }
    }), new Command({
      displayName: scheduleLex.get('calendar.today'),
      icon: scheduleLex.get('commands.today.icon'),
      func: function func() {
        return _this.$moveMonths(moment().startOf('month').diff(_this.$getStartMoment().startOf('month'), 'months'));
      }
    }), new Command({
      displayName: scheduleLex.get('calendar.nextMonth'),
      icon: scheduleLex.get('commands.nextMonth.icon'),
      func: function func() {
        return _this.$moveMonths(1);
      }
    }), new Command({
      displayName: scheduleLex.get('calendar.nextPage'),
      icon: scheduleLex.get('commands.nextPage.icon'),
      func: function func() {
        return _this.$moveMonths(_this.$getPageSize());
      }
    }));
    switchboard(this, {
      '$rebuildCalendars': {
        allow: 'oneAtATime',
        onRepeat: 'preempt'
      }
    });
    responsiveMixIn(this, {
      /* Hide the prev / next page since at this point only one calendar displays */
      'active-dates-calendar-sm': {
        maxWidth: 395
      }
    });
  };
  ActiveDatesCalendar.prototype = Object.create(CompositeEditor.prototype);
  ActiveDatesCalendar.prototype.constructor = ActiveDatesCalendar;
  ActiveDatesCalendar.prototype.doChanged = function (name) {
    switch (name) {
      case 'startDate':
      case 'endDate':
        this.$dememoize();
        break;
    }
  };

  /**
   * @returns {module:nmodule/webEditors/rc/fe/config/CompositeBuilder}
   */
  ActiveDatesCalendar.prototype.makeBuilder = function () {
    var _this2 = this;
    var builder = new CompositeBuilder(),
      $loadFor = builder.$loadFor;
    builder.getKeys = function () {
      // One key for the command group, and one key for each displayed month.
      var start = _this2.$getStartMoment(),
        end = _this2.$getEndMoment(),
        keys = [];
      while (start.isBefore(end)) {
        keys.push(toISO(start));
        start = start.add(1, 'months');
      }
      return ['commands'].concat(keys);
    };
    builder.getValueFor = function (key) {
      if (key === 'commands') {
        return _this2.getCommandGroup();
      }
      return momentToBajaDate(moment(key).date(1));
    };
    builder.getConfigFor = function (key) {
      if (key === 'commands') {
        return {
          type: CommandButtonGroup,
          properties: {
            toolbar: true
          }
        };
      }
      return Promise.resolve(_this2.$getEvents()).then(function (events) {
        return {
          type: PikadayDateEditor,
          readonly: _this2.isReadonly(),
          properties: {
            embedded: true,
            events: events,
            onSelect: function onSelect(editor, selection) {
              _this2.$onSelect(editor, selection);
            },
            singleMonth: true
          }
        };
      });
    };
    builder.getDomFor = function (key) {
      var container = key === 'commands' ? key : 'calendars';
      return $('<div/>').appendTo(_this2.jq().children('.' + container));
    };

    //TODO: these are all layout hacks. should go in PikadayDateEditor
    builder.$loadFor = function (key, params) {
      return $loadFor.call(builder, key, params).then(function () {
        if (key !== 'commands') {
          var dom = builder.getEditorFor(key).jq();
          dom.find('.is-selected').removeClass('is-selected');
        }
      });
    };
    return builder;
  };

  /**
   * @param {jQuery} dom
   * @returns {Promise}
   */
  ActiveDatesCalendar.prototype.doInitialize = function (dom) {
    dom.addClass('ActiveDatesCalendar').html(tpl(this));
    return CompositeEditor.prototype.doInitialize.apply(this, arguments);
  };

  //TODO: NCCB-27641: how can we better propagate properties down
  /**
   * Ensures that existing calendars get correctly wiped when a new schedule
   * is loaded.
   * @param {baja.Component|null} sched a `schedule:AbstractSchedule` we can
   * show active dates on; or null to just load a bunch of empty calendars
   * @returns {Promise}
   */
  ActiveDatesCalendar.prototype.doLoad = function (sched) {
    var _this3 = this;
    var args = arguments,
      callSuper = function callSuper() {
        return CompositeEditor.prototype.doLoad.apply(_this3, args);
      };
    if (!sched) {
      return callSuper();
    }
    var builder = this.getBuilder(),
      dateKeys = this.$getDateKeys();
    this.$dememoize();
    return Promise.all(dateKeys.map(function (key) {
      return builder.destroyFor(key);
    })).then(callSuper);
  };

  /**
   * @returns {Promise}
   */
  ActiveDatesCalendar.prototype.doDestroy = function () {
    this.jq().removeClass('ActiveDatesCalendar');
    return CompositeEditor.prototype.doDestroy.apply(this, arguments);
  };
  ActiveDatesCalendar.prototype.doLayout = function () {
    var calendars = this.$getCalendars(),
      numberOfCalendars = calendars.length;
    if (numberOfCalendars) {
      var calendarsDiv = this.jq().children('.calendars'),
        calendarHeight = calendars[0].jq().height(),
        calendarWidth = calendars[0].jq().width(),
        expectedNumberOfCalendars = Math.floor(this.jq().width() / calendarWidth);
      calendarsDiv.height(calendarHeight);
      if (expectedNumberOfCalendars > numberOfCalendars) {
        var endMoment = this.$getEndMoment(),
          fudgeFactor = 2,
          monthsToAdd = expectedNumberOfCalendars - numberOfCalendars + fudgeFactor,
          newEndMoment = endMoment.add(monthsToAdd, 'months');
        this.properties().setValue('endDate', newEndMoment.toDate());
        return this.$moveMonths(0);
      }
    }
  };

  /**
   * Select a date.
   *
   * This will select the specified date, fire the selectedDateChanged event,
   * and make the selected month be the left-most calendar if more than one
   * calendar is being displayed.
   *
   * @param {Date} jsDate
   * @returns {Promise<any>}
   */
  ActiveDatesCalendar.prototype.selectDate = function (jsDate) {
    var _this4 = this;
    return this.$moveMonths(moment(jsDate).startOf('month').diff(this.$getStartMoment().startOf('month'), 'months')).then(function () {
      return _this4.$getCalendars()[0].$getPicker().setDate(jsDate);
    });
  };

  /**
   * @private
   * @returns {module:bajaux/commands/Command} the "prev page" command
   */
  ActiveDatesCalendar.prototype.$getPrevPageCommand = function () {
    return this.getCommandGroup().get(0);
  };

  /**
   * @private
   * @returns {module:bajaux/commands/Command} the "prev month" command
   */
  ActiveDatesCalendar.prototype.$getPrevMonthCommand = function () {
    return this.getCommandGroup().get(1);
  };

  /**
   * @private
   * @returns {module:bajaux/commands/Command} the "today" command
   */
  ActiveDatesCalendar.prototype.$getTodayCommand = function () {
    return this.getCommandGroup().get(2);
  };

  /**
   * @private
   * @returns {module:bajaux/commands/Command} the "next month" command
   */
  ActiveDatesCalendar.prototype.$getNextMonthCommand = function () {
    return this.getCommandGroup().get(3);
  };

  /**
   * @private
   * @returns {module:bajaux/commands/Command} the "next page" command
   */
  ActiveDatesCalendar.prototype.$getNextPageCommand = function () {
    return this.getCommandGroup().get(4);
  };

  /**
   * @private
   * @returns {Array.<string>} builder keys for individual calendar widgets
   */
  ActiveDatesCalendar.prototype.$getDateKeys = function () {
    return _.without(this.getBuilder().getKeys(), 'commands');
  };

  /**
   * Shift the displayed date range.
   * @private
   * @param {number} months number of months to shift
   * @returns {Promise} to be resolved after the new date range has been
   * displayed
   */
  ActiveDatesCalendar.prototype.$moveMonths = function (months) {
    var props = this.properties(),
      keysToDestroy = this.$getDateKeys();
    props.setValue('startDate', this.$getStartMoment().add(months, 'months').toDate());
    props.setValue('endDate', this.$getEndMoment().add(months, 'months').toDate());
    this.$dememoize();
    return this.$rebuildCalendars(keysToDestroy);
  };

  /**
   * @private
   * @param {Array.<String>} keysToDestroy date keys that need to be wiped
   * @returns {Promise}
   */
  ActiveDatesCalendar.prototype.$rebuildCalendars = function (keysToDestroy) {
    var _this5 = this;
    var builder = this.getBuilder();
    //TODO: do this without completely obliterating/rebuilding child calendars
    return Promise.all(keysToDestroy.map(function (key) {
      return builder.destroyFor(key);
    })).then(function () {
      return Promise.all(_this5.$getDateKeys().map(function (key) {
        return builder.$loadFor(key);
      }));
    });
  };

  /**
   * @private
   * @returns {number} how many calendars currently displayed on a page
   */
  ActiveDatesCalendar.prototype.$getPageSize = function () {
    var calendars = this.$getCalendars(),
      widgetWidth = this.jq().width(),
      calendarWidth = calendars[0].jq().width();
    return Math.min(Math.max(Math.floor(widgetWidth / calendarWidth), 1), calendars.length);
  };

  /**
   * @private
   * @returns {moment} current start date as Moment
   */
  ActiveDatesCalendar.prototype.$getStartMoment = function () {
    return moment(this.properties().getValue('startDate'));
  };

  /**
   * @private
   * @returns {moment} current end date as Moment
   */
  ActiveDatesCalendar.prototype.$getEndMoment = function () {
    return moment(this.properties().getValue('endDate'));
  };

  /**
   * @private
   * @returns {Array.<module:nmodule/webEditors/rc/fe/baja/compat/PikadayDateEditor>} all
   * currently displayed calendar widgets
   */
  ActiveDatesCalendar.prototype.$getCalendars = function () {
    return this.getChildEditors({
      type: PikadayDateEditor
    });
  };
  ActiveDatesCalendar.prototype.$dememoize = function () {
    this.$getEvents.cache = {}; //de-memoize so will call up to rpc again
  };

  /**
   * @private
   * @param {PikadayDateEditor} editor calendar that had an item selected.
   * @param {baja.Date} selection - the date that was selected
   */
  ActiveDatesCalendar.prototype.$onSelect = function (editor, selection) {
    // A date was selected; all other pikaday editors need to be
    // deselected, and then an event needs to be published.

    // Iterate through the calendars and clear the selections that aren't this selection.
    this.$getCalendars().forEach(function (calendar) {
      if (calendar !== editor) {
        calendar.clearSelection();
      }
    });
    this.emit('selectedDateChanged', selection);
  };

  /**
   * @param {moment} m
   * @returns {string}
   */
  function toISO(m) {
    return m.format('YYYY-MM-DD');
  }

  /**
   * @param {string} iso
   * @returns {baja.Date}
   */
  function isoToBajaDate(iso) {
    return momentToBajaDate(moment(iso));
  }

  /**
   * @param {moment} m
   * @returns {baja.Date}
   */
  function momentToBajaDate(m) {
    return baja.Date.make({
      year: m.year(),
      month: m.month(),
      day: m.date()
    });
  }
  return ActiveDatesCalendar;
});
