function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

/**
 * API Status: **Private**
 * @module nmodule/schedule/rc/baja/fe/TriggerDayEditor
 */
define(['lex!schedule', 'bajaux/events', 'bajaux/commands/Command', 'bajaux/util/CommandButtonGroup', 'dialogs', 'Promise', 'nmodule/schedule/rc/baja/fe/TimeScheduleTableModel', 'nmodule/schedule/rc/baja/fe/TriggerTimesToAddEditor', 'nmodule/webEditors/rc/fe/CompositeEditor', 'nmodule/webEditors/rc/fe/config/CompositeBuilder', 'nmodule/webEditors/rc/wb/table/Table'], function (lexs, events, Command, CommandButtonGroup, dialogs, Promise, TimeScheduleTableModel, TriggerTimesToAddEditor, CompositeEditor, CompositeBuilder, Table) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    scheduleLex = _lexs[0],
    MODIFY_EVENT = events.MODIFY_EVENT;
  var tpl = function tpl(ed) {
    return "\n    <div class=\"triggerListContainer\">\n      <table class=\"triggerList ux-table ux-select-none no-stripe\"></table>\n    </div>\n    <div class=\"rangeSettings\"></div>\n    <div class=\"commands\"></div>";
  };

  /**
   * This editor displays and edits the list of trigger times configured on a
   * `DaySchedule`, typically as the `times` slot on a `TriggerSchedule`.
   *
   * @class
   * @extends module:nmodule/webEditors/rc/fe/CompositeEditor
   * @alias module:nmodule/schedule/rc/baja/fe/TriggerDayEditor
   */
  var TriggerDayEditor = function TriggerDayEditor() {
    var _this = this;
    CompositeEditor.apply(this, arguments);
    this.getCommandGroup().add(new Command({
      displayName: scheduleLex.get('trigger.add'),
      enabled: !this.isReadonly() && this.isEnabled(),
      func: function func() {
        return _this.$applyRange()["catch"](dialogs.showOk);
      }
    }), new Command({
      displayName: scheduleLex.get('trigger.remove'),
      enabled: false,
      func: function func() {
        return _this.$removeSelectedRows();
      }
    }));
    // interval setting can be invalid - doesn't invalidate this editor
    this.validators().get().forEach(function (v) {
      return _this.validators().remove(v);
    });
  };
  TriggerDayEditor.prototype = Object.create(CompositeEditor.prototype);
  TriggerDayEditor.prototype.constructor = TriggerDayEditor;

  /**
   * @param {jQuery} dom
   */
  TriggerDayEditor.prototype.doInitialize = function (dom) {
    dom.addClass('TriggerDayEditor').html(tpl(this));
    dom.on(MODIFY_EVENT, '.rangeSettings', false);
  };

  /**
   * Make a table to contain the trigger time list, an editor for the range
   * settings, and a command group for the add/remove commands.
   *
   * @returns {module:nmodule/webEditors/rc/fe/config/CompositeBuilder}
   */
  TriggerDayEditor.prototype.makeBuilder = function () {
    var _this2 = this;
    var builder = new CompositeBuilder();
    builder.getKeys = function () {
      return ['triggerList', 'rangeSettings', 'commands'];
    };
    builder.getConfigFor = function (key) {
      switch (key) {
        case 'triggerList':
          return {
            type: Table
          };
        case 'rangeSettings':
          return {
            type: TriggerTimesToAddEditor
          };
        case 'commands':
          return {
            type: CommandButtonGroup
          };
      }
    };
    builder.getDomFor = function (key) {
      return _this2.jq().find('.' + key);
    };
    builder.getValueFor = function (key) {
      switch (key) {
        case 'triggerList':
          return new TimeScheduleTableModel(_this2.value());
        case 'rangeSettings':
          return TriggerTimesToAddEditor.makeComponent();
        case 'commands':
          return _this2.getCommandGroup();
      }
    };
    return builder;
  };

  /**
   * @returns {Promise}
   */
  TriggerDayEditor.prototype.doLoad = function () {
    var _this3 = this;
    return CompositeEditor.prototype.doLoad.apply(this, arguments).then(function () {
      var selection = _this3.$getTriggerListTable().$getSelection();
      selection.on('changed', function () {
        return _this3.$getRemoveCommand().setEnabled(!selection.isEmpty() && !_this3.isReadonly() && _this3.isEnabled());
      });
    });
  };
  TriggerDayEditor.prototype.doEnabled = function (enabled) {
    this.$getAddCommand().setEnabled(!this.isReadonly() && enabled);
    return this.getChildWidgets().setAllEnabled(enabled);
  };
  TriggerDayEditor.prototype.doReadonly = function (readonly) {
    this.$getAddCommand().setEnabled(this.isEnabled() && !readonly);
    return this.getChildWidgets().setAllReadonly(readonly);
  };

  /**
   * @returns {Promise}
   */
  TriggerDayEditor.prototype.doDestroy = function () {
    this.jq().removeClass('TriggerDayEditor');
    return CompositeEditor.prototype.doDestroy.apply(this, arguments);
  };

  /**
   * Add new times to the current list of trigger times. Any existing times will
   * not be added a second time. If any new times were added, will wipe the
   * existing table selection and mark the editor as modified.
   *
   * @private
   * @param {Array.<baja.Time>} times
   * @returns {Promise} promise to be resolved after adding times
   */
  TriggerDayEditor.prototype.$addTimes = function (times) {
    var _this4 = this;
    var table = this.$getTriggerListTable();
    return table.value().addTimes(times).then(function (added) {
      if (added) {
        _this4.setModified(true);
        table.$getSelection().clear();
      }
    });
  };

  /**
   * Read the current user-entered time/range settings and add to the list.
   *
   * @private
   * @returns {Promise}
   */
  TriggerDayEditor.prototype.$applyRange = function () {
    var _this5 = this;
    return this.$getRangeSettingsEditor().validate().then(function (times) {
      return _this5.$addTimes(times);
    });
  };

  /**
   * Remove selected trigger times from the list.
   *
   * @returns {Promise}
   */
  TriggerDayEditor.prototype.$removeSelectedRows = function () {
    var _this6 = this;
    var table = this.$getTriggerListTable(),
      tableModel = table.value(),
      rows = tableModel.getRows(),
      selectedRows = table.$getSelection().getSelectedElements(rows);
    if (selectedRows.length) {
      return tableModel.removeRows(selectedRows).then(function () {
        return _this6.setModified(true);
      });
    } else {
      return Promise.resolve();
    }
  };

  /**
   * @private
   * @returns {module:bajaux/commands/Command}
   */
  TriggerDayEditor.prototype.$getAddCommand = function () {
    return this.getCommandGroup().get(0);
  };

  /**
   * @private
   * @returns {module:bajaux/commands/Command}
   */
  TriggerDayEditor.prototype.$getRemoveCommand = function () {
    return this.getCommandGroup().get(1);
  };

  /**
   * @private
   * @returns {module:nmodule/schedule/rc/baja/fe/TriggerTimesToAddEditor}
   */
  TriggerDayEditor.prototype.$getRangeSettingsEditor = function () {
    return this.getBuilder().getEditorFor('rangeSettings');
  };

  /**
   * @private
   * @returns {module:nmodule/webEditors/rc/wb/table/Table}
   */
  TriggerDayEditor.prototype.$getTriggerListTable = function () {
    return this.getBuilder().getEditorFor('triggerList');
  };
  return TriggerDayEditor;
});
