/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/schedule/rc/fe/WeekOfMonthScheduleEnumSetEditor
 */
define(['baja!', 'underscore', 'nmodule/schedule/rc/util/scheduleUtils', 'nmodule/schedule/rc/baja/fe/ScheduleEnumSetEditor'], function (baja, _, scheduleUtils, ScheduleEnumSetEditor) {
  'use strict';

  var toWeekTags = scheduleUtils.toWeekTags;

  /**
   * Editor for a `schedule:WeekOfMonthSchedule`.
   *
   * @class
   * @alias module:nmodule/schedule/rc/fe/WeekOfMonthScheduleEnumSetEditor
   * @extends module:nmodule/schedule/rc/baja/fe/ScheduleEnumSetEditor
   */
  var WeekOfMonthScheduleEnumSetEditor = function WeekOfMonthScheduleEnumSetEditor() {
    ScheduleEnumSetEditor.apply(this, arguments);
  };
  WeekOfMonthScheduleEnumSetEditor.prototype = Object.create(ScheduleEnumSetEditor.prototype);
  WeekOfMonthScheduleEnumSetEditor.prototype.constructor = WeekOfMonthScheduleEnumSetEditor;
  WeekOfMonthScheduleEnumSetEditor.prototype.getEnumRange = function () {
    return toWeekTags().then(function (tags) {
      return baja.EnumRange.make({
        ordinals: [-1].concat(_.range(1, tags.length)),
        tags: tags
      });
    });
  };
  return WeekOfMonthScheduleEnumSetEditor;
});
