function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Logan Byam
 */

define(['baja!', 'baja!schedule:DailySchedule,schedule:TimeSchedule,' + 'schedule:WeekSchedule,schedule:WeekdaySchedule', 'lex!baja', 'Promise', 'nmodule/schedule/rc/model/DaySchedule', 'nmodule/schedule/rc/model/ScheduleBlock', 'nmodule/schedule/rc/model/TimeOfDay', 'nmodule/schedule/rc/model/WeekSchedule', 'nmodule/schedule/rc/util/scheduleUtils', 'nmodule/webEditors/rc/fe/baja/util/facetsUtils'], function (baja, types, lexs, Promise, DaySchedule, ScheduleBlock, TimeOfDay, WeekSchedule, scheduleUtils, facetsUtils) {
  'use strict';

  var _lexs = _slicedToArray(lexs, 1),
    bajaLex = _lexs[0],
    formatSimple = facetsUtils.formatSimple,
    getWeekdayIndex = scheduleUtils.getWeekdayIndex;
  var ScheduleTranslator = function ScheduleTranslator(facets) {
    this.$facets = facets;
  };
  ScheduleTranslator.prototype.toModel = function (obj) {
    var cx = this.$facets.toObject(),
      type = obj.getType();
    if (type.is('schedule:WeeklySchedule')) {
      return weeklyScheduleToModel(cx, obj);
    } else if (type.is('schedule:DailySchedule')) {
      return dailyScheduleToModel(cx, obj);
    } else if (type.is('schedule:TimeSchedule')) {
      return timeScheduleToModel(cx, obj);
    }
  };
  ScheduleTranslator.prototype.fromModel = function (model) {
    if (model instanceof TimeOfDay) {
      return timeOfDayToBajaTime(model);
    } else if (model instanceof ScheduleBlock) {
      return scheduleBlockToTimeSchedule(model);
    } else if (model instanceof DaySchedule) {
      return dayScheduleToDailySchedule(model);
    } else if (model instanceof WeekSchedule) {
      return weekScheduleToWeekSchedule(model);
    }
  };
  ScheduleTranslator.prototype.$toTimeRangeDisplay = function (start, finish, cx) {
    //TODO: there has to be a cleaner way to do this
    return toTimeRangeDisplay(start, finish, cx);
  };
  function dailyScheduleToModel(cx, dailySchedule) {
    var timeSchedules = dailySchedule.get('day').getSlots().is('schedule:TimeSchedule').toValueArray();
    return Promise.all(timeSchedules.map(timeScheduleToModel.bind(null, cx))).then(function (blocks) {
      return new DaySchedule({
        dayOfWeek: dailySchedule.getName(),
        blocks: blocks
      });
    });
  }

  /**
   * Accessor for facets.
   * @param {baja.Facets} [facets]
   * @returns {baja.Facets}
   */
  ScheduleTranslator.prototype.facets = function (facets) {
    if (facets !== undefined) {
      this.$facets = facets;
    }
    return this.$facets;
  };
  function timeScheduleToModel(cx, timeSchedule) {
    var start = new TimeOfDay(timeSchedule.get('start')),
      finish = new TimeOfDay(timeSchedule.get('finish')),
      effectiveValue = timeSchedule.get('effectiveValue'),
      display;
    if (baja.hasType(effectiveValue, 'baja:StatusValue')) {
      if (effectiveValue.get('status') === baja.Status.nullStatus) {
        display = bajaLex.get('Status.null');
      } else {
        //TODO: finish DynamicEnum#toString and chuck facetsUtils
        display = formatSimple(effectiveValue.get('value'), cx);
      }
    }
    return Promise.all([toTimeRangeDisplay(start, finish, cx), display]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        timeRangeDisplay = _ref2[0],
        display = _ref2[1];
      return new ScheduleBlock({
        start: start,
        finish: finish,
        value: effectiveValue,
        timeRangeDisplay: timeRangeDisplay,
        valueDisplay: display
      });
    });
  }
  function weeklyScheduleToModel(cx, weeklySchedule) {
    var dailySchedules = weeklySchedule.get('schedule').get('week').getSlots().is('schedule:DailySchedule').toValueArray();
    return Promise.all(dailySchedules.map(dailyScheduleToModel.bind(null, cx))).then(function (daySchedules) {
      return new WeekSchedule({
        firstDayOfWeek: bajaLex.get('weekday.firstDayOfWeek'),
        daySchedules: daySchedules
      });
    });
  }
  function timeOfDayToBajaTime(timeOfDay) {
    return baja.Time.make(timeOfDay.getTimeOfDayMillis());
  }
  function scheduleBlockToTimeSchedule(block) {
    var value = block.getValue();
    if (!baja.hasType(value, 'baja:StatusValue')) {
      return Promise.reject(new Error('block value must be baja:StatusValue'));
    }
    var timeSchedule = baja.$('schedule:TimeSchedule', {
      start: timeOfDayToBajaTime(block.getStart()),
      finish: timeOfDayToBajaTime(block.getFinish()),
      effectiveValue: value.newCopy()
    });

    //TODO: type extension? c.f. BAbstractSchedule#setEffectiveValue
    timeSchedule.setFlags({
      slot: 'effectiveValue',
      flags: baja.Flags.OPERATOR | baja.Flags.USER_DEFINED_1
    });
    return timeSchedule;
  }
  function dayScheduleToDailySchedule(daySchedule) {
    return Promise.all(daySchedule.getBlocks().map(scheduleBlockToTimeSchedule)).then(function (timeSchedules) {
      var ds = baja.$('schedule:DailySchedule', {
          days: baja.$('schedule:WeekdaySchedule', {
            set: baja.EnumSet.make([getWeekdayIndex(daySchedule.getDayOfWeek())])
          })
        }),
        day = ds.get('day');
      timeSchedules.forEach(function (ts) {
        day.add({
          slot: 'time?',
          value: ts
        });
      });
      return ds;
    });
  }
  function weekScheduleToWeekSchedule(weekSchedule) {
    var daySchedules = weekSchedule.getDaySchedules(),
      ws = baja.$('schedule:WeekSchedule');
    return Promise.all(daySchedules.map(dayScheduleToDailySchedule)).then(function (dailySchedules) {
      dailySchedules.forEach(function (dailySchedule, i) {
        ws.set({
          slot: daySchedules[i].getDayOfWeek(),
          value: dailySchedule
        });
      });
      return ws;
    });
  }
  function toTimeRangeDisplay(start, finish, cx) {
    return Promise.all([timeOfDayToBajaTime(start).toTimeString(cx), timeOfDayToBajaTime(finish).toTimeString(cx)]).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 2),
        startString = _ref4[0],
        finishString = _ref4[1];
      return startString + ' - ' + finishString;
    });
  }
  return ScheduleTranslator;
});
