function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author Tony Richards
 */

/**
 * API Status: **Private**
 * @module nmodule/schedule/rc/fe/AbstractScheduleSelector
 */
define(['baja!', 'baja!schedule:ScheduleReference', 'lex!schedule,webEditors', 'Promise', 'underscore', 'bajaux/events', 'nmodule/schedule/rc/baja/fe/CustomScheduleEditor', 'nmodule/schedule/rc/baja/fe/DateScheduleEditor', 'nmodule/schedule/rc/baja/fe/DateRangeScheduleEditor', 'nmodule/schedule/rc/baja/fe/ReferenceScheduleOrdEditor', 'nmodule/schedule/rc/baja/fe/WeekAndDayScheduleEditor', 'nmodule/schedule/rc/fe/templates', 'nmodule/schedule/rc/util/scheduleUtils', 'nmodule/webEditors/rc/fe/fe', 'nmodule/webEditors/rc/fe/baja/BaseEditor', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor'], function (baja, types, lexs, Promise, _, events, CustomScheduleEditor, DateScheduleEditor, DateRangeScheduleEditor, ReferenceScheduleOrdEditor, WeekAndDayScheduleEditor, templates, scheduleUtils, fe, BaseEditor, OrderedMapEditor) {
  'use strict';

  var scheduleLex = lexs[0],
    webEditorsLex = lexs[1],
    MODIFY_EVENT = events.MODIFY_EVENT,
    dateToDateSchedule = scheduleUtils.dateToDateSchedule,
    lexLabel = templates.lexLabel,
    TYPE_MAP_CHOICE = 0,
    TYPE_MAP_TYPE = 1,
    TYPE_MAP_LEX = 2,
    TYPE_MAP_DEFAULT_TEXT = 3,
    TYPE_MAP_EDITOR = 4,
    TYPE_MAP_VALUE = 5,
    TYPE_MAP_FORM_FACTOR = 6,
    TYPE_MAP = [[0, 'schedule:DateSchedule', 'type.dateSchedule', 'Date', DateScheduleEditor, null, 'mini'], [1, 'schedule:DateRangeSchedule', 'type.dateRangeSchedule', 'Date Range', DateRangeScheduleEditor, null, 'mini'], [2, 'schedule:WeekAndDaySchedule', 'type.weekAndDaySchedule', 'Week And Day', WeekAndDayScheduleEditor, null, 'mini'], [3, 'schedule:CustomSchedule', 'type.customSchedule', 'Custom', CustomScheduleEditor, null, 'compact'], [4, 'baja:Ord', 'type.scheduleReference', 'Reference', ReferenceScheduleOrdEditor, null, 'mini']],
    choices = function choices(typeMap) {
      var map = new baja.OrderedMap();
      _.each(typeMap, function (arg) {
        var choice = arg[TYPE_MAP_CHOICE],
          lex = arg[TYPE_MAP_LEX],
          text = arg[TYPE_MAP_DEFAULT_TEXT];
        map.put(scheduleLex.get({
          key: lex,
          def: text
        }), choice);
      });
      return map;
    };
  var tpl = function tpl(ed) {
    return "\n      <div>\n        ".concat(lexLabel('displayName'), "\n        <span class=\"js-slot-name\"></span>\n      </div>\n      <div>\n        ").concat(lexLabel('type'), "\n        <span class=\"js-choice\"></span>\n      </div>\n      <div class=\"js-value ux-shadow-inset\"></div>");
  };

  /**
   * Abstract Schedule Selector
   *
   * Generally used as a dialog box for adding a calendar / special events schedule,
   * this Widget presents a slot name, type selector (enumeration of AbstractSchedule types)
   * and an editor for the specified type.
   *
   * No contract is required for the loaded component, and nothing is directly saved to
   * the edited component.  Instead, use {AbstractScheduleSelector#read} to retrieve the
   * resulting slot name and {AbstractSchedule} object.
   *
   * @class
   * @alias module:nmodule/schedule/rc/fe/AbstractScheduleSelector
   * @extends module:nmodule/webEditors/rc/fe/baja/BaseEditor
   * @see AbstractScheduleSelector#doRead
   *
   * @param {Object} [params]
   * @param {String} [params.defaultSlotName] Default slot name
   * @constructor
   */
  var AbstractScheduleSelector = function AbstractScheduleSelector(params) {
    var that = this;
    BaseEditor.apply(that, arguments);
    that.$slotName = baja.$('baja:String', that.properties().getValue('defaultSlotName') || 'slot');
    that.validators().add(function () {
      if (!that.value()) {
        return;
      }
      return that.$getSlotNameEditor().read().then(function (slotName) {
        if (slotName.trim() === '') {
          throw new Error(webEditorsLex.get('enterName'));
        }
        if (that.value().has(baja.SlotPath.escape(slotName))) {
          throw new Error(scheduleLex.get('composite.nameAlreadyInUse'));
        }
      });
    });
  };
  AbstractScheduleSelector.prototype = Object.create(BaseEditor.prototype);
  AbstractScheduleSelector.prototype.constructor = AbstractScheduleSelector;
  AbstractScheduleSelector.prototype.doInitialize = function (dom) {
    var that = this;
    dom.html(tpl(this));
    dom.addClass('AbstractScheduleSelector');
    dom.on(MODIFY_EVENT, '.js-choice', function () {
      var choice = that.$getChoiceEditor().getSelectedValue();
      return that.$initValueEditor(choice)["catch"](baja.error);
    });
    return Promise.all([fe.buildFor({
      value: that.$slotName,
      formFactor: 'mini',
      dom: that.$getSlotNameElement()
    }), fe.buildFor({
      dom: that.$getChoiceElement(),
      formFactor: 'mini',
      type: OrderedMapEditor,
      value: choices(that.$getTypeMap())
    })]).then(function () {
      // Select the first editor
      return that.$initValueEditor(0);
    });
  };

  /**
   * When properties includes 'includeReference', show the Calendar
   * Reference as an option to add.
   * @returns {Array}
   * @private
   */
  AbstractScheduleSelector.prototype.$getTypeMap = function () {
    if (!this.properties().getValue("includeReference")) {
      var typeMap = TYPE_MAP.slice(0, 4);
      typeMap.length = 4;
      return typeMap;
    }
    return TYPE_MAP;
  };

  /**
   * Get the slot name editor
   *
   * @private
   *
   * @returns {module:nmodule/webEditors/rc/fe/baja/StringEditor}
   */
  AbstractScheduleSelector.prototype.$getSlotNameEditor = function () {
    return this.$getSlotNameElement().data('widget');
  };

  /**
   * Get the editor for the selected choice.
   *
   * @private
   *
   * @returns {module:nmodule/webEditors/rc/fe/baja/OrderedMapEditor}
   */
  AbstractScheduleSelector.prototype.$getChoiceEditor = function () {
    return this.$getChoiceElement().data('widget');
  };

  /**
   * Get the editor for the `value` slot.
   *
   * @private
   *
   * @returns {*}
   */
  AbstractScheduleSelector.prototype.$getValueEditor = function () {
    return this.$getValueElement().data('widget');
  };

  /**
   * @private
   *
   * @returns {jQuery} element containing the `slot name` editor
   */
  AbstractScheduleSelector.prototype.$getSlotNameElement = function () {
    return this.jq().find('.js-slot-name');
  };

  /**
   * @private
   *
   * @returns {jQuery} element containing the `choice` editor
   */
  AbstractScheduleSelector.prototype.$getChoiceElement = function () {
    return this.jq().find('.js-choice');
  };

  /**
   * @private
   *
   * @returns {jQuery} element containing the `value` editor
   */
  AbstractScheduleSelector.prototype.$getValueElement = function () {
    return this.jq().find('.js-value');
  };
  AbstractScheduleSelector.prototype.$initValueEditor = function (choice) {
    var that = this,
      valueEd = that.$getValueEditor(),
      type = TYPE_MAP[choice][TYPE_MAP_TYPE],
      editorType = TYPE_MAP[choice][TYPE_MAP_EDITOR],
      value = TYPE_MAP[choice][TYPE_MAP_VALUE],
      formFactor = TYPE_MAP[choice][TYPE_MAP_FORM_FACTOR],
      getValue = baja.hasType(value, type) ? value : this.$instantiate(type);
    return Promise.all([getValue, valueEd && valueEd.destroy()]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 1),
        value = _ref2[0];
      TYPE_MAP[choice][TYPE_MAP_VALUE] = value;
      that.$getChoiceEditor().setSelectedValue(choice, true);
      return fe.buildFor({
        value: value,
        formFactor: formFactor,
        type: editorType,
        dom: that.$getValueElement(),
        properties: {
          includeWeekdays: type === 'schedule:DateSchedule',
          sourceOrd: that.properties().getValue("sourceOrd")
        }
      });
    });
  };

  /**
   * @private
   * @param {String} type
   * @returns {Promise.<baja.Component>}
   */
  AbstractScheduleSelector.prototype.$instantiate = function (type) {
    return baja.importTypes([type]).then(function () {
      switch (type) {
        case 'schedule:DateSchedule':
          return dateToDateSchedule(new Date());
        default:
          return baja.$(type);
      }
    });
  };

  /**
   * @returns {Promise} Resolves with an object with slot and value properties
   */
  AbstractScheduleSelector.prototype.doRead = function () {
    var that = this;
    return Promise.all([that.$getChoiceEditor().getSelectedValue(), that.$getSlotNameEditor().read(), that.$getValueEditor().read()]).then(function (_ref3) {
      var _ref4 = _slicedToArray(_ref3, 3),
        choice = _ref4[0],
        slotName = _ref4[1],
        value = _ref4[2];
      slotName = baja.SlotPath.escape(slotName);
      // Special handling required for ScheduleReference since
      // ReferenceScheduleOrdEditor edits an Ord rather than schedule:ScheduleReference
      if (choice === 4) {
        return {
          slot: slotName,
          value: baja.$('schedule:ScheduleReference', {
            ref: value
          })
        };
      }
      return that.$getValueEditor().save().then(function () {
        return {
          slot: slotName,
          value: TYPE_MAP[choice][TYPE_MAP_VALUE].newCopy()
        };
      });
    });
  };

  /**
   * Calls the validateRPC with the current value and throws any errors that are returned from it
   * @since Niagara 4.10u4
   * @returns {Promise}
   */
  AbstractScheduleSelector.prototype.doSave = function (results) {
    return validateRpc(results.value);
  };

  /**
   * Makes the actual call to the 'validateSchedule' in the 'schedule:ScheduleRpc` type
   * @since Niagara 4.10u4
   * @param {baja.Component} value a component that is of the type 'schedule:AbstractSchedule'
   * @returns {Promise} to be resolved with the results of the rpc call
   */
  function validateRpc(value) {
    return baja.rpc({
      typeSpec: 'schedule:ScheduleRpc',
      methodName: 'validateSchedule',
      args: [JSON.stringify(baja.bson.encodeValue(value))]
    });
  }
  AbstractScheduleSelector.prototype.doDestroy = function () {
    var valueEd = this.$getValueEditor();
    this.jq().removeClass('AbstractScheduleSelector');
    return Promise.all([valueEd && valueEd.destroy(), BaseEditor.prototype.doDestroy.apply(this, arguments)]);
  };
  return AbstractScheduleSelector;
});
