/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.config;

import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.datatypes.BBacnetArray;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOptionalBinaryLightingPv;
import javax.baja.bacnet.datatypes.BBacnetPriorityValue;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.lighting.BBacnetBinaryLightingPv;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BBacnetBinaryLightingOutput represents the BinaryLightingOutput config.
 *
 * @author Bishal Debbarma
 * @since  Niagara 4.14
 */
@NiagaraType
@NiagaraProperty(
  name = "objectId",
  type = "BBacnetObjectIdentifier",
  defaultValue = "BBacnetObjectIdentifier.make(BBacnetObjectType.BINARY_LIGHTING_OUTPUT)",
  flags = Flags.SUMMARY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER)"),
  override = true
)
@NiagaraProperty(
  name = "objectType",
  type = "BEnum",
  defaultValue = "BDynamicEnum.make(BBacnetObjectType.BINARY_LIGHTING_OUTPUT, BEnumRange.make(BBacnetObjectType.TYPE))",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED)"),
  override = true
)
@NiagaraProperty(
  name = "presentValue",
  type = "BBacnetBinaryLightingPv",
  defaultValue = "BBacnetBinaryLightingPv.DEFAULT",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.PRESENT_VALUE, ASN_ENUMERATED)")
)
@NiagaraProperty(
  name = "statusFlags",
  type = "BBacnetBitString",
  defaultValue = "BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength(\"BacnetStatusFlags\"))",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.STATUS_FLAGS, ASN_BIT_STRING, BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP)")
)
@NiagaraProperty(
  name = "outOfService",
  type = "boolean",
  defaultValue = "false",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OUT_OF_SERVICE, ASN_BOOLEAN)")
)
@NiagaraProperty(
  name = "blinkWarnEnable",
  type = "boolean",
  defaultValue = "false",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.BLINK_WARN_ENABLE, ASN_BOOLEAN)")
)
@NiagaraProperty(
  name = "egressTime",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.EGRESS_TIME, ASN_UNSIGNED)")
)
@NiagaraProperty(
  name = "egressActive",
  type = "boolean",
  defaultValue = "false",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.EGRESS_ACTIVE, ASN_BOOLEAN)")
)
@NiagaraProperty(
  name = "priorityArray",
  type = "BBacnetArray",
  defaultValue = "new BBacnetArray(BBacnetPriorityValue.TYPE, 16)",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.PRIORITY_ARRAY, ASN_BACNET_ARRAY)")
)
@NiagaraProperty(
  name = "relinquishDefault",
  type = "BBacnetBinaryLightingPv",
  defaultValue = "BBacnetBinaryLightingPv.DEFAULT",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.RELINQUISH_DEFAULT, ASN_ENUMERATED)")
)
public class BBacnetBinaryLightingOutput
  extends BBacnetObject
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.config.BBacnetBinaryLightingOutput(315829886)1.0$ @*/
/* Generated Thu Apr 13 16:50:00 IST 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  //region Property "objectId"

  /**
   * Slot for the {@code objectId} property.
   * @see #getObjectId
   * @see #setObjectId
   */
  @Generated
  public static final Property objectId = newProperty(Flags.SUMMARY, BBacnetObjectIdentifier.make(BBacnetObjectType.BINARY_LIGHTING_OUTPUT), makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER));

  //endregion Property "objectId"

  //region Property "objectType"

  /**
   * Slot for the {@code objectType} property.
   * @see #getObjectType
   * @see #setObjectType
   */
  @Generated
  public static final Property objectType = newProperty(Flags.READONLY, BDynamicEnum.make(BBacnetObjectType.BINARY_LIGHTING_OUTPUT, BEnumRange.make(BBacnetObjectType.TYPE)), makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED));

  //endregion Property "objectType"

  //region Property "presentValue"

  /**
   * Slot for the {@code presentValue} property.
   * @see #getPresentValue
   * @see #setPresentValue
   */
  @Generated
  public static final Property presentValue = newProperty(0, BBacnetBinaryLightingPv.DEFAULT, makeFacets(BBacnetPropertyIdentifier.PRESENT_VALUE, ASN_ENUMERATED));

  /**
   * Get the {@code presentValue} property.
   * @see #presentValue
   */
  @Generated
  public BBacnetBinaryLightingPv getPresentValue() { return (BBacnetBinaryLightingPv)get(presentValue); }

  /**
   * Set the {@code presentValue} property.
   * @see #presentValue
   */
  @Generated
  public void setPresentValue(BBacnetBinaryLightingPv v) { set(presentValue, v, null); }

  //endregion Property "presentValue"

  //region Property "statusFlags"

  /**
   * Slot for the {@code statusFlags} property.
   * @see #getStatusFlags
   * @see #setStatusFlags
   */
  @Generated
  public static final Property statusFlags = newProperty(Flags.READONLY, BBacnetBitString.emptyBitString(BacnetBitStringUtil.getBitStringLength("BacnetStatusFlags")), makeFacets(BBacnetPropertyIdentifier.STATUS_FLAGS, ASN_BIT_STRING, BacnetBitStringUtil.BACNET_STATUS_FLAGS_MAP));

  /**
   * Get the {@code statusFlags} property.
   * @see #statusFlags
   */
  @Generated
  public BBacnetBitString getStatusFlags() { return (BBacnetBitString)get(statusFlags); }

  /**
   * Set the {@code statusFlags} property.
   * @see #statusFlags
   */
  @Generated
  public void setStatusFlags(BBacnetBitString v) { set(statusFlags, v, null); }

  //endregion Property "statusFlags"

  //region Property "outOfService"

  /**
   * Slot for the {@code outOfService} property.
   * @see #getOutOfService
   * @see #setOutOfService
   */
  @Generated
  public static final Property outOfService = newProperty(0, false, makeFacets(BBacnetPropertyIdentifier.OUT_OF_SERVICE, ASN_BOOLEAN));

  /**
   * Get the {@code outOfService} property.
   * @see #outOfService
   */
  @Generated
  public boolean getOutOfService() { return getBoolean(outOfService); }

  /**
   * Set the {@code outOfService} property.
   * @see #outOfService
   */
  @Generated
  public void setOutOfService(boolean v) { setBoolean(outOfService, v, null); }

  //endregion Property "outOfService"

  //region Property "blinkWarnEnable"

  /**
   * Slot for the {@code blinkWarnEnable} property.
   * @see #getBlinkWarnEnable
   * @see #setBlinkWarnEnable
   */
  @Generated
  public static final Property blinkWarnEnable = newProperty(0, false, makeFacets(BBacnetPropertyIdentifier.BLINK_WARN_ENABLE, ASN_BOOLEAN));

  /**
   * Get the {@code blinkWarnEnable} property.
   * @see #blinkWarnEnable
   */
  @Generated
  public boolean getBlinkWarnEnable() { return getBoolean(blinkWarnEnable); }

  /**
   * Set the {@code blinkWarnEnable} property.
   * @see #blinkWarnEnable
   */
  @Generated
  public void setBlinkWarnEnable(boolean v) { setBoolean(blinkWarnEnable, v, null); }

  //endregion Property "blinkWarnEnable"

  //region Property "egressTime"

  /**
   * Slot for the {@code egressTime} property.
   * @see #getEgressTime
   * @see #setEgressTime
   */
  @Generated
  public static final Property egressTime = newProperty(0, BBacnetUnsigned.DEFAULT, makeFacets(BBacnetPropertyIdentifier.EGRESS_TIME, ASN_UNSIGNED));

  /**
   * Get the {@code egressTime} property.
   * @see #egressTime
   */
  @Generated
  public BBacnetUnsigned getEgressTime() { return (BBacnetUnsigned)get(egressTime); }

  /**
   * Set the {@code egressTime} property.
   * @see #egressTime
   */
  @Generated
  public void setEgressTime(BBacnetUnsigned v) { set(egressTime, v, null); }

  //endregion Property "egressTime"

  //region Property "egressActive"

  /**
   * Slot for the {@code egressActive} property.
   * @see #getEgressActive
   * @see #setEgressActive
   */
  @Generated
  public static final Property egressActive = newProperty(0, false, makeFacets(BBacnetPropertyIdentifier.EGRESS_ACTIVE, ASN_BOOLEAN));

  /**
   * Get the {@code egressActive} property.
   * @see #egressActive
   */
  @Generated
  public boolean getEgressActive() { return getBoolean(egressActive); }

  /**
   * Set the {@code egressActive} property.
   * @see #egressActive
   */
  @Generated
  public void setEgressActive(boolean v) { setBoolean(egressActive, v, null); }

  //endregion Property "egressActive"

  //region Property "priorityArray"

  /**
   * Slot for the {@code priorityArray} property.
   * @see #getPriorityArray
   * @see #setPriorityArray
   */
  @Generated
  public static final Property priorityArray = newProperty(0, new BBacnetArray(BBacnetPriorityValue.TYPE, 16), makeFacets(BBacnetPropertyIdentifier.PRIORITY_ARRAY, ASN_BACNET_ARRAY));

  /**
   * Get the {@code priorityArray} property.
   * @see #priorityArray
   */
  @Generated
  public BBacnetArray getPriorityArray() { return (BBacnetArray)get(priorityArray); }

  /**
   * Set the {@code priorityArray} property.
   * @see #priorityArray
   */
  @Generated
  public void setPriorityArray(BBacnetArray v) { set(priorityArray, v, null); }

  //endregion Property "priorityArray"

  //region Property "relinquishDefault"

  /**
   * Slot for the {@code relinquishDefault} property.
   * @see #getRelinquishDefault
   * @see #setRelinquishDefault
   */
  @Generated
  public static final Property relinquishDefault = newProperty(0, BBacnetBinaryLightingPv.DEFAULT, makeFacets(BBacnetPropertyIdentifier.RELINQUISH_DEFAULT, ASN_ENUMERATED));

  /**
   * Get the {@code relinquishDefault} property.
   * @see #relinquishDefault
   */
  @Generated
  public BBacnetBinaryLightingPv getRelinquishDefault() { return (BBacnetBinaryLightingPv)get(relinquishDefault); }

  /**
   * Set the {@code relinquishDefault} property.
   * @see #relinquishDefault
   */
  @Generated
  public void setRelinquishDefault(BBacnetBinaryLightingPv v) { set(relinquishDefault, v, null); }

  //endregion Property "relinquishDefault"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetBinaryLightingOutput.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  @Override
  public void started()
    throws Exception
  {
    super.started();

    updatePriorityArrayType(priorityArray, BBacnetOptionalBinaryLightingPv.TYPE);
  }
}
