/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.config;

import javax.baja.bacnet.datatypes.BBacnetDateTime;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BBacnetPulseConverter represents the BacnetPulseConverter config.
 *
 * @author Bishal Debbarma
 * @since  Niagara 4.14
 */
@NiagaraType
@NiagaraProperty(
  name = "objectId",
  type = "BBacnetObjectIdentifier",
  defaultValue = "BBacnetObjectIdentifier.make(BBacnetObjectType.PULSE_CONVERTER)",
  flags = Flags.SUMMARY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER)"),
  override = true
)
@NiagaraProperty(
  name = "objectType",
  type = "BEnum",
  defaultValue = "BDynamicEnum.make(BBacnetObjectType.PULSE_CONVERTER, BEnumRange.make(BBacnetObjectType.TYPE))",
  flags = Flags.READONLY,
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED)"),
  override = true
)
@NiagaraProperty(
  name = "scaleFactor",
  type = "float",
  defaultValue = "0.0f",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.SCALE_FACTOR, ASN_REAL)")
)
@NiagaraProperty(
  name = "adjustValue",
  type = "float",
  defaultValue = "0.0f",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.ADJUST_VALUE, ASN_REAL)")
)
@NiagaraProperty(
  name = "count",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.COUNT, ASN_UNSIGNED)")
)
@NiagaraProperty(
  name = "updateTime",
  type = "BBacnetDateTime",
  defaultValue = "new BBacnetDateTime()",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.UPDATE_TIME, ASN_CONSTRUCTED_DATA)")
)
@NiagaraProperty(
  name = "countChangeTime",
  type = "BBacnetDateTime",
  defaultValue = "new BBacnetDateTime()",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.UPDATE_TIME, ASN_CONSTRUCTED_DATA)")
)
@NiagaraProperty(
  name = "countBeforeChange",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT",
  facets = @Facet("makeFacets(BBacnetPropertyIdentifier.COUNT_BEFORE_CHANGE, ASN_UNSIGNED)")
)
public class BBacnetPulseConverter
  extends BBacnetAnalog
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.config.BBacnetPulseConverter(2669555847)1.0$ @*/
/* Generated Mon Feb 27 19:09:29 IST 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  //region Property "objectId"

  /**
   * Slot for the {@code objectId} property.
   * @see #getObjectId
   * @see #setObjectId
   */
  @Generated
  public static final Property objectId = newProperty(Flags.SUMMARY, BBacnetObjectIdentifier.make(BBacnetObjectType.PULSE_CONVERTER), makeFacets(BBacnetPropertyIdentifier.OBJECT_IDENTIFIER, ASN_OBJECT_IDENTIFIER));

  //endregion Property "objectId"

  //region Property "objectType"

  /**
   * Slot for the {@code objectType} property.
   * @see #getObjectType
   * @see #setObjectType
   */
  @Generated
  public static final Property objectType = newProperty(Flags.READONLY, BDynamicEnum.make(BBacnetObjectType.PULSE_CONVERTER, BEnumRange.make(BBacnetObjectType.TYPE)), makeFacets(BBacnetPropertyIdentifier.OBJECT_TYPE, ASN_ENUMERATED));

  //endregion Property "objectType"

  //region Property "scaleFactor"

  /**
   * Slot for the {@code scaleFactor} property.
   * @see #getScaleFactor
   * @see #setScaleFactor
   */
  @Generated
  public static final Property scaleFactor = newProperty(0, 0.0f, makeFacets(BBacnetPropertyIdentifier.SCALE_FACTOR, ASN_REAL));

  /**
   * Get the {@code scaleFactor} property.
   * @see #scaleFactor
   */
  @Generated
  public float getScaleFactor() { return getFloat(scaleFactor); }

  /**
   * Set the {@code scaleFactor} property.
   * @see #scaleFactor
   */
  @Generated
  public void setScaleFactor(float v) { setFloat(scaleFactor, v, null); }

  //endregion Property "scaleFactor"

  //region Property "adjustValue"

  /**
   * Slot for the {@code adjustValue} property.
   * @see #getAdjustValue
   * @see #setAdjustValue
   */
  @Generated
  public static final Property adjustValue = newProperty(0, 0.0f, makeFacets(BBacnetPropertyIdentifier.ADJUST_VALUE, ASN_REAL));

  /**
   * Get the {@code adjustValue} property.
   * @see #adjustValue
   */
  @Generated
  public float getAdjustValue() { return getFloat(adjustValue); }

  /**
   * Set the {@code adjustValue} property.
   * @see #adjustValue
   */
  @Generated
  public void setAdjustValue(float v) { setFloat(adjustValue, v, null); }

  //endregion Property "adjustValue"

  //region Property "count"

  /**
   * Slot for the {@code count} property.
   * @see #getCount
   * @see #setCount
   */
  @Generated
  public static final Property count = newProperty(0, BBacnetUnsigned.DEFAULT, makeFacets(BBacnetPropertyIdentifier.COUNT, ASN_UNSIGNED));

  /**
   * Get the {@code count} property.
   * @see #count
   */
  @Generated
  public BBacnetUnsigned getCount() { return (BBacnetUnsigned)get(count); }

  /**
   * Set the {@code count} property.
   * @see #count
   */
  @Generated
  public void setCount(BBacnetUnsigned v) { set(count, v, null); }

  //endregion Property "count"

  //region Property "updateTime"

  /**
   * Slot for the {@code updateTime} property.
   * @see #getUpdateTime
   * @see #setUpdateTime
   */
  @Generated
  public static final Property updateTime = newProperty(0, new BBacnetDateTime(), makeFacets(BBacnetPropertyIdentifier.UPDATE_TIME, ASN_CONSTRUCTED_DATA));

  /**
   * Get the {@code updateTime} property.
   * @see #updateTime
   */
  @Generated
  public BBacnetDateTime getUpdateTime() { return (BBacnetDateTime)get(updateTime); }

  /**
   * Set the {@code updateTime} property.
   * @see #updateTime
   */
  @Generated
  public void setUpdateTime(BBacnetDateTime v) { set(updateTime, v, null); }

  //endregion Property "updateTime"

  //region Property "countChangeTime"

  /**
   * Slot for the {@code countChangeTime} property.
   * @see #getCountChangeTime
   * @see #setCountChangeTime
   */
  @Generated
  public static final Property countChangeTime = newProperty(0, new BBacnetDateTime(), makeFacets(BBacnetPropertyIdentifier.UPDATE_TIME, ASN_CONSTRUCTED_DATA));

  /**
   * Get the {@code countChangeTime} property.
   * @see #countChangeTime
   */
  @Generated
  public BBacnetDateTime getCountChangeTime() { return (BBacnetDateTime)get(countChangeTime); }

  /**
   * Set the {@code countChangeTime} property.
   * @see #countChangeTime
   */
  @Generated
  public void setCountChangeTime(BBacnetDateTime v) { set(countChangeTime, v, null); }

  //endregion Property "countChangeTime"

  //region Property "countBeforeChange"

  /**
   * Slot for the {@code countBeforeChange} property.
   * @see #getCountBeforeChange
   * @see #setCountBeforeChange
   */
  @Generated
  public static final Property countBeforeChange = newProperty(0, BBacnetUnsigned.DEFAULT, makeFacets(BBacnetPropertyIdentifier.COUNT_BEFORE_CHANGE, ASN_UNSIGNED));

  /**
   * Get the {@code countBeforeChange} property.
   * @see #countBeforeChange
   */
  @Generated
  public BBacnetUnsigned getCountBeforeChange() { return (BBacnetUnsigned)get(countBeforeChange); }

  /**
   * Set the {@code countBeforeChange} property.
   * @see #countBeforeChange
   */
  @Generated
  public void setCountBeforeChange(BBacnetUnsigned v) { set(countBeforeChange, v, null); }

  //endregion Property "countBeforeChange"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetPulseConverter.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
