/*
 * Copyright 2025 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Represents the BACnetEventNotificationSubscription sequence that represents a recipient
 * destination to which event notifications are sent when events are forwarded by the Notification
 * Forwarder object.
 *
 * @author Uday Rapuru on 09-Jan-2025
 * @since Niagara 4.14U2
 * @since Niagara 4.15U1
 */
@NiagaraType
@NiagaraProperty(
  name = "recipient",
  type = "BBacnetRecipient",
  defaultValue = "new BBacnetRecipient()"
)
@NiagaraProperty(
  name = "processIdentifier",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.make(0)"
)
@NiagaraProperty(
  name = "issueConfirmedNotifications",
  type = "boolean",
  defaultValue = "false"
)
@NiagaraProperty(
  name = "timeRemaining",
  type = "BRelTime",
  defaultValue = "BRelTime.DEFAULT"
)
public final class BBacnetEventNotificationSubscription
  extends BStruct
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetEventNotificationSubscription(2402633311)1.0$ @*/
/* Generated Mon Jan 13 13:37:31 CST 2025 by Slot-o-Matic (c) Tridium, Inc. 2012-2025 */

  //region Property "recipient"

  /**
   * Slot for the {@code recipient} property.
   * @see #getRecipient
   * @see #setRecipient
   */
  @Generated
  public static final Property recipient = newProperty(0, new BBacnetRecipient(), null);

  /**
   * Get the {@code recipient} property.
   * @see #recipient
   */
  @Generated
  public BBacnetRecipient getRecipient() { return (BBacnetRecipient)get(recipient); }

  /**
   * Set the {@code recipient} property.
   * @see #recipient
   */
  @Generated
  public void setRecipient(BBacnetRecipient v) { set(recipient, v, null); }

  //endregion Property "recipient"

  //region Property "processIdentifier"

  /**
   * Slot for the {@code processIdentifier} property.
   * @see #getProcessIdentifier
   * @see #setProcessIdentifier
   */
  @Generated
  public static final Property processIdentifier = newProperty(0, BBacnetUnsigned.make(0), null);

  /**
   * Get the {@code processIdentifier} property.
   * @see #processIdentifier
   */
  @Generated
  public BBacnetUnsigned getProcessIdentifier() { return (BBacnetUnsigned)get(processIdentifier); }

  /**
   * Set the {@code processIdentifier} property.
   * @see #processIdentifier
   */
  @Generated
  public void setProcessIdentifier(BBacnetUnsigned v) { set(processIdentifier, v, null); }

  //endregion Property "processIdentifier"

  //region Property "issueConfirmedNotifications"

  /**
   * Slot for the {@code issueConfirmedNotifications} property.
   * @see #getIssueConfirmedNotifications
   * @see #setIssueConfirmedNotifications
   */
  @Generated
  public static final Property issueConfirmedNotifications = newProperty(0, false, null);

  /**
   * Get the {@code issueConfirmedNotifications} property.
   * @see #issueConfirmedNotifications
   */
  @Generated
  public boolean getIssueConfirmedNotifications() { return getBoolean(issueConfirmedNotifications); }

  /**
   * Set the {@code issueConfirmedNotifications} property.
   * @see #issueConfirmedNotifications
   */
  @Generated
  public void setIssueConfirmedNotifications(boolean v) { setBoolean(issueConfirmedNotifications, v, null); }

  //endregion Property "issueConfirmedNotifications"

  //region Property "timeRemaining"

  /**
   * Slot for the {@code timeRemaining} property.
   * @see #getTimeRemaining
   * @see #setTimeRemaining
   */
  @Generated
  public static final Property timeRemaining = newProperty(0, BRelTime.DEFAULT, null);

  /**
   * Get the {@code timeRemaining} property.
   * @see #timeRemaining
   */
  @Generated
  public BRelTime getTimeRemaining() { return (BRelTime)get(timeRemaining); }

  /**
   * Set the {@code timeRemaining} property.
   * @see #timeRemaining
   */
  @Generated
  public void setTimeRemaining(BRelTime v) { set(timeRemaining, v, null); }

  //endregion Property "timeRemaining"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetEventNotificationSubscription.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  @Override
  public void writeAsn(AsnOutput out)
  {
    out.writeOpeningTag(0);
    getRecipient().writeAsn(out);
    out.writeClosingTag(0);

    long processIdentifier = getProcessIdentifier().getLong();
    if (processIdentifier < 0 || processIdentifier > BBacnetUnsigned.MAX_UNSIGNED_VALUE)
    {
      throw new IllegalStateException("BACnetEventNotificationSubscription.processIdentifier must be between zero and max Unsigned32 (inclusive)" +
        "; actual: " + processIdentifier);
    }
    out.writeUnsignedInteger(1, processIdentifier);

    out.writeBoolean(2, getIssueConfirmedNotifications());

    int minutes = getTimeRemaining().getMinutes();
    if (minutes < 0)
    {
      throw new IllegalStateException("BACnetEventNotificationSubscription.timeRemaining must be greater than or equal to zero" +
        "; actual [minutes]: " + minutes);
    }
    out.writeUnsignedInteger(3, minutes);
  }

  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    in.skipOpeningTag(0);
    BBacnetRecipient recipient = new BBacnetRecipient();
    recipient.readAsn(in);
    in.skipClosingTag(0);
    BBacnetUnsigned processIdentifier = in.readUnsigned(1);
    if (processIdentifier.getLong() > BBacnetUnsigned.MAX_UNSIGNED_VALUE)
    {
      throw new OutOfRangeException("BACnetEventNotificationSubscription.processIdentifier must be less than or equal to max Unsigned32" +
        "; actual: " + processIdentifier.getLong());
    }

    boolean issueConfirmedNotification = in.readBoolean(2);
    int timeRemaining = in.readUnsignedInt(3);

    set(BBacnetEventNotificationSubscription.recipient, recipient, noWrite);
    set(BBacnetEventNotificationSubscription.processIdentifier, processIdentifier, noWrite);
    setBoolean(BBacnetEventNotificationSubscription.issueConfirmedNotifications, issueConfirmedNotification, noWrite);
    set(BBacnetEventNotificationSubscription.timeRemaining, BRelTime.makeMinutes(timeRemaining), noWrite);
  }

  @Override
  public String toString(Context context)
  {
    return getRecipient().toString(context) + ", processId: " + getProcessIdentifier().toString(context);
  }
}
