/*
 * Copyright 2025 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import static javax.baja.bacnet.datatypes.BBacnetExtendedParameterChoice.bitString;
import static javax.baja.bacnet.datatypes.BBacnetExtendedParameterChoice.booleanValue;
import static javax.baja.bacnet.datatypes.BBacnetExtendedParameterChoice.characterString;
import static javax.baja.bacnet.datatypes.BBacnetExtendedParameterChoice.date;
import static javax.baja.bacnet.datatypes.BBacnetExtendedParameterChoice.doubleValue;
import static javax.baja.bacnet.datatypes.BBacnetExtendedParameterChoice.enumerated;
import static javax.baja.bacnet.datatypes.BBacnetExtendedParameterChoice.integer;
import static javax.baja.bacnet.datatypes.BBacnetExtendedParameterChoice.nullValue;
import static javax.baja.bacnet.datatypes.BBacnetExtendedParameterChoice.objectIdentifier;
import static javax.baja.bacnet.datatypes.BBacnetExtendedParameterChoice.octetString;
import static javax.baja.bacnet.datatypes.BBacnetExtendedParameterChoice.real;
import static javax.baja.bacnet.datatypes.BBacnetExtendedParameterChoice.time;
import static javax.baja.bacnet.datatypes.BBacnetExtendedParameterChoice.unsigned;

import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.bacnet.asn.AsnConst;

/**
 * Represents a single parameter of the parameters field of the BACnetEventParameter extended
 * choice and the BACnetFaultParameter fault-extended choice.
 *
 * @author Uday Rapuru on 06-Jun-2025
 * @since Niagara 4.14u3
 * @since Niagara 4.15u2
 */

@NiagaraType
@NiagaraProperty(
  name = "choice",
  type = "BBacnetExtendedParameterChoice",
  defaultValue = "BBacnetExtendedParameterChoice.DEFAULT"
)
@NiagaraProperty(
  name = "value",
  type = "BValue",
  defaultValue = "BBacnetNull.DEFAULT"
)
public class BBacnetExtendedParameter
  extends BComponent
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetExtendedParameter(2063831531)1.0$ @*/
/* Generated Fri Jun 06 13:59:17 CDT 2025 by Slot-o-Matic (c) Tridium, Inc. 2012-2025 */

  //region Property "choice"

  /**
   * Slot for the {@code choice} property.
   * @see #getChoice
   * @see #setChoice
   */
  @Generated
  public static final Property choice = newProperty(0, BBacnetExtendedParameterChoice.DEFAULT, null);

  /**
   * Get the {@code choice} property.
   * @see #choice
   */
  @Generated
  public BBacnetExtendedParameterChoice getChoice() { return (BBacnetExtendedParameterChoice)get(choice); }

  /**
   * Set the {@code choice} property.
   * @see #choice
   */
  @Generated
  public void setChoice(BBacnetExtendedParameterChoice v) { set(choice, v, null); }

  //endregion Property "choice"

  //region Property "value"

  /**
   * Slot for the {@code value} property.
   * @see #getValue
   * @see #setValue
   */
  @Generated
  public static final Property value = newProperty(0, BBacnetNull.DEFAULT, null);

  /**
   * Get the {@code value} property.
   * @see #value
   */
  @Generated
  public BValue getValue() { return get(value); }

  /**
   * Set the {@code value} property.
   * @see #value
   */
  @Generated
  public void setValue(BValue v) { set(value, v, null); }

  //endregion Property "value"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetExtendedParameter.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  @Override
  public void changed(Property property, Context context)
  {
    super.changed(property, context);

    if (!isRunning())
    {
      return;
    }

    // Notify the parent of a property change so, if the parent is the property of a remote object,
    // the change will be written.
    BComplex parent = getParent();
    Property propertyInParent = getPropertyInParent();
    if (parent instanceof BComponent && propertyInParent != null)
    {
      ((BComponent) parent).changed(propertyInParent, context);
    }
  }

  /**
   * Write the value to the Asn output stream.
   */
  @Override
  public void writeAsn(AsnOutput out)
  {
    switch (getChoice().getOrdinal())
    {
      case BBacnetExtendedParameterChoice.NULL_VALUE:
        out.writeNull();
        break;
      case BBacnetExtendedParameterChoice.REAL:
        out.writeReal((BFloat)getValue());
        break;
      case BBacnetExtendedParameterChoice.UNSIGNED:
        out.writeUnsigned((BBacnetUnsigned)getValue());
        break;
      case BBacnetExtendedParameterChoice.BOOLEAN_VALUE:
        out.writeBoolean((BBoolean)getValue());
        break;
      case BBacnetExtendedParameterChoice.INTEGER:
        out.writeSignedInteger((BInteger)getValue());
        break;
      case BBacnetExtendedParameterChoice.DOUBLE_VALUE:
        out.writeDouble((BDouble)getValue());
        break;
      case BBacnetExtendedParameterChoice.OCTET_STRING:
        out.writeOctetString((BBacnetOctetString)getValue());
        break;
      case BBacnetExtendedParameterChoice.CHARACTER_STRING:
        out.writeCharacterString((BString)getValue());
        break;
      case BBacnetExtendedParameterChoice.BIT_STRING:
        out.writeBitString((BBacnetBitString)getValue());
        break;
      case BBacnetExtendedParameterChoice.ENUMERATED:
        out.writeEnumerated((BEnum)getValue());
        break;
      case BBacnetExtendedParameterChoice.DATE:
        out.writeDate((BBacnetDate)getValue());
        break;
      case BBacnetExtendedParameterChoice.TIME:
        out.writeTime((BBacnetTime)getValue());
        break;
      case BBacnetExtendedParameterChoice.OBJECT_IDENTIFIER:
        out.writeObjectIdentifier((BBacnetObjectIdentifier)getValue());
        break;
      case BBacnetExtendedParameterChoice.REFERENCE:
        out.writeOpeningTag(0);
        ((BBacnetDeviceObjectPropertyReference)getValue()).writeAsn(out);
        out.writeClosingTag(0);
        break;
    }
  }

  /**
   * Read the value from the Asn input stream.
   */
  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    int choiceValue = in.peekTag();
    if (in.isApplicationTag(choiceValue))
    {
      switch (choiceValue)
      {
        case ASN_NULL:
          setChoiceAndValue(nullValue, in.readNull());
          break;
        case ASN_BOOLEAN:
          setChoiceAndValue(booleanValue, BBoolean.make(in.readBoolean()));
          break;
        case ASN_UNSIGNED:
          setChoiceAndValue(unsigned, in.readUnsigned());
          break;
        case ASN_INTEGER:
          setChoiceAndValue(integer, in.readSigned());
          break;
        case ASN_REAL:
          setChoiceAndValue(real, in.readFloat());
          break;
        case ASN_DOUBLE:
          setChoiceAndValue(doubleValue, BDouble.make(in.readDouble()));
          break;
        case ASN_OCTET_STRING:
          setChoiceAndValue(octetString, in.readBacnetOctetString());
          break;
        case ASN_CHARACTER_STRING:
          setChoiceAndValue(characterString, BString.make(in.readCharacterString()));
          break;
        case ASN_BIT_STRING:
          setChoiceAndValue(bitString, in.readBitString());
          break;
        case ASN_ENUMERATED:
          setChoiceAndValue(enumerated, BDynamicEnum.make(in.readEnumerated()));
          break;
        case ASN_DATE:
          setChoiceAndValue(date, in.readDate());
          break;
        case ASN_TIME:
          setChoiceAndValue(time, in.readTime());
          break;
        case ASN_OBJECT_IDENTIFIER:
          setChoiceAndValue(objectIdentifier, in.readObjectIdentifier());
          break;
        default:
          throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + choiceValue);
      }
    }
    else if (in.isOpeningTag(0))
    {
      in.skipTag();
      BBacnetDeviceObjectPropertyReference reference = new BBacnetDeviceObjectPropertyReference();
      reference.readAsn(in);
      in.skipClosingTag(0);

      setChoiceAndValue(BBacnetExtendedParameterChoice.reference, reference);
    }
    else
    {
      throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + choiceValue);
    }
  }

  private void setChoiceAndValue(BBacnetExtendedParameterChoice choice, BValue value)
  {
    set(BBacnetExtendedParameter.choice, choice, noWrite);
    set(BBacnetExtendedParameter.value, value, noWrite);
  }

  public String toString(Context context)
  {
    BBacnetExtendedParameterChoice choice = getChoice();
    return choice.equals(nullValue) ? "null" : choice + " " + getValue().toString(context);
  }
}
