/*
 * Copyright 2010 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BTrendFlags;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.status.BStatus;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BNumber;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

import com.tridium.bacnet.asn.AsnConst;
import com.tridium.bacnet.asn.NErrorType;
import com.tridium.bacnet.datatypes.BTrendEvent;
import com.tridium.bacnet.history.BBacnetBitStringTrendRecord;
import com.tridium.bacnet.history.BBacnetBooleanTrendRecord;
import com.tridium.bacnet.history.BBacnetEnumTrendRecord;
import com.tridium.bacnet.history.BBacnetNumericTrendRecord;
import com.tridium.bacnet.history.BBacnetStringTrendRecord;
import com.tridium.bacnet.history.BBacnetTrendRecord;

/**
 * BBacnetLogRecord represents the BacnetLogRecord sequence.
 *
 * @author Robert Adams
 * @version $Revision$ $Date$
 * @creation 22 Mar 2010
 * @since Niagara 3 Bacnet 1.0
 */
@NiagaraType
@NiagaraProperty(
  name = "timestamp",
  type = "BBacnetDateTime",
  defaultValue = "new BBacnetDateTime()"
)
@NiagaraProperty(
  name = "statusFlags",
  type = "BSimple",
  defaultValue = "BBacnetNull.DEFAULT"
)
@NiagaraProperty(
  name = "timeChange",
  type = "BSimple",
  defaultValue = "BBacnetNull.DEFAULT"
)
public class BBacnetLogMultipleRecord
  extends BComponent
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetLogMultipleRecord(786413094)1.0$ @*/
/* Generated Thu Jun 02 14:30:03 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Property "timestamp"

  /**
   * Slot for the {@code timestamp} property.
   * @see #getTimestamp
   * @see #setTimestamp
   */
  @Generated
  public static final Property timestamp = newProperty(0, new BBacnetDateTime(), null);

  /**
   * Get the {@code timestamp} property.
   * @see #timestamp
   */
  @Generated
  public BBacnetDateTime getTimestamp() { return (BBacnetDateTime)get(timestamp); }

  /**
   * Set the {@code timestamp} property.
   * @see #timestamp
   */
  @Generated
  public void setTimestamp(BBacnetDateTime v) { set(timestamp, v, null); }

  //endregion Property "timestamp"

  //region Property "statusFlags"

  /**
   * Slot for the {@code statusFlags} property.
   * @see #getStatusFlags
   * @see #setStatusFlags
   */
  @Generated
  public static final Property statusFlags = newProperty(0, BBacnetNull.DEFAULT, null);

  /**
   * Get the {@code statusFlags} property.
   * @see #statusFlags
   */
  @Generated
  public BSimple getStatusFlags() { return (BSimple)get(statusFlags); }

  /**
   * Set the {@code statusFlags} property.
   * @see #statusFlags
   */
  @Generated
  public void setStatusFlags(BSimple v) { set(statusFlags, v, null); }

  //endregion Property "statusFlags"

  //region Property "timeChange"

  /**
   * Slot for the {@code timeChange} property.
   * @see #getTimeChange
   * @see #setTimeChange
   */
  @Generated
  public static final Property timeChange = newProperty(0, BBacnetNull.DEFAULT, null);

  /**
   * Get the {@code timeChange} property.
   * @see #timeChange
   */
  @Generated
  public BSimple getTimeChange() { return (BSimple)get(timeChange); }

  /**
   * Set the {@code timeChange} property.
   * @see #timeChange
   */
  @Generated
  public void setTimeChange(BSimple v) { set(timeChange, v, null); }

  //endregion Property "timeChange"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetLogMultipleRecord.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
//BIBacnetDataType
////////////////////////////////////////////////////////////////

  public BBacnetLogMultipleRecord()
  {
  }

  public BBacnetLogMultipleRecord(AsnInput in)
    throws AsnException
  {
    readAsn(in);
  }

  /**
   * Write the value to the Asn output stream.
   *
   * @param out the AsnOutput stream.
   */
  public void writeAsn(AsnOutput out)
  {
    //  out.writeOpeningTag(TIMESTAMP_TAG);
    //  getTimestamp().writeAsn(out);
    //  out.writeClosingTag(TIMESTAMP_TAG);
    //  out.writeOpeningTag(LOG_DATUM_TAG);
    //  writeLogDatum(out,
    //                getLogDatum(),
    //                getLogDatumType(),
    //                getLogDatumEvent().getLong(),
    //                BacnetBitStringUtil.getBStatus(getStatusFlags()));
    //  out.writeClosingTag(LOG_DATUM_TAG);
    //  out.writeBitString(STATUS_FLAGS_TAG, getStatusFlags());
  }

  /**
   * Read the value from the Asn input stream.
   *
   * @param in the AsnInput stream.
   */
  public void readAsn(AsnInput in)
    throws AsnException
  {
    recType = null;
    in.skipOpeningTag(TIMESTAMP_TAG);
    BBacnetDateTime timestamp = new BBacnetDateTime();
    timestamp.readAsn(in);
    in.skipClosingTag(TIMESTAMP_TAG);

    in.skipOpeningTag(LOG_DATA_TAG);
    logDataChoice = in.peekTag();
    switch (logDataChoice)
    {
      case LOG_STATUS_TAG:
        BTrendEvent logStatus = BTrendEvent.makeLogStatus(in.readBitString(LOG_STATUS_TAG));
        in.skipClosingTag(LOG_DATA_TAG);
        set(statusFlags, logStatus, noWrite);
        break;
      case LOG_DATA_SEQ_TAG:
        in.skipOpeningTag(LOG_DATA_SEQ_TAG);
        List<BSimple> logData = processDataSeq(in);
        in.skipClosingTag(LOG_DATA_SEQ_TAG);
        in.skipClosingTag(LOG_DATA_TAG);

        removeAll(noWrite);
        int length = logData.size();
        for (int i = 0; i < length; i++)
        {
          addData(logData.get(i), i);
        }
        break;
      case TIME_CHANGE_TAG:
        BTrendEvent timeChange = BTrendEvent.makeTimeChange((long)in.readReal(TIME_CHANGE_TAG));
        in.skipClosingTag(LOG_DATA_TAG);
        set(BBacnetLogMultipleRecord.timeChange, timeChange, noWrite);
        break;
      default:
        throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + logDataChoice);
    }
    set(BBacnetLogMultipleRecord.timestamp, timestamp, noWrite);
  }

  private List<BSimple> processDataSeq(AsnInput in)
    throws AsnException
  {
    List<BSimple> logData = new ArrayList<>();
    Array<BTypeSpec> typeSpecs = new Array<>(BTypeSpec.class);
    // process until end of sequence
    int choice = in.peekTag();
    while (!in.isClosingTag(LOG_DATA_SEQ_TAG))
    {
      BSimple logDatum;
      BTypeSpec typeSpec;
      switch (choice)
      {
        case BOOLEAN_VALUE_TAG:
          logDatum = BBoolean.make(in.readBoolean(BOOLEAN_VALUE_TAG));
          typeSpec = BBacnetBooleanTrendRecord.TYPE.getTypeSpec();
          break;
        case REAL_VALUE_TAG:
          logDatum = in.readFloat(REAL_VALUE_TAG);
          typeSpec = BBacnetNumericTrendRecord.TYPE.getTypeSpec();
          break;
        case ENUM_VALUE_TAG:
          logDatum = BDynamicEnum.make(in.readEnumerated(ENUM_VALUE_TAG));
          typeSpec = BBacnetEnumTrendRecord.TYPE.getTypeSpec();
          break;
        case UNSIGNED_VALUE_TAG:
          logDatum = in.readUnsigned(UNSIGNED_VALUE_TAG);
          typeSpec = BBacnetNumericTrendRecord.TYPE.getTypeSpec();
          break;
        case SIGNED_VALUE_TAG:
          logDatum = in.readSigned(SIGNED_VALUE_TAG);
          typeSpec = BBacnetNumericTrendRecord.TYPE.getTypeSpec();
          break;
        case BITSTRING_VALUE_TAG:
          logDatum = in.readBitString(BITSTRING_VALUE_TAG);
          typeSpec = BBacnetStringTrendRecord.TYPE.getTypeSpec();
          break;
        case NULL_VALUE_TAG:
          logDatum = in.readNull(NULL_VALUE_TAG);
          typeSpec = BBacnetNull.TYPE.getTypeSpec();
          break;
        case FAILURE_TAG:
          // Create a new NErrorType, and then cast to a string using encodeToString.
          in.skipOpeningTag(FAILURE_TAG);
          NErrorType failure = new NErrorType();
          failure.readEncoded(in);
          in.skipClosingTag(FAILURE_TAG);
          logDatum = BTrendEvent.makeFailure(failure);
          typeSpec = null;
          break;
        case ANY_VALUE_TAG:
          in.skipOpeningTag(ANY_VALUE_TAG);
          switch (in.peekApplicationTag())
          {
            case ASN_CHARACTER_STRING:
              logDatum = BString.make(in.readCharacterString());
              in.skipClosingTag(ANY_VALUE_TAG);
              typeSpec = BBacnetStringTrendRecord.TYPE.getTypeSpec();
              break;

            case ASN_DOUBLE:
              logDatum = BDouble.make(in.readDouble());
              in.skipClosingTag(ANY_VALUE_TAG);
              typeSpec = BBacnetNumericTrendRecord.TYPE.getTypeSpec();
              break;

            default:
              while (in.available() > 0 && !in.isClosingTag(ANY_VALUE_TAG))
                in.skipTag();

              loggerBacnetDebug.info(this + ".readAsn:logDatumChoice " + choice + " not yet supported");
              logDatum = BBacnetNull.DEFAULT;
              typeSpec = BBacnetStringTrendRecord.TYPE.getTypeSpec();
          }
          break;
        default:
          throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + choice);
      }
      logData.add(logDatum);
      typeSpecs.add(typeSpec);
      choice = in.peekTag();
    }
    recType = typeSpecs.trim();
    return logData;
  }

  private void addData(BSimple d, int n)
  {
    add(getSeqName(n), d, noWrite);
  }

  private String getSeqName(int n)
  {
    return "data" + n;
  }

  public BTypeSpec getNiagaraRecordType(int n)
  {
    return recType[n];
  }

  ////////////////////////////////////////////////////////////////
//Attributes
////////////////////////////////////////////////////////////////
  public BHistoryRecord initializeNiagaraRecord(BHistoryRecord record, long seqNum, int ndx)
  {
    BBacnetTrendRecord rec = (BBacnetTrendRecord)record;
    rec.setTimestamp(getTimestamp().toBAbsTime());
// TODO    rec.setStatus(BacnetBitStringUtil.getBStatus(getStatusFlags()));
    rec.setSequenceNumber(seqNum);

    if (!isLogData())
    {
      if (isLogStatus())
      {
        rec.setLogEvent((BTrendEvent)getStatusFlags());
      }
      else
      {
        rec.setLogEvent((BTrendEvent)getTimeChange());
      }
      rec.setTrendFlags(rec.getTrendFlags().set(BTrendFlags.HIDDEN, true)); // Always set the hidden flag for events!
      return rec;
    }

    BSimple o = (BSimple)get(getSeqName(ndx));

    // Write the log record types to the console to satisfy BTL testing requirements.
    if (recordLogger.isLoggable(Level.FINEST))
    {
      recordLogger.finest(
        (historyImport != null ? historyImport.getSlotPath().toString() : ' ') +
          ": Trend Log Multiple import;" +
          " for multiple logged records index " + ndx +
          "; log data: " + o +
          "; log type: " + o.getType());
    }

    rec.setLogEvent(BTrendEvent.DEFAULT);
    Type t = rec.getType();
    if (t == BBacnetBooleanTrendRecord.TYPE)
    {
      if (o instanceof BBacnetNull)
      {
        ((BBacnetBooleanTrendRecord)rec).setValue(false);
        setStatusNull(rec);
      }
      else if (o instanceof BTrendEvent)
      {
        setFailureEvent(rec, (BTrendEvent) o);
      }
      else
      {
        ((BBacnetBooleanTrendRecord)rec).setValue(((BBoolean)o).getBoolean());
      }
    }
    else if (t == BBacnetNumericTrendRecord.TYPE)
    {
      if (o instanceof BBacnetNull)
      {
        ((BBacnetNumericTrendRecord)rec).setValue(0);
        setStatusNull(rec);
      }
      else if (o instanceof BTrendEvent)
      {
        setFailureEvent(rec, (BTrendEvent) o);
      }
      else
      {
        BSimple ld = o;
        if (ld.getType().is(BBacnetUnsigned.TYPE))
        {
          ((BBacnetNumericTrendRecord)rec).setValue(((BBacnetUnsigned)o).getLong());
        }
        else
        {
          ((BBacnetNumericTrendRecord)rec).setValue(((BNumber)o).getDouble());
        }
      }
    }
    else if (t == BBacnetEnumTrendRecord.TYPE)
    {
      if (o instanceof BBacnetNull)
      {
        ((BBacnetEnumTrendRecord)rec).setValue(BDynamicEnum.make(0));
        setStatusNull(rec);
      }
      else if (o instanceof BTrendEvent)
      {
        setFailureEvent(rec, (BTrendEvent) o);
      }
      else
      {
        ((BBacnetEnumTrendRecord)rec).setValue((BDynamicEnum)o);
      }
    }
    else if (t == BBacnetStringTrendRecord.TYPE)
    {
      try
      {
        if (o instanceof BBacnetNull)
        {
          ((BBacnetStringTrendRecord)rec).setValue("NULL");
          setStatusNull(rec);
        }
        else if (o instanceof BTrendEvent)
        {
          setFailureEvent(rec, (BTrendEvent) o);
        }
        else
        {
          ((BBacnetStringTrendRecord)rec).setValue(o.encodeToString());
        }
      }
      catch (Exception e)
      {
        loggerBacnet.log(Level.INFO, "Error, could not encode logDatum to a string (" + o.toString() + ")", e);
        ((BBacnetStringTrendRecord)rec).setValue("Error, could not encode " + o.toString());
      }
    }
    else if (t == BBacnetBitStringTrendRecord.TYPE)
    {
      if (o instanceof BBacnetNull)
      {
        ((BBacnetBitStringTrendRecord)rec).setValue(BBacnetBitString.DEFAULT);
        setStatusNull(rec);
      }
      else if (o instanceof BTrendEvent)
      {
        setFailureEvent(rec, (BTrendEvent) o);
      }
      else
      {
        ((BBacnetBitStringTrendRecord)rec).setValue((BBacnetBitString) o);
      }
    }

    return rec;
  }

  private void setStatusNull(BBacnetTrendRecord rec)
  {
    rec.setStatus(BStatus.makeNull(rec.getStatus(), true));
  }

  private void setFailureEvent(BBacnetTrendRecord rec, BTrendEvent trendEvent)
  {
    rec.getTrendFlags().set(BTrendFlags.HIDDEN, true);
    rec.setLogEvent(trendEvent);
  }

  public boolean isLogStatus()
  {
    return logDataChoice == LOG_STATUS_TAG;
  }

  public boolean isLogData()
  {
    return logDataChoice == LOG_DATA_SEQ_TAG;
  }

  public int getLogDataChoice()
  {
    return logDataChoice;
  }

  public BTypeSpec[] getTypeSpecs()
  {
    return recType;
  }

  public void setHistoryImport(BHistoryImport historyImport)
  {
    this.historyImport = historyImport;
  }

////////////////////////////////////////////////////////////////
//Attributes
////////////////////////////////////////////////////////////////

  private BTypeSpec[] recType = null;
  private int logDataChoice;

  private static final Logger loggerBacnetDebug = Logger.getLogger("bacnet.debug");
  private static final Logger loggerBacnet = Logger.getLogger("bacnet");
  public static final Logger recordLogger = Logger.getLogger("bacnet.history.logRecord");

////////////////////////////////////////////////////////////////
//Constants
////////////////////////////////////////////////////////////////

  // BACnetLogMultipleRecord tags
  public static final int TIMESTAMP_TAG = 0;
  public static final int LOG_DATA_TAG = 1;

  // BACnetLogData choice tags
  public static final int LOG_STATUS_TAG = 0;
  public static final int LOG_DATA_SEQ_TAG = 1;
  public static final int TIME_CHANGE_TAG = 2;

  // BACnetLogData.log-data sequence of choice tags
  public static final int BOOLEAN_VALUE_TAG = 0;
  public static final int REAL_VALUE_TAG = 1;
  public static final int ENUM_VALUE_TAG = 2;
  public static final int UNSIGNED_VALUE_TAG = 3;
  public static final int SIGNED_VALUE_TAG = 4;
  public static final int BITSTRING_VALUE_TAG = 5;
  public static final int NULL_VALUE_TAG = 6;
  public static final int FAILURE_TAG = 7;
  public static final int ANY_VALUE_TAG = 8;

  private BHistoryImport historyImport;
}
