/*
 * Copyright 2022 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.enums.BBacnetBinaryPv;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.bacnet.asn.AsnConst;

/**
 * Represents the BACnetOptionalBinaryPv choice, which may be null or contain a BACnetBinaryPV value.
 *
 * @author Uday Rapuru on 16-Nov-2022
 * @since Niagara 4.14
 */
@NiagaraType
@NiagaraProperty(
  name = "isNull",
  type = "boolean",
  defaultValue = "true"
)
@NiagaraProperty(
  name = "value",
  type = "BBacnetBinaryPv",
  defaultValue = "BBacnetBinaryPv.DEFAULT"
)
public final class BBacnetOptionalBinaryPv
  extends BStruct
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetOptionalBinaryPv(4111677446)1.0$ @*/
/* Generated Wed Nov 16 11:03:33 IST 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Property "isNull"

  /**
   * Slot for the {@code isNull} property.
   * @see #getIsNull
   * @see #setIsNull
   */
  @Generated
  public static final Property isNull = newProperty(0, true, null);

  /**
   * Get the {@code isNull} property.
   * @see #isNull
   */
  @Generated
  public boolean getIsNull() { return getBoolean(isNull); }

  /**
   * Set the {@code isNull} property.
   * @see #isNull
   */
  @Generated
  public void setIsNull(boolean v) { setBoolean(isNull, v, null); }

  //endregion Property "isNull"

  //region Property "value"

  /**
   * Slot for the {@code value} property.
   * @see #getValue
   * @see #setValue
   */
  @Generated
  public static final Property value = newProperty(0, BBacnetBinaryPv.DEFAULT, null);

  /**
   * Get the {@code value} property.
   * @see #value
   */
  @Generated
  public BBacnetBinaryPv getValue() { return (BBacnetBinaryPv)get(value); }

  /**
   * Set the {@code value} property.
   * @see #value
   */
  @Generated
  public void setValue(BBacnetBinaryPv v) { set(value, v, null); }

  //endregion Property "value"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetOptionalBinaryPv.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Default (NULL) constructor
   */
  public BBacnetOptionalBinaryPv()
  {
  }

  /**
   * Real constructor.
   */
  public BBacnetOptionalBinaryPv(BBacnetBinaryPv value)
  {
    setIsNull(false);
    setValue(value);
  }

  /**
   * @return true if choice is null
   */
  @Override
  public boolean isNull()
  {
    return getIsNull();
  }

  /**
   * Write the value to the Asn output stream.
   *
   * @param out the AsnOutput stream.
   */
  @Override
  public void writeAsn(AsnOutput out)
  {
    if (getIsNull())
    {
      out.writeNull();
    }
    else
    {
      out.writeEnumerated(getValue());
    }
  }

  /**
   * Read the value from the Asn input stream.
   *
   * @param in the AsnInput stream.
   */
  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    int tag = in.peekTag();
    switch (tag)
    {
      case BacnetConst.ASN_NULL:
        in.readNull();
        setBoolean(isNull, true, noWrite);
        break;
      case BacnetConst.ASN_ENUMERATED:
        int ordinal = in.readEnumerated();
        BBacnetBinaryPv binaryPv;
        try
        {
          binaryPv = BBacnetBinaryPv.make(ordinal);
        }
        catch (InvalidEnumException e)
        {
          throw new OutOfRangeException("BACnetOptionalBinaryPv decoded enumerated value not valid: " + ordinal);
        }
        setBoolean(isNull, false, noWrite);
        set(value, binaryPv, noWrite);
        break;
      default:
        throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + tag);
    }
  }

  /**
   * To String.
   */
  @Override
  public String toString(Context context)
  {
    return getIsNull() ? "null" : getValue().toString(context);
  }
}
