/*
 * Copyright 2025 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.BacnetConst;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.bacnet.asn.AsnConst;

/**
 * Represents the BBacnetOptionalTimePattern choice, which may be null or contain a
 * BACnet time pattern value.
 *
 * @author Uday Rapuru on 05-Apr-2025
 * @since Niagara 4.14u2
 * @since Niagara 4.15u1
 */
@NiagaraType
@NiagaraProperty(
  name = "isNull",
  type = "boolean",
  defaultValue = "true"
)
@NiagaraProperty(
  name = "value",
  type = "BBacnetTime",
  defaultValue = "BBacnetTime.DEFAULT"
)
public class BBacnetOptionalTimePattern
  extends BStruct
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetOptionalTimePattern(3718539991)1.0$ @*/
/* Generated Sat Apr 05 13:34:11 IST 2025 by Slot-o-Matic (c) Tridium, Inc. 2012-2025 */

  //region Property "isNull"

  /**
   * Slot for the {@code isNull} property.
   * @see #getIsNull
   * @see #setIsNull
   */
  @Generated
  public static final Property isNull = newProperty(0, true, null);

  /**
   * Get the {@code isNull} property.
   * @see #isNull
   */
  @Generated
  public boolean getIsNull() { return getBoolean(isNull); }

  /**
   * Set the {@code isNull} property.
   * @see #isNull
   */
  @Generated
  public void setIsNull(boolean v) { setBoolean(isNull, v, null); }

  //endregion Property "isNull"

  //region Property "value"

  /**
   * Slot for the {@code value} property.
   * @see #getValue
   * @see #setValue
   */
  @Generated
  public static final Property value = newProperty(0, BBacnetTime.DEFAULT, null);

  /**
   * Get the {@code value} property.
   * @see #value
   */
  @Generated
  public BBacnetTime getValue() { return (BBacnetTime)get(value); }

  /**
   * Set the {@code value} property.
   * @see #value
   */
  @Generated
  public void setValue(BBacnetTime v) { set(value, v, null); }

  //endregion Property "value"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetOptionalTimePattern.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BBacnetOptionalTimePattern()
  {
  }

  public BBacnetOptionalTimePattern(BBacnetTime value)
  {
    setIsNull(false);
    setValue(value);
  }

  @Override
  public boolean isNull()
  {
    return getIsNull();
  }

  @Override
  public void writeAsn(AsnOutput out)
  {
    if (getIsNull())
    {
      out.writeNull();
    }
    else
    {
      out.writeTime(getValue());
    }
  }

  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    int tag = in.peekTag();
    switch (tag)
    {
      case BacnetConst.ASN_NULL:
        in.readNull();
        setBoolean(isNull, true, noWrite);
        break;
      case BacnetConst.ASN_TIME:
        BBacnetTime timePattern = in.readTime();
        setBoolean(isNull, false, noWrite);
        set(value, timePattern, noWrite);
        break;
      default:
        throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + tag);
    }
  }

  @Override
  public String toString(Context context)
  {
    return getIsNull() ? "null" : getValue().toString(context);
  }
}
