/*
 * Copyright 2025 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * Represents the BACnetPortPermission sequence that specifies whether event notifications received
 * on a particular network port will be forwarded by the Notification Forwarder object.
 *
 * @author Uday Rapuru on 09-Jan-2025
 * @since Niagara 4.14U2
 * @since Niagara 4.15U1
 */
@NiagaraType
@NiagaraProperty(
  name = "portId",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT"
)
@NiagaraProperty(
  name = "enabled",
  type = "boolean",
  defaultValue = "false"
)
public final class BBacnetPortPermission
  extends BStruct
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetPortPermission(2915874126)1.0$ @*/
/* Generated Mon Jan 13 14:01:27 CST 2025 by Slot-o-Matic (c) Tridium, Inc. 2012-2025 */

  //region Property "portId"

  /**
   * Slot for the {@code portId} property.
   * @see #getPortId
   * @see #setPortId
   */
  @Generated
  public static final Property portId = newProperty(0, BBacnetUnsigned.DEFAULT, null);

  /**
   * Get the {@code portId} property.
   * @see #portId
   */
  @Generated
  public BBacnetUnsigned getPortId() { return (BBacnetUnsigned)get(portId); }

  /**
   * Set the {@code portId} property.
   * @see #portId
   */
  @Generated
  public void setPortId(BBacnetUnsigned v) { set(portId, v, null); }

  //endregion Property "portId"

  //region Property "enabled"

  /**
   * Slot for the {@code enabled} property.
   * @see #getEnabled
   * @see #setEnabled
   */
  @Generated
  public static final Property enabled = newProperty(0, false, null);

  /**
   * Get the {@code enabled} property.
   * @see #enabled
   */
  @Generated
  public boolean getEnabled() { return getBoolean(enabled); }

  /**
   * Set the {@code enabled} property.
   * @see #enabled
   */
  @Generated
  public void setEnabled(boolean v) { setBoolean(enabled, v, null); }

  //endregion Property "enabled"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetPortPermission.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  @Override
  public void writeAsn(AsnOutput out)
  {
    long portId = getPortId().getLong();
    if (portId < 0 || portId > BBacnetUnsigned.MAX_UNSIGNED8_VALUE)
    {
      throw new IllegalStateException("BACnetPortPermission.portId must be between zero and max Unsigned8 (inclusive)" +
        "; actual: " + portId);
    }
    out.writeUnsignedInteger(0, portId);

    out.writeBoolean(1, getEnabled());
  }

  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    BBacnetUnsigned portId = in.readUnsigned(0);
    if (portId.getLong() > BBacnetUnsigned.MAX_UNSIGNED8_VALUE)
    {
      throw new OutOfRangeException("BACnetPortPermission.portId must be less than or equal to max Unsigned8" +
        "; actual: " + portId.getLong());
    }

    boolean enabled = in.readBoolean(1);

    set(BBacnetPortPermission.portId, portId, noWrite);
    setBoolean(BBacnetPortPermission.enabled, enabled, noWrite);
  }

  @Override
  public String toString(Context context)
  {
    return "port: " + getPortId() + ", enabled? " + getEnabled();
  }
}
