/*
 * Copyright 2004 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.baja.bacnet.enums.BBacnetAction;
import javax.baja.bacnet.enums.BBacnetBackupState;
import javax.baja.bacnet.enums.BBacnetBinaryPv;
import javax.baja.bacnet.enums.BBacnetDeviceStatus;
import javax.baja.bacnet.enums.BBacnetEngineeringUnits;
import javax.baja.bacnet.enums.BBacnetEventState;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetFileAccessMethod;
import javax.baja.bacnet.enums.BBacnetLifeSafetyMode;
import javax.baja.bacnet.enums.BBacnetLifeSafetyOperation;
import javax.baja.bacnet.enums.BBacnetLifeSafetyState;
import javax.baja.bacnet.enums.BBacnetMaintenance;
import javax.baja.bacnet.enums.BBacnetNodeType;
import javax.baja.bacnet.enums.BBacnetNotifyType;
import javax.baja.bacnet.enums.BBacnetPolarity;
import javax.baja.bacnet.enums.BBacnetProgramError;
import javax.baja.bacnet.enums.BBacnetProgramRequest;
import javax.baja.bacnet.enums.BBacnetProgramState;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.enums.BBacnetRestartReason;
import javax.baja.bacnet.enums.BBacnetShedState;
import javax.baja.bacnet.enums.BBacnetSilencedState;
import javax.baja.bacnet.enums.BBacnetWriteStatus;
import javax.baja.bacnet.enums.access.BBacnetAccessCredentialDisable;
import javax.baja.bacnet.enums.access.BBacnetAccessCredentialDisableReason;
import javax.baja.bacnet.enums.access.BBacnetAccessEvent;
import javax.baja.bacnet.enums.access.BBacnetAccessZoneOccupancyState;
import javax.baja.bacnet.enums.access.BBacnetAuthenticationStatus;
import javax.baja.bacnet.enums.access.BBacnetDoorAlarmState;
import javax.baja.bacnet.enums.access.BBacnetDoorSecuredStatus;
import javax.baja.bacnet.enums.access.BBacnetDoorStatus;
import javax.baja.bacnet.enums.access.BBacnetDoorValue;
import javax.baja.bacnet.enums.access.BBacnetLockStatus;
import javax.baja.bacnet.enums.lighting.BBacnetBinaryLightingPv;
import javax.baja.bacnet.enums.lighting.BBacnetLightingInProgress;
import javax.baja.bacnet.enums.lighting.BBacnetLightingOperation;
import javax.baja.bacnet.enums.lighting.BBacnetLightingTransition;
import javax.baja.bacnet.enums.security.BBacnetSecurityLevel;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.bacnet.io.OutOfRangeException;
import javax.baja.bacnet.virtual.BBacnetVirtualProperty;
import javax.baja.bacnet.virtual.BacnetVirtualUtil;
import javax.baja.category.BCategoryMask;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

import com.tridium.bacnet.asn.AsnConst;

/**
 * BBacnetPropertyStates represents the BACnetPropertyStates
 * choice.
 *
 * @author Craig Gemmill
 * @version $Revision$ $Date$
 * @creation 23 Apr 04
 * @since Niagara 3 Bacnet 1.0
 */

@NiagaraType
@NiagaraProperty(
  name = "choice",
  type = "int",
  defaultValue = "0",
  flags = Flags.HIDDEN
)
public final class BBacnetPropertyStates
  extends BComponent
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetPropertyStates(246626917)1.0$ @*/
/* Generated Thu Jun 02 14:30:03 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Property "choice"

  /**
   * Slot for the {@code choice} property.
   * @see #getChoice
   * @see #setChoice
   */
  @Generated
  public static final Property choice = newProperty(Flags.HIDDEN, 0, null);

  /**
   * Get the {@code choice} property.
   * @see #choice
   */
  @Generated
  public int getChoice() { return getInt(choice); }

  /**
   * Set the {@code choice} property.
   * @see #choice
   */
  @Generated
  public void setChoice(int v) { setInt(choice, v, null); }

  //endregion Property "choice"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetPropertyStates.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Create a BOOLEAN type BACnetPropertyStates instance
   *
   * @since Niagara 4.14
   */
  public static BBacnetPropertyStates makeBoolean(boolean value)
  {
    BBacnetPropertyStates propertyStates = new BBacnetPropertyStates();
    propertyStates.setChoice(BOOLEAN_VALUE_TAG);
    propertyStates.add(BOOLEAN_VALUE_SLOT_NAME, BBoolean.make(value));
    return propertyStates;
  }

  /**
   * Create a BacnetBinaryPV type BACnetPropertyStates instance
   *
   * @since Niagara 4.10u3
   * @since Niagara 4.12
   */
  public static BBacnetPropertyStates makeBinaryPv(boolean value)
  {
    BBacnetPropertyStates propertyStates = new BBacnetPropertyStates();
    propertyStates.setChoice(BINARY_VALUE_TAG);
    propertyStates.add(BINARY_VALUE_SLOT_NAME, BBacnetBinaryPv.make(value));
    return propertyStates;
  }

  /**
   * Create an Unsigned type BACnetPropertyStates instance
   *
   * @since Niagara 4.10u3
   * @since Niagara 4.12
   */
  public static BBacnetPropertyStates makeUnsigned(long value)
  {
    BBacnetPropertyStates propertyStates = new BBacnetPropertyStates();
    propertyStates.setChoice(UNSIGNED_VALUE_TAG);
    propertyStates.add(UNSIGNED_VALUE_SLOT_NAME, BBacnetUnsigned.make(value));
    return propertyStates;
  }

  /**
   * Create a Signed type BACnetPropertyStates instance
   *
   * @since Niagara 4.14
   */
  public static BBacnetPropertyStates makeInteger(int value)
  {
    BBacnetPropertyStates propertyStates = new BBacnetPropertyStates();
    propertyStates.setChoice(INTEGER_VALUE_TAG);
    propertyStates.add(INTEGER_VALUE_SLOT_NAME, BInteger.make(value));
    return propertyStates;
  }

  /**
   * Create an enum type BACnetPropertyStates instance. The choice is based on the typeSpec, the
   * corresponding enum value is retrieved based on the ordinal, and that value is added with the
   * appropriate slot name.
   *
   * @since Niagara 4.14
   */
  public static BBacnetPropertyStates makeEnum(BTypeSpec typeSpec, int ordinal)
  {
    Integer choice = typeToChoiceMap.get(typeSpec);
    if (choice == null)
    {
      throw new IllegalStateException("BACnetPropertyStates enum type is not supported: " + typeSpec);
    }

    BValue value;
    try
    {
      value = makeEnumValue(choice, ordinal);
    }
    catch (OutOfRangeException e)
    {
      throw new IllegalStateException("BACnetPropertyStates enum type is not supported: " + typeSpec, e);
    }

    BBacnetPropertyStates propertyStates = new BBacnetPropertyStates();
    propertyStates.setChoice(choice);
    propertyStates.add(getSlotName(choice), value);
    return propertyStates;
  }

  /**
   * Create an enum type BACnetPropertyStates instance.
   *
   * @since Niagara 4.14u2
   */
  public static BBacnetPropertyStates makeEnum(BEnum enumValue)
  {
    return makeEnum(enumValue.getType().getTypeSpec(), enumValue.getOrdinal());
  }

////////////////////////////////////////////////////////////////
//  BComponent
////////////////////////////////////////////////////////////////

  @Override
  public void started()
    throws Exception
  {
    super.started();

    // Make sure the value slot is present. The default choice is "boolean" but the corresponding
    // "booleanValue" slot is not included in the default instance. Trying to add it in the default
    // constructor led to bog decoding issues. The field editors handle adding the value slot when
    // the choice is changed.
    int choice = getChoice();
    String valueSlotName = getSlotName(choice);
    if (valueSlotName != null && get(valueSlotName) == null)
    {
      add(valueSlotName, getDefaultValue(choice));
    }
  }

  public void changed(Property p, Context cx)
  {
    if (!isRunning()) return;
    BComplex parent = getParent();
    if (parent != null)
      parent.asComponent().changed(getPropertyInParent(), cx);
    // vfixx: throw changed w/ GCC context?
  }

  /**
   * Callback when the component enters the subscribed state.
   */
  public void subscribed()
  {
    BBacnetVirtualProperty vp = BacnetVirtualUtil.getVirtualProperty(this);
    if (vp != null) vp.childSubscribed(this);
  }

  /**
   * Callback when the component leaves the subscribed state.
   */
  public void unsubscribed()
  {
    BBacnetVirtualProperty vp = BacnetVirtualUtil.getVirtualProperty(this);
    if (vp != null) vp.childUnsubscribed(this);
  }

  /**
   * Override to route to the virtual parent when we are in a virtual space.
   */
  public BCategoryMask getAppliedCategoryMask()
  {
    if (BacnetVirtualUtil.isVirtual(this))
      return getParent().asComponent().getAppliedCategoryMask();
    return super.getAppliedCategoryMask();
  }

  /**
   * Override to route to the virtual parent when we are in a virtual space.
   */
  public BCategoryMask getCategoryMask()
  {
    if (BacnetVirtualUtil.isVirtual(this)) return getParent().asComponent().getCategoryMask();
    return super.getCategoryMask();
  }

  /**
   * Override to route to the virtual parent when we are in a virtual space.
   */
  public BPermissions getPermissions(Context cx)
  {
    if (BacnetVirtualUtil.isVirtual(this)) return getParent().asComponent().getPermissions(cx);
    return super.getPermissions(cx);
  }

  public String toString(Context cx)
  {
    String slotName = getSlotName(getChoice());
    return slotName != null ?
      lex.getText("BacnetPropertyStates." + slotName) + ':' + get(slotName) :
      lex.getText("BacnetPropertyStates.invalid");
  }

////////////////////////////////////////////////////////////////
//  BIBacnetDataType
////////////////////////////////////////////////////////////////

  /**
   * Write the value to the Asn output stream.
   * Since protocol revision 16, choice values greater than 254 are multiplied by 100,000 and added
   * to the enum value; the result is encoded using context tag 63.
   *
   * @param out the AsnOutput stream.
   */
  public void writeAsn(AsnOutput out)
  {
    int choice = getChoice();
    if (choice < 0)
    {
      throw new IllegalStateException("Invalid BACnetPropertyStates choice: " + choice);
    }
    if (choice == MAX_ASHRAE_CHOICE)
    {
      throw new IllegalStateException("Choice value 63 reserved to extend support for tag number greater than 254");
    }
    if (choice > MAX_CHOICE)
    {
      throw new IllegalStateException("BACnetPropertyStates choice " + choice + " is too large to be encoded by ASN; choice should be less than " + MAX_CHOICE);
    }

    if (choice <= MAX_DEFINED_CHOICE)
    {
      switch (choice)
      {
        case BOOLEAN_VALUE_TAG:
          out.writeBoolean(BOOLEAN_VALUE_TAG, (BBoolean) get(BOOLEAN_VALUE_SLOT_NAME));
          break;
        case UNSIGNED_VALUE_TAG:
          out.writeUnsigned(UNSIGNED_VALUE_TAG, (BBacnetUnsigned) get(UNSIGNED_VALUE_SLOT_NAME));
          break;
        case INTEGER_VALUE_TAG:
          out.writeSignedInteger(INTEGER_VALUE_TAG, (BInteger) get(INTEGER_VALUE_SLOT_NAME));
          break;
        case RESERVED29_TAG: // Reserved for future addenda
        case 35: // ???
          out.writeEnumerated(choice, ((BBacnetUnsigned) get(ASHRAE_SLOT_NAME)).getInt());
          break;
        default:
          String slotName = getSlotName(choice);
          BValue value = slotName != null ? get(slotName) : null;
          if (value != null)
          {
            out.writeEnumerated(choice, (BEnum) value);
          }
          else
          {
            throw new IllegalStateException("Invalid enum value for the BACnetPropertyStates choice " + choice);
          }
          break;
      }
    }
    else if (choice < MAX_ASHRAE_CHOICE)
    {
      out.writeEnumerated(choice, ((BBacnetUnsigned) get(ASHRAE_SLOT_NAME)).getInt());
    }
    else if (choice <= MAX_TAG)
    {
      out.writeEnumerated(choice, ((BBacnetUnsigned) get(PROPRIETARY_SLOT_NAME)).getInt());
    }
    else
    {
      // choice > MAX_TAG
      long value = ((BBacnetUnsigned) get(ASHRAE_SLOT_NAME)).getLong();
      long extendedValue = choice * 100_000L + value;
      out.writeUnsignedInteger(MAX_ASHRAE_CHOICE, extendedValue);
    }
  }

  /**
   * Read the value from the Asn input stream.
   * Since protocol revision 16, provides support for decoding encoded choice values greater than
   * 254.
   *
   * @param in the AsnInput stream.
   */
  public void readAsn(AsnInput in)
    throws AsnException
  {
    int tag = in.peekTag();
    if (tag < 0 || tag > MAX_TAG)
    {
      throw new AsnException(AsnConst.E_BACNET_ASN_INVALID_TAG + tag);
    }

    int choice = tag;
    String slotName;
    BValue value;
    if (tag <= MAX_DEFINED_CHOICE)
    {
      slotName = getSlotName(tag);
      switch (tag)
      {
        case BOOLEAN_VALUE_TAG:
          value = BBoolean.make(in.readBoolean(BOOLEAN_VALUE_TAG));
          break;
        case UNSIGNED_VALUE_TAG:
          value = in.readUnsigned(UNSIGNED_VALUE_TAG);
          break;
        case INTEGER_VALUE_TAG:
          value = in.readSigned(INTEGER_VALUE_TAG);
          break;
        case RESERVED29_TAG: // Reserved for future addenda
        case 35: // ???
          value = BBacnetUnsigned.make(in.readEnumerated(tag));
          break;
        default:
          value = makeEnumValue(tag, in.readEnumerated(tag));
          break;
      }
    }
    else if (tag < MAX_ASHRAE_CHOICE)
    {
      slotName = ASHRAE_SLOT_NAME;
      value = BBacnetUnsigned.make(in.readEnumerated(tag));
    }
    else if (tag == MAX_ASHRAE_CHOICE)
    {
      long extendedValue = in.readUnsignedInteger(MAX_ASHRAE_CHOICE);
      if (extendedValue < 25_500_000L)
      {
        throw new OutOfRangeException("Extended choice values must be at least 255; value: " + extendedValue);
      }

      long extendedChoice = extendedValue / 100_000L;
      if (extendedChoice > MAX_CHOICE)
      {
        throw new OutOfRangeException("Extended choice value greater than 42949 are not supported: " + extendedChoice);
      }

      choice = (int)extendedChoice;
      slotName = ASHRAE_SLOT_NAME;
      value = BBacnetUnsigned.make(extendedValue - extendedChoice * 100_000L);
    }
    else
    {
      slotName = PROPRIETARY_SLOT_NAME;
      value = BBacnetUnsigned.make(in.readEnumerated(tag));
    }

    removeAll(noWrite);
    setInt(BBacnetPropertyStates.choice, choice, noWrite);
    add(slotName, value, noWrite);
  }

  /**
   * Return either the BFrozenEnum instance that corresponds to the ordinal or a BDynamicEnum if
   * the enum is extensible.
   */
  private static BValue makeEnumValue(int tag, int ordinal)
    throws OutOfRangeException
  {
    switch (tag)
    {
      case BINARY_VALUE_TAG:
        return BBacnetBinaryPv.make(ordinal);
      case EVENT_TYPE_TAG:
        return makeDynamicEnum(ordinal, BBacnetEventType.DEFAULT);
      case POLARITY_TAG:
        return BBacnetPolarity.make(ordinal);
      case PROGRAM_CHANGE_TAG:
        return BBacnetProgramRequest.make(ordinal);
      case PROGRAM_STATE_TAG:
        return BBacnetProgramState.make(ordinal);
      case REASON_FOR_HALT_TAG:
        return makeDynamicEnum(ordinal, BBacnetProgramError.DEFAULT);
      case RELIABILITY_TAG:
        return makeDynamicEnum(ordinal, BBacnetReliability.DEFAULT);
      case STATE_TAG:
        return makeDynamicEnum(ordinal, BBacnetEventState.DEFAULT);
      case SYSTEM_STATUS_TAG:
        return makeDynamicEnum(ordinal, BBacnetDeviceStatus.DEFAULT);
      case UNITS_TAG:
        return makeDynamicEnum(ordinal, BBacnetEngineeringUnits.DEFAULT);
      case LIFE_SAFETY_MODE_TAG:
        return makeDynamicEnum(ordinal, BBacnetLifeSafetyMode.DEFAULT);
      case LIFE_SAFETY_STATE_TAG:
        return makeDynamicEnum(ordinal, BBacnetLifeSafetyState.DEFAULT);
      case RESTART_REASON_TAG:
        return makeDynamicEnum(ordinal, BBacnetRestartReason.DEFAULT);
      case DOOR_ALARM_TAG:
        return makeDynamicEnum(ordinal, BBacnetDoorAlarmState.DEFAULT);
      case ACTION_TAG:
        return BBacnetAction.make(ordinal);
      case DOOR_SECURED_STATUS_TAG:
        return BBacnetDoorSecuredStatus.make(ordinal);
      case DOOR_STATUS_TAG:
        return makeDynamicEnum(ordinal, BBacnetDoorStatus.DEFAULT);
      case DOOR_VALUE_TAG:
        return BBacnetDoorValue.make(ordinal);
      case FILE_ACCESS_METHOD_TAG:
        return BBacnetFileAccessMethod.make(ordinal);
      case LOCK_STATUS_TAG:
        return BBacnetLockStatus.make(ordinal);
      case LIFE_SAFETY_OPERATION_TAG:
        return makeDynamicEnum(ordinal, BBacnetLifeSafetyOperation.DEFAULT);
      case MAINTENANCE_TAG:
        return makeDynamicEnum(ordinal, BBacnetMaintenance.DEFAULT);
      case NODE_TYPE_TAG:
        return BBacnetNodeType.make(ordinal);
      case NOTIFY_TYPE_TAG:
        return BBacnetNotifyType.make(ordinal);
      case SECURITY_LEVEL_TAG: // (26) Removed
        return makeDynamicEnum(ordinal, BBacnetSecurityLevel.DEFAULT);
      case SHED_STATE_TAG:
        return BBacnetShedState.make(ordinal);
      case SILENCED_STATE_TAG:
        return makeDynamicEnum(ordinal, BBacnetSilencedState.DEFAULT);
      // (29) Reserved
      case ACCESS_EVENT_TAG:
        return makeDynamicEnum(ordinal, BBacnetAccessEvent.DEFAULT);
      case ZONE_OCCUPANCY_TAG:
        return makeDynamicEnum(ordinal, BBacnetAccessZoneOccupancyState.DEFAULT);
      case ACCESS_CREDENTIAL_DISABLE_REASON_TAG:
        return makeDynamicEnum(ordinal, BBacnetAccessCredentialDisableReason.DEFAULT);
      case ACCESS_CREDENTIAL_DISABLE_TAG:
        return makeDynamicEnum(ordinal, BBacnetAccessCredentialDisable.DEFAULT);
      case AUTHENTICATION_STATUS_TAG:
        return BBacnetAuthenticationStatus.make(ordinal);
      // (35)
      case BACKUP_STATE_TAG:
        return BBacnetBackupState.make(ordinal);
      case WRITE_STATUS_TAG:
        return BBacnetWriteStatus.make(ordinal);
      case LIGHTING_IN_PROGRESS_TAG:
        return BBacnetLightingInProgress.make(ordinal);
      case LIGHTING_OPERATION_TAG:
        return makeDynamicEnum(ordinal, BBacnetLightingOperation.DEFAULT);
      case LIGHTING_TRANSITION_TAG:
        return makeDynamicEnum(ordinal, BBacnetLightingTransition.DEFAULT);
      case BINARY_LIGHTING_VALUE:
        return makeDynamicEnum(ordinal, BBacnetBinaryLightingPv.DEFAULT);
      default:
        throw new OutOfRangeException("Enum choice value not supported: " + tag);
    }
  }

  private static BDynamicEnum makeDynamicEnum(int ordinal, BFrozenEnum enumDefault)
  {
    return BDynamicEnum.make(ordinal, enumDefault.getRange());
  }

////////////////////////////////////////////////////////////////
// Spy
////////////////////////////////////////////////////////////////

  public void spy(SpyWriter out) throws Exception
  {
    super.spy(out);
    out.startProps();
    out.trTitle("BacnetPropertyStates", 2);
    out.prop("virtual", BacnetVirtualUtil.isVirtual(this));
    out.endProps();
  }

/////////////////////////////////////////////////////////////////
//  Constants
/////////////////////////////////////////////////////////////////

  private static final int MAX_TAG = 254;

  public static final int BOOLEAN_VALUE_TAG = 0;
  public static final int BINARY_VALUE_TAG = 1;
  public static final int EVENT_TYPE_TAG = 2;
  public static final int POLARITY_TAG = 3;
  public static final int PROGRAM_CHANGE_TAG = 4;
  public static final int PROGRAM_STATE_TAG = 5;
  public static final int REASON_FOR_HALT_TAG = 6;
  public static final int RELIABILITY_TAG = 7;
  public static final int STATE_TAG = 8;
  public static final int SYSTEM_STATUS_TAG = 9;
  public static final int UNITS_TAG = 10;
  public static final int UNSIGNED_VALUE_TAG = 11;
  public static final int LIFE_SAFETY_MODE_TAG = 12;
  public static final int LIFE_SAFETY_STATE_TAG = 13;
  public static final int RESTART_REASON_TAG = 14;
  public static final int DOOR_ALARM_TAG = 15;
  public static final int ACTION_TAG = 16;
  public static final int DOOR_SECURED_STATUS_TAG = 17;
  public static final int DOOR_STATUS_TAG = 18;
  public static final int DOOR_VALUE_TAG = 19;
  public static final int FILE_ACCESS_METHOD_TAG = 20;
  public static final int LOCK_STATUS_TAG = 21;
  public static final int LIFE_SAFETY_OPERATION_TAG = 22;
  public static final int MAINTENANCE_TAG = 23;
  public static final int NODE_TYPE_TAG = 24;
  public static final int NOTIFY_TYPE_TAG = 25;
  public static final int SECURITY_LEVEL_TAG = 26;
  public static final int SHED_STATE_TAG = 27;
  public static final int SILENCED_STATE_TAG = 28;
  public static final int RESERVED29_TAG = 29;
  public static final int ACCESS_EVENT_TAG = 30;
  public static final int ZONE_OCCUPANCY_TAG = 31;
  public static final int ACCESS_CREDENTIAL_DISABLE_REASON_TAG = 32;
  public static final int ACCESS_CREDENTIAL_DISABLE_TAG = 33;
  public static final int AUTHENTICATION_STATUS_TAG = 34;

  // from Addendum 135-2008n, for Backup & Restore
  public static final int BACKUP_STATE_TAG = 36;
  public static final int WRITE_STATUS_TAG = 37;
  public static final int LIGHTING_IN_PROGRESS_TAG = 38;
  public static final int LIGHTING_OPERATION_TAG = 39;
  public static final int LIGHTING_TRANSITION_TAG = 40;

  // from Addendum 135-2012aw, Extend the CHANGE-OF-STATE Event Algorithm for All Discrete Types
  public static final int INTEGER_VALUE_TAG = 41;

  // From Addendum 135-2012az, Add Binary Lighting Output Object Type
  public static final int BINARY_LIGHTING_VALUE = 42;

  private static final int MAX_DEFINED_CHOICE = BINARY_LIGHTING_VALUE;

  public static final String BOOLEAN_VALUE_SLOT_NAME = "booleanValue";
  public static final String BINARY_VALUE_SLOT_NAME = "binaryValue";
  public static final String UNSIGNED_VALUE_SLOT_NAME = "unsignedValue";
  public static final String INTEGER_VALUE_SLOT_NAME = "integerValue";

  private static final String ASHRAE_SLOT_NAME = "ashrae";
  private static final String PROPRIETARY_SLOT_NAME = "proprietary";

  private static final int MAX_ASHRAE_CHOICE = 63;

  // For choices greater than 42,949, too big for AsnConversion.
  private static final int MAX_CHOICE = 42_949;

  private static final Lexicon lex = Lexicon.make("bacnet");

  /**
   * Return the value of this object based on the choice value. Returns null if the choice is not
   * defined.
   *
   * @since Niagara 4.10u5
   * @since Niagara 4.12u2
   * @since Niagara 4.13
   */
  public BValue getValue()
  {
    String slotName = getSlotName(getChoice());
    return slotName != null ? get(slotName) : null;
  }

  /**
   * Map of choice to choice info.
   */
  private static final Map<Integer, ChoiceInfo> choiceToInfoMap = makeChoiceInfoMap();

  private static Map<Integer, ChoiceInfo> makeChoiceInfoMap()
  {
    Map<Integer, ChoiceInfo> map = new LinkedHashMap<>();
    // choice, slotName, defaultValue
    putChoiceInfo(map, BOOLEAN_VALUE_TAG, BOOLEAN_VALUE_SLOT_NAME, BBoolean.DEFAULT);
    putChoiceInfo(map, BINARY_VALUE_TAG, BINARY_VALUE_SLOT_NAME, BBacnetBinaryPv.DEFAULT);
    putChoiceInfo(map, EVENT_TYPE_TAG, "eventType", BDynamicEnum.make(BBacnetEventType.DEFAULT));
    putChoiceInfo(map, POLARITY_TAG, "polarity", BBacnetPolarity.DEFAULT);
    putChoiceInfo(map, PROGRAM_CHANGE_TAG, "programChange", BBacnetProgramRequest.DEFAULT);
    putChoiceInfo(map, PROGRAM_STATE_TAG, "programState", BBacnetProgramState.DEFAULT);
    putChoiceInfo(map, REASON_FOR_HALT_TAG, "reasonForHalt", BDynamicEnum.make(BBacnetProgramError.DEFAULT));
    putChoiceInfo(map, RELIABILITY_TAG, "reliability", BDynamicEnum.make(BBacnetReliability.DEFAULT));
    putChoiceInfo(map, STATE_TAG, "state", BDynamicEnum.make(BBacnetEventState.DEFAULT));
    putChoiceInfo(map, SYSTEM_STATUS_TAG, "systemStatus", BDynamicEnum.make(BBacnetDeviceStatus.DEFAULT));
    putChoiceInfo(map, UNITS_TAG, "units", BDynamicEnum.make(BBacnetEngineeringUnits.DEFAULT));
    putChoiceInfo(map, UNSIGNED_VALUE_TAG, UNSIGNED_VALUE_SLOT_NAME, BBacnetUnsigned.DEFAULT);
    putChoiceInfo(map, LIFE_SAFETY_MODE_TAG, "lifeSafetyMode", BDynamicEnum.make(BBacnetLifeSafetyMode.DEFAULT));
    putChoiceInfo(map, LIFE_SAFETY_STATE_TAG, "lifeSafetyState", BDynamicEnum.make(BBacnetLifeSafetyState.DEFAULT));
    putChoiceInfo(map, RESTART_REASON_TAG, "restartReason", BDynamicEnum.make(BBacnetRestartReason.DEFAULT));
    putChoiceInfo(map, DOOR_ALARM_TAG, "doorAlarmState", BDynamicEnum.make(BBacnetDoorAlarmState.DEFAULT));
    putChoiceInfo(map, ACTION_TAG, "action", BBacnetAction.DEFAULT);
    putChoiceInfo(map, DOOR_SECURED_STATUS_TAG, "doorSecuredStatus", BBacnetDoorSecuredStatus.DEFAULT);
    putChoiceInfo(map, DOOR_STATUS_TAG, "doorStatus", BDynamicEnum.make(BBacnetDoorStatus.DEFAULT));
    putChoiceInfo(map, DOOR_VALUE_TAG, "doorValue", BBacnetDoorValue.DEFAULT);
    putChoiceInfo(map, FILE_ACCESS_METHOD_TAG, "fileAccessMethod", BBacnetFileAccessMethod.DEFAULT);
    putChoiceInfo(map, LOCK_STATUS_TAG, "lockStatus", BBacnetLockStatus.DEFAULT);
    putChoiceInfo(map, LIFE_SAFETY_OPERATION_TAG, "lifeSafetyOperation", BDynamicEnum.make(BBacnetLifeSafetyOperation.DEFAULT));
    putChoiceInfo(map, MAINTENANCE_TAG, "maintenance", BDynamicEnum.make(BBacnetMaintenance.DEFAULT));
    putChoiceInfo(map, NODE_TYPE_TAG, "nodeType", BBacnetNodeType.DEFAULT);
    putChoiceInfo(map, NOTIFY_TYPE_TAG, "notifyType", BBacnetNotifyType.DEFAULT);
    putChoiceInfo(map, SECURITY_LEVEL_TAG, "securityLevel", BDynamicEnum.make(BBacnetSecurityLevel.DEFAULT));
    putChoiceInfo(map, SHED_STATE_TAG, "shedState", BBacnetShedState.DEFAULT);
    putChoiceInfo(map, SILENCED_STATE_TAG, "silencedState", BDynamicEnum.make(BBacnetSilencedState.DEFAULT));
    // 29: reserved for future addenda
    putChoiceInfo(map, ACCESS_EVENT_TAG, "accessEvent", BDynamicEnum.make(BBacnetAccessEvent.DEFAULT));
    putChoiceInfo(map, ZONE_OCCUPANCY_TAG, "zoneOccupancyState", BDynamicEnum.make(BBacnetAccessZoneOccupancyState.DEFAULT));
    putChoiceInfo(map, ACCESS_CREDENTIAL_DISABLE_REASON_TAG, "accessCredentialDisableReason", BDynamicEnum.make(BBacnetAccessCredentialDisableReason.DEFAULT));
    putChoiceInfo(map, ACCESS_CREDENTIAL_DISABLE_TAG, "accessCredentialDisable", BDynamicEnum.make(BBacnetAccessCredentialDisable.DEFAULT));
    putChoiceInfo(map, AUTHENTICATION_STATUS_TAG, "authenticationStatus", BBacnetAuthenticationStatus.DEFAULT);
    // 35
    putChoiceInfo(map, BACKUP_STATE_TAG, "backupState", BBacnetBackupState.DEFAULT);
    putChoiceInfo(map, WRITE_STATUS_TAG, "writeStatus", BBacnetWriteStatus.DEFAULT);
    putChoiceInfo(map, LIGHTING_IN_PROGRESS_TAG, "lightingInProgress", BBacnetLightingInProgress.DEFAULT);
    putChoiceInfo(map, LIGHTING_OPERATION_TAG, "lightingOperation", BDynamicEnum.make(BBacnetLightingOperation.DEFAULT));
    putChoiceInfo(map, LIGHTING_TRANSITION_TAG, "lightingTransition", BDynamicEnum.make(BBacnetLightingTransition.DEFAULT));
    putChoiceInfo(map, INTEGER_VALUE_TAG, INTEGER_VALUE_SLOT_NAME, BInteger.DEFAULT);
    putChoiceInfo(map, BINARY_LIGHTING_VALUE, "binaryLightingValue", BDynamicEnum.make(BBacnetBinaryLightingPv.DEFAULT));
    return map;
  }

  private static void putChoiceInfo(Map<Integer, ChoiceInfo> map, int choice, String slotName, BValue defaultValue)
  {
    map.put(choice, new ChoiceInfo(slotName, defaultValue));
  }

  private static final Map<BTypeSpec, Integer> typeToChoiceMap = makeTypeToChoiceMap();

  private static Map<BTypeSpec, Integer> makeTypeToChoiceMap()
  {
    Map<BTypeSpec, Integer> map = new HashMap<>();
    for (Map.Entry<Integer, ChoiceInfo> entry : choiceToInfoMap.entrySet())
    {
      BValue defaultValue = entry.getValue().defaultValue;
      if (defaultValue instanceof BDynamicEnum)
      {
        Type frozenType = ((BDynamicEnum) defaultValue).getRange().getFrozenType();
        map.put(frozenType.getTypeSpec(), entry.getKey());
      }
      else
      {
        map.put(defaultValue.getType().getTypeSpec(), entry.getKey());
      }
    }
    return map;
  }

  private static final BEnumRange choiceRange = makeChoiceRange();

  private static BEnumRange makeChoiceRange()
  {
    List<Map.Entry<Integer, ChoiceInfo>> entries = new ArrayList<>(choiceToInfoMap.entrySet());
    int size = entries.size();
    int[] ordinals = new int[size];
    String[] tags = new String[size];
    for (int i = 0; i < size; i++)
    {
      Map.Entry<Integer, ChoiceInfo> entry = entries.get(i);
      ordinals[i] = entry.getKey();
      tags[i] = SlotPath.escape("BacnetPropertyStates." + entry.getValue().slotName);
    }
    BFacets options = BFacets.make("lexicon", "bacnet");
    return BEnumRange.make(null, ordinals, tags, size, options);
  }

  /**
   * Return the possible choices.
   * @since Niagara 4.14u3
   * @since Niagara 4.15u2
   */
  public static BEnumRange getChoiceRange()
  {
    return choiceRange;
  }

  /**
   * Return the slot name based on the choice.
   * @since Niagara 4.14u3
   * @since Niagara 4.15u2
   */
  public static String getSlotName(int choice)
  {
    if (choice < 0 || choice == MAX_ASHRAE_CHOICE || choice > MAX_CHOICE)
    {
      return null;
    }
    else if (choice == RESERVED29_TAG || // Reserved for future addenda
             choice == 35) // ???
    {
      return ASHRAE_SLOT_NAME;
    }
    else if (choice <= MAX_DEFINED_CHOICE)
    {
      ChoiceInfo choiceInfo = choiceToInfoMap.get(choice);
      return choiceInfo != null ? choiceInfo.slotName : null;
    }
    else if (choice < MAX_ASHRAE_CHOICE || choice > MAX_TAG)
    {
      return ASHRAE_SLOT_NAME;
    }
    else
    {
      return PROPRIETARY_SLOT_NAME;
    }
  }

  /**
   * Return a default value based on the choice.
   * @since Niagara 4.14u3
   * @since Niagara 4.15u2
   */
  public static BValue getDefaultValue(int choice)
  {
    if (choice < 0 || choice == MAX_ASHRAE_CHOICE || choice > MAX_CHOICE)
    {
      return null;
    }
    else if (choice == RESERVED29_TAG || // Reserved for future addenda
             choice == 35) // ???
    {
      // Undefined but reserved are BacnetUnsigned
      return BBacnetUnsigned.DEFAULT;
    }
    else if (choice <= MAX_DEFINED_CHOICE)
    {
      ChoiceInfo choiceInfo = choiceToInfoMap.get(choice);
      return choiceInfo != null ? choiceInfo.defaultValue : null;
    }
    else
    {
      // Undefined but reserved and proprietary choices are both BacnetUnsigned
      return BBacnetUnsigned.DEFAULT;
    }
  }

  private static class ChoiceInfo
  {
    public final String slotName;
    public final BValue defaultValue;

    public ChoiceInfo(String slotName, BValue defaultValue)
    {
      this.slotName = slotName;
      this.defaultValue = defaultValue;
    }
  }
}
