/*
 * Copyright 2022 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.datatypes;

import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.AsnInput;
import javax.baja.bacnet.io.AsnOutput;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BBacnetVtSession represents the BACnetVtSession data type.
 *
 * @author Bishal Debbarma
 * @since  Niagara 4.14
 */
@NiagaraType
@NiagaraProperty(
  name = "localVtSessionId",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT",
  facets = @Facet("BFacets.makeInt(0, 255)")
)
@NiagaraProperty(
  name = "remoteVtSessionId",
  type = "BBacnetUnsigned",
  defaultValue = "BBacnetUnsigned.DEFAULT",
  facets = @Facet("BFacets.makeInt(0, 255)")
)
@NiagaraProperty(
  name = "remoteVtAddress",
  type = "BBacnetAddress",
  defaultValue = "BBacnetAddress.DEFAULT"
)
public final class BBacnetVtSession
  extends BStruct
  implements BIBacnetDataType
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.datatypes.BBacnetVtSession(2212739441)1.0$ @*/
/* Generated Fri Feb 10 13:52:45 CST 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  //region Property "localVtSessionId"

  /**
   * Slot for the {@code localVtSessionId} property.
   * @see #getLocalVtSessionId
   * @see #setLocalVtSessionId
   */
  @Generated
  public static final Property localVtSessionId = newProperty(0, BBacnetUnsigned.DEFAULT, BFacets.makeInt(0, 255));

  /**
   * Get the {@code localVtSessionId} property.
   * @see #localVtSessionId
   */
  @Generated
  public BBacnetUnsigned getLocalVtSessionId() { return (BBacnetUnsigned)get(localVtSessionId); }

  /**
   * Set the {@code localVtSessionId} property.
   * @see #localVtSessionId
   */
  @Generated
  public void setLocalVtSessionId(BBacnetUnsigned v) { set(localVtSessionId, v, null); }

  //endregion Property "localVtSessionId"

  //region Property "remoteVtSessionId"

  /**
   * Slot for the {@code remoteVtSessionId} property.
   * @see #getRemoteVtSessionId
   * @see #setRemoteVtSessionId
   */
  @Generated
  public static final Property remoteVtSessionId = newProperty(0, BBacnetUnsigned.DEFAULT, BFacets.makeInt(0, 255));

  /**
   * Get the {@code remoteVtSessionId} property.
   * @see #remoteVtSessionId
   */
  @Generated
  public BBacnetUnsigned getRemoteVtSessionId() { return (BBacnetUnsigned)get(remoteVtSessionId); }

  /**
   * Set the {@code remoteVtSessionId} property.
   * @see #remoteVtSessionId
   */
  @Generated
  public void setRemoteVtSessionId(BBacnetUnsigned v) { set(remoteVtSessionId, v, null); }

  //endregion Property "remoteVtSessionId"

  //region Property "remoteVtAddress"

  /**
   * Slot for the {@code remoteVtAddress} property.
   * @see #getRemoteVtAddress
   * @see #setRemoteVtAddress
   */
  @Generated
  public static final Property remoteVtAddress = newProperty(0, BBacnetAddress.DEFAULT, null);

  /**
   * Get the {@code remoteVtAddress} property.
   * @see #remoteVtAddress
   */
  @Generated
  public BBacnetAddress getRemoteVtAddress() { return (BBacnetAddress)get(remoteVtAddress); }

  /**
   * Set the {@code remoteVtAddress} property.
   * @see #remoteVtAddress
   */
  @Generated
  public void setRemoteVtAddress(BBacnetAddress v) { set(remoteVtAddress, v, null); }

  //endregion Property "remoteVtAddress"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetVtSession.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  @Override
  public void writeAsn(AsnOutput out)
  {
    out.writeUnsigned(getLocalVtSessionId());
    out.writeUnsigned(getRemoteVtSessionId());
    getRemoteVtAddress().writeAsn(out);
  }

  @Override
  public void readAsn(AsnInput in)
    throws AsnException
  {
    BBacnetUnsigned localVtSessionId = in.readUnsigned();
    BBacnetUnsigned remoteVtSessionId = in.readUnsigned();
    // Decoding error within BacnetAddress leaves the RemoteVtAddress property unaltered
    getRemoteVtAddress().readAsn(in);
    set(BBacnetVtSession.localVtSessionId, localVtSessionId, noWrite);
    set(BBacnetVtSession.remoteVtSessionId, remoteVtSessionId, noWrite);
  }

  @Override
  public String toString(Context context)
  {
    // From ANSI/ASHRAE Standard 135-2020, 12.11.22 Active_VT_Sessions
    // The Active_VT_Sessions property is a BACnetLIST of BACnetVTSession each of which consists of
    // a Local VT Session Identifier, a Remote VT Session Identifier, and Remote VT Address. This
    // property provides a network-visible indication of those virtual terminal sessions
    // (VT-Sessions) that are active at any given time.
    //
    // Because these session identifiers are network visible, it is safe to print them here.
    return "BACnetVTSession" +
      ": localVtSessionId = " + getLocalVtSessionId().toString(context) +
      "; remoteVtSessionId = " + getRemoteVtSessionId().toString(context) +
      "; remoteVtAddress = [" + getRemoteVtAddress().toString(context) + ']';
  }

  /**
   * Used in readRange requests to determine when to end a segment.
   * <p>
   * Maximum property encoding sizes [bytes]:
   * <ul>
   *   <li>local-vt-session-id (8-bit): 2</li>
   *   <li>remote-vt-session-id (8-bit): 2</li>
   *   <li>
   *     remote-vt-address
   *     <ul>
   *       <li>network-number (16-bit): 3</li>
   *       <li>mac-address: 8</li>
   *     </ul>
   *   </li>
   * </ul>
   */
  public static final int MAX_ENCODED_SIZE = 15;
}
