/*
 * Copyright 2002 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.bacnet.export;

import java.util.Vector;

import javax.baja.alarm.ext.BFaultAlgorithm;
import javax.baja.alarm.ext.fault.BOutOfRangeFaultAlgorithm;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetEventType;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReliability;
import javax.baja.bacnet.io.AsnException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.control.BNumericPoint;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.bacnet.asn.AsnInputStream;
import com.tridium.bacnet.asn.AsnOutputStream;
import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.asn.NReadPropertyResult;

/**
 * BBacnetPositiveIntegerValuePrioritizedDescriptor exposes a ControlPoint as a Bacnet
 * Positive Integer Value Prioritized Descriptor.
 *
 * @author Joseph Chandler on 19 Feb 02
 * @since Niagara 3 Bacnet 1.0
 */
@NiagaraType(
  agent = @AgentOn(
    types = "control:NumericWritable"
  )
)
/*
 objectId is the identifier by which this point is known
 to the Bacnet world.
 */
@NiagaraProperty(
  name = "objectId",
  type = "BBacnetObjectIdentifier",
  defaultValue = "BBacnetObjectIdentifier.make(BBacnetObjectType.POSITIVE_INTEGER_VALUE)",
  flags = Flags.DEFAULT_ON_CLONE,
  override = true
)
public class BBacnetPositiveIntegerValuePrioritizedDescriptor
  extends BBacnetAnalogWritableDescriptor
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.bacnet.export.BBacnetPositiveIntegerValuePrioritizedDescriptor(3650661479)1.0$ @*/
/* Generated Thu Jun 02 14:30:02 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Property "objectId"

  /**
   * Slot for the {@code objectId} property.
   * objectId is the identifier by which this point is known
   * to the Bacnet world.
   * @see #getObjectId
   * @see #setObjectId
   */
  @Generated
  public static final Property objectId = newProperty(Flags.DEFAULT_ON_CLONE, BBacnetObjectIdentifier.make(BBacnetObjectType.POSITIVE_INTEGER_VALUE), null);

  //endregion Property "objectId"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BBacnetPositiveIntegerValuePrioritizedDescriptor.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  @Override
  protected BBacnetReliability validatePoint(BNumericPoint point, BStatusNumeric pointOut)
  {
    return validatePositiveIntegerPoint(point, pointOut);
  }

  @Override
  public int asnType()
  {
    return ASN_UNSIGNED;
  }

  /**
   * This is a loss-y conversion
   *
   * @param value double value to convert to asn.1
   * @return truncated and asn.1 encoded integer
   */
  @Override
  public byte[] convertToAsn(double value)
  {
    return AsnUtil.toAsnUnsigned((long)value);
  }

  /**
   * Read a bacnet integer and convert into a double
   * ~precise up to +/- 2^53
   *
   * @param value asn.1 byte array containing a number
   * @return converted double value
   * @throws AsnException
   */
  @Override
  public double convertFromAsn(byte[] value)
    throws AsnException
  {
    return AsnUtil.fromAsnUnsignedInteger(value);
  }

  /**
   * @param out   asn.1 byte stream to append the numeric value
   * @param value asn.1 byte array containing a number
   */
  @Override
  public void appendToAsn(AsnOutputStream out, double value)
  {
    out.writeUnsignedInteger((long)value);
  }

  /**
   * @param in asn.1 byte stream read a numeric value from
   * @return bacnet integer truncated to java double
   * @throws AsnException if an unexpected ASN_TYPE is encountered
   */
  @Override
  public double readFromAsn(AsnInputStream in)
    throws AsnException
  {
    return in.readUnsignedInteger();
  }

  /**
   * Get the BACnetEventType reported by this object.
   * @since Niagara 4.14u3
   * @since Niagara 4.15u2
   */
  @Override
  public BEnum getEventType()
  {
    return BBacnetEventType.unsignedOutOfRange;
  }

  @Override
  @SuppressWarnings({"rawtypes", "unchecked"})
  protected void addRequiredProps(Vector v)
  {
    v.add(BBacnetPropertyIdentifier.presentValue);
    v.add(BBacnetPropertyIdentifier.statusFlags);
    v.add(BBacnetPropertyIdentifier.units);
  }

  /**
   * Subclass override method to add optional properties.
   * NOTE: You MUST call super.addOptionalProps(v) first!
   * @param v Vector containing optional propertyIds.
   */
  @Override
  @SuppressWarnings("rawtypes")
  protected void addOptionalProps(Vector v)
  {
    addPrioritizedValueObjectOptionalProps(v);
  }

  /**
   * @param s the
   * @return the appropriate slot facets.
   */
  @Override
  public final BFacets getSlotFacets(Slot s)
  {
    if (s == objectId)
    {
      return BBacnetObjectType.getObjectIdFacets(BBacnetObjectType.POSITIVE_INTEGER_VALUE);
    }
    return super.getSlotFacets(s);
  }

  /**
   * Read the value of an optional property.
   * Subclasses with additional properties override this to check for
   * their properties.  If no match is found, call this superclass
   * method to check these properties.
   *
   * @param pId the requested property-identifier.
   * @param ndx the property array index (-1 if not specified).
   * @return a PropertyValue containing either the encoded value or the error.
   */
  @Override
  protected PropertyValue readOptionalProperty(int pId, int ndx)
  {
    switch (pId)
    {
      case BBacnetPropertyIdentifier.FAULT_HIGH_LIMIT:
      {
        BFaultAlgorithm faultAlgorithm = getFaultAlgorithm();
        if (faultAlgorithm instanceof BOutOfRangeFaultAlgorithm)
        {
          return new NReadPropertyResult(pId, ndx, convertToAsn(((BOutOfRangeFaultAlgorithm)faultAlgorithm).getHighLimit()));
        }
        break;
      }

      case BBacnetPropertyIdentifier.FAULT_LOW_LIMIT:
      {
        BFaultAlgorithm faultAlgorithm = getFaultAlgorithm();
        if (faultAlgorithm instanceof BOutOfRangeFaultAlgorithm)
        {
          return new NReadPropertyResult(pId, ndx, convertToAsn(((BOutOfRangeFaultAlgorithm)faultAlgorithm).getLowLimit()));
        }
        break;
      }
    }
    return super.readOptionalProperty(pId, ndx);
  }

  /**
   * Set the value of an optional property.
   * Subclasses with additional properties override this to check for
   * their properties.  If no match is found, call this superclass
   * method to check these properties.
   *
   * @param pId the requested property-identifier.
   * @param ndx the property array index (-1 if not specified).
   * @param val the Asn-encoded value for the property.
   * @param pri the priority level (only used for commandable properties).
   * @return null if everything goes OK, or
   * an ErrorType describing the error if not.
   */
  @Override
  protected ErrorType writeOptionalProperty(
    int pId,
    int ndx,
    byte[] val,
    int pri)
      throws BacnetException
  {
    switch (pId)
    {
      case BBacnetPropertyIdentifier.FAULT_HIGH_LIMIT:
      {
        BFaultAlgorithm faultAlgorithm = getFaultAlgorithm();
        if (faultAlgorithm instanceof BOutOfRangeFaultAlgorithm)
        {
          faultAlgorithm.setDouble(BOutOfRangeFaultAlgorithm.highLimit, convertFromAsn(val), BLocalBacnetDevice.getBacnetContext());
          return null;
        }
        break;
      }

      case BBacnetPropertyIdentifier.FAULT_LOW_LIMIT:
      {
        BFaultAlgorithm faultAlgorithm = getFaultAlgorithm();
        if (faultAlgorithm instanceof BOutOfRangeFaultAlgorithm)
        {
          faultAlgorithm.setDouble(BOutOfRangeFaultAlgorithm.lowLimit, convertFromAsn(val), BLocalBacnetDevice.getBacnetContext());
          return null;
        }
        break;
      }
    }
    return super.writeOptionalProperty(pId, ndx, val, pri);
  }
}
