/*
 * Copyright 2003 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.security;

/**
 * AuthenticationRealm is implemented by objects which
 * throw AuthenticationException.  It gives the application
 * layer a chance to gather new credentials and store them
 * back to the realm for another shot.
 *
 * @author    Brian Frank
 * @creation  28 Jan 03
 * @version   $Revision: 5$ $Date: 5/21/03 2:44:59 PM EDT$
 * @since     Baja 1.0
 */
public interface AuthenticationRealm 
{ 

  /**
   * Get a name for the space itself.  The value of this 
   * method should be a universal identifier for the protection
   * space which makes sense to a user and may be used as 
   * key for caching credentials.  Usually this should be
   * an absolute ord for the object which defines the realm.
   */
  public String getAuthenticationRealmName();

  /**
   * Get a description of the authentication mechanism
   * being used.  For example if HTTP is it Basic or Digest.
   */
  public String getAuthenticationScheme();

  /**
   * Return an array of available authentication scheme names to choose from,
   * or null if scheme selection is not required.
   *
   * @return array of available authentication schemes
   * @since Niagara 4.9
   */
  public default String[] getAvailableAuthenticationSchemes()
  {
    return null;
  }

  /**
   * Return the name of the default authentication scheme, or null if scheme
   * selection is not required.
   *
   * @return name of the default authentication scheme
   * @since Niagara 4.9
   */
  public default String getDefaultAuthenticationScheme()
  {
    return null;
  }

  /**
   * Make a default instance of the proper BICredentials
   * implementation to use for prompting the user.
   */
  public BICredentials makeCredentials();

  /**
   * Get the current credentials being used to log 
   * into the authentication space.  If no credentials
   * have been set then return null.
   */
  public BICredentials getCredentials();
  
  /**
   * Set the current credentials to use for the next
   * authentication attempt.
   */
  public void setCredentials(BICredentials credentials);
  
}
