/*
 * Copyright 2022 Tridium, Inc. All Rights Reserved.
 */

package javax.baja.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;

import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SecurityUtil;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.crypto.core.cert.CertUtils;

/**
 * BCertificateAliasAndPassword holds a certificate alias and the BPassword for retrieving
 * it from the user key store.
 *
 * @author Bill Smith on 2022-08-16
 * @since Niagara 4.13
 */
@NiagaraType
@NiagaraProperty(
  name = "alias",
  type = "String",
  defaultValue = "CertUtils.FACTORY_CERT_ALIAS",
  flags = Flags.DEFAULT_ON_CLONE,
  facets = {
    @Facet(name = "BFacets.FIELD_EDITOR", value = "BString.make(\"workbench:CertificateAliasFE\")"),
    @Facet(name = "BFacets.UX_FIELD_EDITOR", value = "BString.make(\"webEditors:CertificateAliasEditor\")"),
    @Facet("BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")
  }
)
@NiagaraProperty(
  name = "password",
  type = "BPassword",
  defaultValue = "BPassword.DEFAULT",
  flags = Flags.DEFAULT_ON_CLONE,
  facets = {
    @Facet(name = "BFacets.FIELD_EDITOR", value = "BString.make(\"workbench:DefaultPasswordFE\")"),
    @Facet(name = "BFacets.UX_FIELD_EDITOR", value = "BString.make(\"webEditors:DefaultPasswordEditor\")"),
    @Facet(name = "BPassword.PLACEHOLDER_TEXT", value = "\"%lexicon(workbench:default.password.placeholder.label)%\""),
    @Facet("BFacets.make(BFacets.SECURITY, BBoolean.TRUE)")
  }
)
public class BCertificateAliasAndPassword
  extends BStruct
  implements BICredentials, BIDeferOwnership
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.security.BCertificateAliasAndPassword(80653536)1.0$ @*/
/* Generated Fri Nov 25 11:35:46 IST 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Property "alias"

  /**
   * Slot for the {@code alias} property.
   * @see #getAlias
   * @see #setAlias
   */
  @Generated
  public static final Property alias = newProperty(Flags.DEFAULT_ON_CLONE, CertUtils.FACTORY_CERT_ALIAS, BFacets.make(BFacets.make(BFacets.make(BFacets.FIELD_EDITOR, BString.make("workbench:CertificateAliasFE")), BFacets.make(BFacets.UX_FIELD_EDITOR, BString.make("webEditors:CertificateAliasEditor"))), BFacets.make(BFacets.SECURITY, BBoolean.TRUE)));

  /**
   * Get the {@code alias} property.
   * @see #alias
   */
  @Generated
  public String getAlias() { return getString(alias); }

  /**
   * Set the {@code alias} property.
   * @see #alias
   */
  @Generated
  public void setAlias(String v) { setString(alias, v, null); }

  //endregion Property "alias"

  //region Property "password"

  /**
   * Slot for the {@code password} property.
   * @see #getPassword
   * @see #setPassword
   */
  @Generated
  public static final Property password = newProperty(Flags.DEFAULT_ON_CLONE, BPassword.DEFAULT, BFacets.make(BFacets.make(BFacets.make(BFacets.make(BFacets.FIELD_EDITOR, BString.make("workbench:DefaultPasswordFE")), BFacets.make(BFacets.UX_FIELD_EDITOR, BString.make("webEditors:DefaultPasswordEditor"))), BFacets.make(BPassword.PLACEHOLDER_TEXT, "%lexicon(workbench:default.password.placeholder.label)%")), BFacets.make(BFacets.SECURITY, BBoolean.TRUE)));

  /**
   * Get the {@code password} property.
   * @see #password
   */
  @Generated
  public BPassword getPassword() { return (BPassword)get(password); }

  /**
   * Set the {@code password} property.
   * @see #password
   */
  @Generated
  public void setPassword(BPassword v) { set(password, v, null); }

  //endregion Property "password"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BCertificateAliasAndPassword.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BCertificateAliasAndPassword()
  {
  }

  public BCertificateAliasAndPassword(String alias, BPassword password)
  {
    Objects.requireNonNull(alias);
    Objects.requireNonNull(password);
    setAlias(alias);
    setPassword(password);
  }

  /**
   * resets the alias and password to defaults
   */
  public void resetAliasAndPassword()
  {
    setAlias(CertUtils.FACTORY_CERT_ALIAS);
    setPassword(BPassword.DEFAULT);
  }

  @Override
  public byte[] encodeCredentials(Context context)
    throws IOException
  {
    ByteArrayOutputStream bout = new ByteArrayOutputStream();
    DataOutputStream out = new DataOutputStream(bout);
    BString.make(getAlias()).encode(out);
    getPassword().encode(out, context);
    out.flush();
    return bout.toByteArray();
  }

  @Override
  public BICredentials decodeCredentials(byte[] encoding, Context context)
    throws IOException
  {
    ByteArrayInputStream bin = new ByteArrayInputStream(encoding);
    DataInputStream in = new DataInputStream(bin);
    BCertificateAliasAndPassword x = (BCertificateAliasAndPassword)newCopy();
    x.set(alias, (BValue)BString.DEFAULT.decode(in));
    x.set(password, (BValue)BPassword.DEFAULT.decode(in, context));
    return x;
  }

  @Override
  public boolean equivalent(Object obj)
  {
    if (obj != null &&
      obj.getClass() == getClass() &&
      SecurityUtil.equals(((BCertificateAliasAndPassword)obj).getAlias(), getAlias()))
    {
      BPassword p = ((BCertificateAliasAndPassword)obj).getPassword();
      return p.equals(getPassword()) ||
        p.getPasswordEncoder().isReversible() &&
          getPassword().getPasswordEncoder().isReversible() &&
          p.validate(getPassword());
    }
    else
    {
      return false;
    }
  }

  @Override
  public String toString(Context context)
  {
    return getAlias();
  }

  /**
   * @return true if the password has been set to a non default value.
   */
  public boolean isPasswordSet()
  {
    return !getPassword().isDefault();
  }

  public static final BCertificateAliasAndPassword DEFAULT = new BCertificateAliasAndPassword();
}
