/*
 * Copyright 2003 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.security;

import java.io.*;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.*;

/**
 * BICredentials is used for types which store authentication
 * credentials.  See BUsernameAndPassword for a simple implementation.
 *
 * @author    Brian Frank
 * @creation  28 Jan 03
 * @version   $Revision: 5$ $Date: 7/21/10 2:20:49 PM EDT$
 * @since     Baja 1.0
 */
@NiagaraType
public interface BICredentials
  extends BInterface
{ 
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.security.BICredentials(2979906276)1.0$ @*/
/* Generated Wed Dec 29 19:27:38 CST 2021 by Slot-o-Matic (c) Tridium, Inc. 2012-2021 */

  //region Type

  @Generated
  Type TYPE = Sys.loadType(BICredentials.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Encode the credentials into a byte array which 
   * may stored in a credential database.
   */
  byte[] encodeCredentials(Context context)
    throws IOException;
  
  /**
   * Decode into a new instance of BICredentials from a 
   * byte array generated using encode().
   */
  BICredentials decodeCredentials(byte[] encoding, Context context)
    throws IOException;
}
