/*
 * Copyright 2003 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.security;

import javax.baja.category.*;
import javax.baja.naming.*;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.*;

/**
 * BIProtected is implemented by BObjects which are should
 * be protected via the security architecture.  Every protected
 * instance must support the BICategorizable interface for
 * assignment into one or more categories.
 *
 * @author    Brian Frank
 * @creation  1 May 03
 * @version   $Revision: 7$ $Date: 6/20/07 7:39:10 PM EDT$
 * @since     Baja 1.0
 */
@NiagaraType
public interface BIProtected
  extends BICategorizable
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.security.BIProtected(2979906276)1.0$ @*/
/* Generated Wed Dec 29 19:27:38 CST 2021 by Slot-o-Matic (c) Tridium, Inc. 2012-2021 */

  //region Type

  @Generated
  Type TYPE = Sys.loadType(BIProtected.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Get the set of permissions available based on the
   * specified context.  If the context is non-null and
   * has a non-null user then this method must return
   * <code>cx.getUser().getPermissionsFor(this)</code>.
   * If the context is null then typically this method
   * should return <code>BPermissions.all</code>.  If this
   * happens to be a proxy object within a remote session,
   * then this method should return a cached instance
   * of BPermissions based on the credentials used to
   * establish the session.  Under no circumstances should
   * this method return null or make a network call.
   */
  public BPermissions getPermissions(Context cx);  
  
  /**
   * Return true if the specified target object has read permission.
   * It is up to the implementation to decide whether operator or
   * admin read permission should be checked.
   */
  public boolean canRead(OrdTarget cx);
  
  /**
   * Return true if the specified target object has write permission.
   * It is up to the implementation to decide whether operator or
   * admin write permission should be checked.
   */
  public boolean canWrite(OrdTarget cx);

  /**
   * Return true if the specified target object has invoke permission.
   * It is up to the implementation to decide whether operator or
   * admin invoke permission should be checked.
   */
  public boolean canInvoke(OrdTarget cx);
}
