/*
 * Copyright 2015 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.security;

import java.io.IOException;

import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.nre.security.SecretChars;


/**
 *
 *
 * @author Tom Duffy
 * @creation 8/8/2014
 * @since Niagara 4.0
 */
@NiagaraType
@NiagaraProperty(
  name = "password",
  type = "BPassword",
  defaultValue = "BPassword.DEFAULT",
  flags = Flags.HIDDEN | Flags.READONLY,
  facets = {
    @Facet(name = "BFacets.FIELD_EDITOR", value = "\"wbutil:UserPasswordFE\""),
    @Facet(name = "BFacets.UX_FIELD_EDITOR", value = "\"webEditors:UserPasswordEditor\"")
  }
)
public class BPasswordCache
  extends BAbstractAuthenticator
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.security.BPasswordCache(3571642305)1.0$ @*/
/* Generated Thu Jun 02 14:30:01 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Property "password"

  /**
   * Slot for the {@code password} property.
   * @see #getPassword
   * @see #setPassword
   */
  @Generated
  public static final Property password = newProperty(Flags.HIDDEN | Flags.READONLY, BPassword.DEFAULT, BFacets.make(BFacets.make(BFacets.FIELD_EDITOR, "wbutil:UserPasswordFE"), BFacets.make(BFacets.UX_FIELD_EDITOR, "webEditors:UserPasswordEditor")));

  /**
   * Get the {@code password} property.
   * @see #password
   */
  @Generated
  public BPassword getPassword() { return (BPassword)get(password); }

  /**
   * Set the {@code password} property.
   * @see #password
   */
  @Generated
  public void setPassword(BPassword v) { set(password, v, null); }

  //endregion Property "password"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BPasswordCache.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  public BPasswordCache(){}

  public BPasswordCache(BPassword value)
  {
    setPassword(value);
  }

  public final boolean validate(String authInfo)
  {
    return getPassword().validate(authInfo);
  }

  public final boolean validate(SecretChars authInfo)
  {
    return getPassword().validate(authInfo);
  }

  public BAbstractPasswordEncoder getPasswordEncoder()
  {
    return getPassword().getPasswordEncoder();
  }

  public static final BPasswordCache DEFAULT = new BPasswordCache();
}
