/*
 * Copyright 2023 Tridium, Inc. All Rights Reserved.
 */

package javax.baja.security;

import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIUnlinkable;
import javax.baja.sys.BStruct;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;


/**
 * BUserPasswordChangeParams - This Struct is used to prompt the parameters
 * for the action "Update Password" for an Operator user who knows their current password.
 * Admin users can also use this action to change other users' passwords if they know the
 * other users' current password.
 * 
 * @author Sabana Bandopadhyay on 26 April 2023
 * @since  Niagara 4.14
 */

@NiagaraType
@NiagaraProperty(
  name = "currentPassword",
  type = "BPassword",
  defaultValue = "BPassword.DEFAULT"
)
@NiagaraProperty(
  name = "newPassword",
  type = "BPassword",
  defaultValue = "BPassword.DEFAULT",
  facets = {
    @Facet(name = "BFacets.FIELD_EDITOR", value = "\"wbutil:ConfirmPasswordFE\""),
    @Facet(name = "BFacets.UX_FIELD_EDITOR", value = "\"webEditors:ConfirmPasswordEditor\"")
  }
)
public class BUserPasswordChangeParams
  extends BStruct
  implements BIUnlinkable
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.security.BUserPasswordChangeParams(1225170145)1.0$ @*/
/* Generated Fri Apr 28 14:11:40 EDT 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  //region Property "currentPassword"

  /**
   * Slot for the {@code currentPassword} property.
   * @see #getCurrentPassword
   * @see #setCurrentPassword
   */
  @Generated
  public static final Property currentPassword = newProperty(0, BPassword.DEFAULT, null);

  /**
   * Get the {@code currentPassword} property.
   * @see #currentPassword
   */
  @Generated
  public BPassword getCurrentPassword() { return (BPassword)get(currentPassword); }

  /**
   * Set the {@code currentPassword} property.
   * @see #currentPassword
   */
  @Generated
  public void setCurrentPassword(BPassword v) { set(currentPassword, v, null); }

  //endregion Property "currentPassword"

  //region Property "newPassword"

  /**
   * Slot for the {@code newPassword} property.
   * @see #getNewPassword
   * @see #setNewPassword
   */
  @Generated
  public static final Property newPassword = newProperty(0, BPassword.DEFAULT, BFacets.make(BFacets.make(BFacets.FIELD_EDITOR, "wbutil:ConfirmPasswordFE"), BFacets.make(BFacets.UX_FIELD_EDITOR, "webEditors:ConfirmPasswordEditor")));

  /**
   * Get the {@code newPassword} property.
   * @see #newPassword
   */
  @Generated
  public BPassword getNewPassword() { return (BPassword)get(newPassword); }

  /**
   * Set the {@code newPassword} property.
   * @see #newPassword
   */
  @Generated
  public void setNewPassword(BPassword v) { set(newPassword, v, null); }

  //endregion Property "newPassword"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BUserPasswordChangeParams.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/
}
