/*
 * Copyright 2019 Tridium, Inc. All Rights Reserved.
 */

package javax.baja.security;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Clock;

/**
 * SecurityAuditEvent to be logged to the SecurityAuditor when security related
 * actions occur in the station.
 *
 * @author Patrick Sager on 10/15/2019
 * @since Niagara 4.9
 */
public class SecurityAuditEvent
{
  public SecurityAuditEvent(String operation, String userName, String message)
  {
    this.operation = operation;
    this.userName = userName;
    this.message = message;
    timestamp = Clock.time();
  }

  public String getOperation()
  {
    return operation;
  }

  public String getUserName()
  {
    return userName;
  }

  public String getMessage()
  {
    return message;
  }

  public BAbsTime getTimestamp()
  {
    return timestamp;
  }

  public String toString()
  {
    return String.format("[%s][%s][%s][%s]",
                         format.format(new Date(timestamp.getMillis())),
                         userName,
                         operation,
                         message);
  }

  public static final String LOGIN = "Login";
  public static final String LOGOUT = "Logout";
  public static final String LOGIN_FAILURE = "Login Failure";
  public static final String TIMEOUT = "Logout (Timeout)";
  public static final String CHANGED = "Changed";
  public static final String RECATEGORIZED = "Recategorized";
  /**
   * @since Niagara 4.13
   */
  public static final String INVOKED = "Invoked";

  private final DateFormat format = new SimpleDateFormat("HH:mm:ss dd-MMM-yy");

  private final String operation;
  private final String userName;
  private final String message;
  private final BAbsTime timestamp;
}
