/*
 * Copyright 2005 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.driver.point;

import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BProxyConversion is the base class for BSimples which provide
 * conversion support between the device value space and the proxy
 * value space.
 *
 * @author    Brian Frank
 * @creation  9 Feb 05
 * @version   $Revision: 1$ $Date: 2/9/05 4:50:28 PM EST$
 * @since     Baja 1.0
 */
@NiagaraType
public abstract class BProxyConversion
  extends BSimple
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.driver.point.BProxyConversion(2979906276)1.0$ @*/
/* Generated Tue Jun 06 12:01:43 EDT 2023 by Slot-o-Matic (c) Tridium, Inc. 2012-2023 */

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BProxyConversion.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Conversion
////////////////////////////////////////////////////////////////

  /**
   * Convert the deviceValue to the proxyValue.
   * Throw an exception to mark proxyValue as fault.
   */
  public abstract void convertDeviceToProxy(BProxyExt ext, BStatusValue deviceValue, BStatusValue proxyValue)
    throws Exception;

  /**
   * Convert the proxyValue to the deviceValue.
   * Throw an exception to mark deviceValue as fault.
   */
  public abstract void convertProxyToDevice(BProxyExt ext, BStatusValue proxyValue, BStatusValue deviceValue)
    throws Exception;
}
