/*
 * Copyright 2006 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.file.types.image;

import javax.baja.file.BIFileStore;
import javax.baja.file.types.text.BIXmlFile;
import javax.baja.nre.annotations.FileExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/**
 * BSvgFile stores an SVG image.
 *
 * @author    Andy Frank       
 * @creation  09 Jan 06
 * @version   $Revision: 1$ $Date: 1/9/06 4:27:44 PM EST$
 * @since     Baja 1.0
 */
@NiagaraType(
  ext = @FileExt(name = "svg")
)
public class BSvgFile
  extends BImageFile
  implements BIXmlFile
{ 
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.file.types.image.BSvgFile(4117672842)1.0$ @*/
/* Generated Thu Jun 02 14:30:02 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BSvgFile.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Constructor
////////////////////////////////////////////////////////////////

  /**
   * Construct a file with the specified store.
   */
  public BSvgFile(BIFileStore store)
  {
    super(store);
  }

  /**
   * Construct (must call setStore()).
   */
  public BSvgFile()
  {  
  }

////////////////////////////////////////////////////////////////
// Overrides
////////////////////////////////////////////////////////////////

  /**
   * Return {@code "image/svg+xml"}.
   */
  @Override
  public String getMimeType()
  {
    return "image/svg+xml";
  }
}
