/*
 * Copyright (c) 2014 Tridium, Inc. All Rights Reserved.
 */

package javax.baja.nre.util;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.tridium.nre.util.NiagaraFiles;

/**
 * DefaultFileCopy is a utility class responsible for unpacking files out of the !defaults
 * template directory to the appropriate runtime location.
 *
 * @author Bill Smith on 6/17/2014
 */
public class DefaultFileCopy
{
  public static void copyFile(String fileName)
    throws IllegalStateException, IOException
  {
    copyFile(fileName, false);
  }

  public static void copyFile(String fileName, boolean overWrite)
    throws IllegalStateException, IOException
  {
    try
    {
      File src = SecurityUtil.resolveChrootPath(NiagaraFiles.getNiagaraHomeDefaultsPath(), fileName);
      File target = SecurityUtil.resolveChrootPath(NiagaraFiles.getNiagaraUserHomeEtcPath(), fileName);

      // if target already exists, skip
      if (target.exists())
      {
        if (overWrite)
        {
          FileUtil.delete(target);
        }
        else
        {
          return;
        }
      }

      if (sysLog.isLoggable(Level.FINE))
      {
        sysLog.fine("copying default file for '" + target + "'");
      }

      File parent = target.getParentFile();
      if (!parent.exists())
      {
        if (!parent.mkdirs())
        {
          sysLog.warning("failed to create directory '" + parent + "', may be unable to copy default file for '" + fileName + "'");
        }
      }

      FileUtil.copyFile(src, target);
    }
    catch (Exception e)
    {
      sysLog.log(Level.SEVERE, "failed to copy default file '" + fileName + "'", e);
      throw e;
    }
  }

  public static void copyDir(String dirName, boolean overWrite)
    throws IllegalStateException, IOException
  {
    try
    {
      File src = SecurityUtil.resolveChrootPath(NiagaraFiles.getNiagaraHomeDefaultsPath(), dirName);
      File target = SecurityUtil.resolveChrootPath(NiagaraFiles.getNiagaraUserHomeEtcPath(), dirName);

      // if target already exists, skip
      if (target.exists())
      {
        if (overWrite)
        {
          FileUtil.delete(target);
        }
        else
        {
          return;
        }
      }

      if (sysLog.isLoggable(Level.FINE))
      {
        sysLog.fine("copying default file for '" + target + "'");
      }

      FileUtil.copyDir(src, target);
    }
    catch (Exception e)
    {
      sysLog.log(Level.SEVERE, "failed to copy default directory '" + dirName + "'", e);
    }
  }

  //region Attributes
  private static final Logger sysLog = Logger.getLogger("sys.files");
//endregion
}
