/*
 * Copyright 2014 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.tagdictionary;

import static com.tridium.tagdictionary.util.ImportExportConst.JSON_DEFAULT;
import static com.tridium.tagdictionary.util.ImportExportConst.JSON_NAME;
import static com.tridium.tagdictionary.util.ImportExportConst.JSON_VALUE_TYPE;
import static com.tridium.tagdictionary.util.ImportUtil.decodeType;

import java.io.IOException;

import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BMarker;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;

/**
 * BSimpleTagInfo is a {@code BComponent} implementation of {@code TagInfo} that
 * contains a default value.
 *
 * @author John Sublett
 * @creation 2/13/14
 * @since Niagara 4.0
 */
@NiagaraType
@NiagaraProperty(
  name = "defValue",
  type = "BValue",
  defaultValue = "BMarker.MARKER"
)
public class BSimpleTagInfo
  extends BTagInfo
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.tagdictionary.BSimpleTagInfo(4238238071)1.0$ @*/
/* Generated Thu Jun 02 14:30:06 EDT 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Property "defValue"

  /**
   * Slot for the {@code defValue} property.
   * @see #getDefValue
   * @see #setDefValue
   */
  @Generated
  public static final Property defValue = newProperty(0, BMarker.MARKER, null);

  /**
   * Get the {@code defValue} property.
   * @see #defValue
   */
  @Generated
  public BValue getDefValue() { return get(defValue); }

  /**
   * Set the {@code defValue} property.
   * @see #defValue
   */
  @Generated
  public void setDefValue(BValue v) { set(defValue, v, null); }

  //endregion Property "defValue"

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BSimpleTagInfo.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

////////////////////////////////////////////////////////////////
// Constructors
////////////////////////////////////////////////////////////////

  /**
   * Default constructor
   */
  public BSimpleTagInfo()
  {
  }

  /**
   * Constructor that initializes the {@link #defValue} property.
   *
   * @param defaultValue initial default value
   */
  public BSimpleTagInfo(BIDataValue defaultValue)
  {
    setDefValue((BValue)defaultValue);
  }

////////////////////////////////////////////////////////////////
// Methods
////////////////////////////////////////////////////////////////

  /**
   * Set the {@link #defValue} property value.
   *
   * @param value new default value
   */
  public void setDefaultValue(BIDataValue value)
  {
    setDefValue((BValue)value);
  }

////////////////////////////////////////////////////////////////
// TagInfo
////////////////////////////////////////////////////////////////

  /**
   * Get the default value of the tag.  This also restricts the data type for the tag value.
   * See {@link #getTagType()}.
   *
   * @return default value of the tag
   */
  @Override
  public BIDataValue getDefaultValue()
  {
    BValue def = getDefValue();
    if (def instanceof BIDataValue)
      return (BIDataValue)def;
    else
      throw new IllegalStateException("defValue is not a valid data value.");
  }

  /**
   * Encode to a JSON representation
   * @since Niagara 4.14
   */
  @Override
  public void encodeToJson(JSONWriter writer)
  {
    if (!getDefaultValue().getType().is(BMarker.TYPE))
    {
      BIDataValue tagValue = getDefaultValue();
      writer.key(JSON_VALUE_TYPE).value(tagValue.getType());
      try
      {
        writer.key(JSON_DEFAULT).value(tagValue.encodeToString());
      }
      catch (IOException e)
      {
        throw new RuntimeException(e);
      }
    }
    super.encodeToJson(writer);
  }

  /**
   * Decode the Tag from a JSON representation
   *
   * @param tagJson the JSON for the tag
   * @since Niagara 4.14
   */
  @Override
  public void decodeFromJson(JSONObject tagJson)
  {
    super.decodeFromJson(tagJson);

    // Create a default value if this is not a marker tag
    String valueTypeString = tagJson.optString(JSON_VALUE_TYPE, "");
    if (!valueTypeString.isEmpty())
    {
      TypeInfo valueType = decodeType(valueTypeString, BIDataValue.TYPE);
      try
      {
        BIDataValue dataValue = (BIDataValue)valueType.getInstance();
        BValue value = (BValue)dataValue.decodeFromString(tagJson.getString(JSON_DEFAULT));
        setDefValue(value);
      }
      catch (IOException e)
      {
        throw new LocalizableRuntimeException("tagdictionary", "decodeJson.defaultValueError", new Object[]{ tagJson.optString(JSON_NAME, "") });
      }
    }
  }

////////////////////////////////////////////////////////////////
// BObject
////////////////////////////////////////////////////////////////

  /**
   * Returns the type name of the default value.
   *
   * @param cx execution context
   * @return {@code String} representation of the type of the default value
   */
  @Override
  public String toString(Context cx)
  {
    return getDefaultValue().getType().getTypeName();
  }
}
