/*
 * Copyright 2014 Tridium, Inc. All Rights Reserved.
 */
package javax.baja.tagdictionary;

import static com.tridium.tagdictionary.util.ImportExportConst.JSON_NAME;
import static com.tridium.tagdictionary.util.ImportExportConst.JSON_TYPE;
import static com.tridium.tagdictionary.util.ImportUtil.decodeType;
import static com.tridium.tagdictionary.util.TagDictionaryUtil.handleIllegalChild;

import java.util.Iterator;

import javax.baja.collection.SlotCursorIterator;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;

/**
 * A TagRuleList is a collection of TagRules associated with a SmartTagDictionary.
 *
 * @author John Sublett
 * @creation 2/18/14
 * @since Niagara 4.0
 */
@NiagaraType
public class BTagRuleList
  extends BInfoList
  implements Iterable<TagRule>
{
//region /*+ ------------ BEGIN BAJA AUTO GENERATED CODE ------------ +*/
//@formatter:off
/*@ $javax.baja.tagdictionary.BTagRuleList(2979906276)1.0$ @*/
/* Generated Tue Jan 25 17:26:55 CST 2022 by Slot-o-Matic (c) Tridium, Inc. 2012-2022 */

  //region Type

  @Override
  @Generated
  public Type getType() { return TYPE; }
  @Generated
  public static final Type TYPE = Sys.loadType(BTagRuleList.class);

  //endregion Type

//@formatter:on
//endregion /*+ ------------ END BAJA AUTO GENERATED CODE -------------- +*/

  /**
   * Returns an iterator over the tag rules in this list.
   *
   * @return iterator of tag rules
   */
  @Override
  public Iterator<TagRule> iterator()
  {
    return SlotCursorIterator.iterator(getProperties(), TagRule.class);
  }

  /**
   * Only components that implement {@link TagRule} may be added to a BTagRuleList.
   * @since Niagara 4.4
   */
  @Override
  public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context)
  {
    // Only allow RelationInfos to be added to a BRelationInfoList
    if (!(value instanceof TagRule))
      handleIllegalChild(this, value, context);

    super.checkAdd(name, value, flags, facets, context);
  }

  /**
   * Encode to a JSON representation
   * @since Niagara 4.14
   */
  public void encodeToJson(JSONWriter writer)
  {
    writer.array();
    for (TagRule rule : this)
    {
      BTagRule tagRule = (BTagRule) rule;
      writer.object();
      writer.key(JSON_NAME).value(SlotPath.unescape(tagRule.getName()));
      if (!tagRule.getType().equals(BTagRule.TYPE))
      {
        writer.key(JSON_TYPE).value(tagRule.getType());
      }
      tagRule.encodeToJson(writer);
      writer.endObject();
    }
    writer.endArray();
  }

  /**
   * Decode the Tag Rule List from a JSON representation
   *
   * @param tagRulesJson the JSON for the tag rule list
   * @since Niagara 4.14
   */
  public void decodeFromJson(JSONArray tagRulesJson)
  {
    for (Object o : tagRulesJson)
    {
      JSONObject tagRuleJson = (JSONObject) o;
      TypeInfo type = BTagRule.TYPE.getTypeInfo();
      if (tagRuleJson.has(JSON_TYPE))
      {
        type = decodeType(tagRuleJson.getString(JSON_TYPE), BTagRule.TYPE);
      }
      BTagRule tagRule = (BTagRule)type.getInstance();
      tagRule.decodeFromJson(tagRuleJson);
      // NAME is unescaped when generating Rule json
      add(SlotPath.escape(tagRuleJson.getString(JSON_NAME)), tagRule);
    }
  }
}
