/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview IncrementSetPointBinding class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'mobile/px/bindings/SetPointBinding'], function (baja, SetPointBinding) {
  "use strict";

  /**
   * @class Increment Set Point Binding.
   * 
   * A Component that represents a Niagara 'kitPx:IncrementSetPointBinding' Type.
   *
   * @name IncrementSetPointBinding
   * @extends SetPointBinding
   */
  function IncrementSetPointBinding() {
    baja.callSuper(IncrementSetPointBinding, this, arguments);
  }
  baja.subclass(IncrementSetPointBinding, SetPointBinding);

  /**
   * Save the Widget Property driving the target
   *
   * @return {baja.Value} the value for the Widget Property (or null if there's no value available);
   */
  IncrementSetPointBinding.prototype.saveWidgetProperty = function () {
    if (!this.isBound()) {
      return null;
    }
    var val = this.$target.getObject();
    if (!val.getType().is("baja:INumeric")) {
      return null;
    }
    return Number.getNumberFromINumeric(val) + this.getIncrement();
  };
  return IncrementSetPointBinding;
});
