/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview HyperlinkLabel class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'jquery', 'jquerymobile', 'mobile/px/util.px.mobile', 'mobile/px/widgets/Label'], function (baja, $, jqm, pxUtilMobile, Label) {
  "use strict";

  var hyperlink = pxUtilMobile.hyperlink,
    callSuper = baja.callSuper;

  /**
   * @class HyperlinkLabel
   *
   * The Widget that represents Niagara's 'bajaui:HyperlinkLabel' Type.
   *
   * @name HyperlinkLabel
   * @extends Label
   */
  function HyperlinkLabel() {
    callSuper(HyperlinkLabel, this, arguments);
  }
  baja.subclass(HyperlinkLabel, Label);

  /**
   * Append the Widget's DOM content onto the specified DOM element.
   *
   * @param {Object} dom DOM element to append content too.
   */
  HyperlinkLabel.prototype.load = function (dom) {
    callSuper("load", HyperlinkLabel, this, arguments);
    if (this.getOrd() !== baja.Ord.DEFAULT) {
      this.addMouseOver();
    }
  };

  /**
   * Handle a UI Widget event.
   */
  HyperlinkLabel.prototype.doHandleEvent = function (eventName) {
    var hlink = this.getOrd();
    if (hlink !== baja.Ord.DEFAULT) {
      hyperlink(this, this.getOrd());

      // Return true so the event doesn't filter down to the bindings
      return true;
    }
  };
  return HyperlinkLabel;
});
