/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview ScrollPane class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'jquery', 'jquerymobile', 'mobile/px/widgets/Widget', 'mobile/util/mobile/touchscroll'], function (baja, $, jqm, Widget, touchScroll) {
  "use strict";

  var callSuper = baja.callSuper;

  /**
   * @class ScrollPane.
   * 
   * The mobile pane Widget that represents Niagara's 'bajaui:ScrollPane' Type.
   * 
   * @name ScrollPane
   * @extends Widget
   */
  function ScrollPane() {
    callSuper(ScrollPane, this, arguments);
  }
  baja.subclass(ScrollPane, Widget);

  /**
   * Append the Widget's DOM content onto the specified DOM element.
   *
   * @param {Object} dom DOM element to append content too.
   */
  ScrollPane.prototype.load = function (dom) {
    var newDom = $("<div class='scrollPane'></div>"),
      parent = this.getParent();
    if (parent && parent.getType().is('bajaui:CanvasPane')) {
      touchScroll(newDom, {
        horiz: true,
        vert: true,
        showBlockade: false
      });
    }
    newDom.appendTo(dom);
    this.$dom = newDom;
  };
  function getOverflowVal(scrollBarPolicy) {
    var overflowVal;
    if (scrollBarPolicy.is("always")) {
      overflowVal = "scroll";
    } else if (scrollBarPolicy.is("asNeeded")) {
      overflowVal = "auto";
    } else {
      overflowVal = "hidden";
    }
    return overflowVal;
  }

  /**
   * Update the DOM associated with this Widget.
   *
   * @param {Function} hasUpdate called to test whether a 
   *                               given Property can update the DOM.
   */
  ScrollPane.prototype.doUpdate = function (hasUpdate) {
    var that = this,
      dom = that.$dom;

    // TODO: viewportBackground, borderPolicy

    if (hasUpdate("hpolicy")) {
      dom.css("overflow-x", getOverflowVal(that.getHpolicy()));
    }
    if (hasUpdate("vpolicy")) {
      dom.css("overflow-y", getOverflowVal(that.getVpolicy()));
    }
  };

  /**
   * Update the positioning of the child Widget
   *
   * @param {Widget} childWidget the Child Widget to be positioned.
   */
  ScrollPane.prototype.layoutChild = function (childWidget) {
    // Set the child Widget to its preferred height and width.
    childWidget.getDomElement().css({
      "width": childWidget.getPreferredWidth(),
      "height": childWidget.getPreferredHeight()
    });
  };
  return ScrollPane;
});
