function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
/**
 * @copyright 2019 Tridium, Inc. All Rights Reserved.
 */

/**
 * @private
 * @module nmodule/bajaui/rc/baja/Layout
 */

define(['baja!'], function (baja) {
  'use strict';

  /**
   * Encodes to a string format a portion of the parameter values.
   * @private
   * @param {number} value
   * @param {number} unit
   * @param {boolean} [canBePref=false]
   * @throws if unable to encode provided parameters.
   * @returns {string}
   */
  function encodeLayoutStringPart(value, unit) {
    var canBePref = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    if (unit === Layout.ABS) {
      return value;
    } else if (unit === Layout.PERCENT) {
      return value + "%";
    } else if (unit === Layout.PREF && canBePref) {
      return "pref";
    } else {
      throw new Error("String part value not valid.");
    }
  }

  /**
   *
   * Parses an item of an encoded string to debug information.
   * Only allows for pref format if pref is true.
   *
   *
   *
   * @private
   * @param {String} str Examples: 100, 100%, pref
   *
   * @param {boolean} [canBePref=false]
   * @throws if unable to decode provided format.
   * @returns {Object} an object with numeric <code>value<code> and <code>unit</code> properties.
   */
  function decodeLayoutStringPart(str) {
    var canBePref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    var data = {};
    if (canBePref && str === "pref") {
      data.unit = Layout.PREF;
    } else if (isNaN(str)) {
      if (str[str.length - 1] === "%") {
        var testNumber = str.substr(0, str.length - 1);
        if (isNaN(testNumber)) {
          throw new Error("Invalid format when decoding string part " + str);
        } else {
          data.value = parseFloat(testNumber);
          data.unit = Layout.PERCENT;
        }
      } else {
        throw new Error("Invalid format when decoding string part " + str);
      }
    } else {
      data.value = parseFloat(str);
      data.unit = Layout.ABS;
    }
    return data;
  }

  /**
   * Representation of a `bajaui:Layout`.
   * @alias module:nmodule/bajaui/rc/baja/Layout
   */
  var Layout = /*#__PURE__*/function (_baja$Simple) {
    /**
     * Creates a {module:nmodule/bajaui/rc/baja/Layout} object.
     *
     * @param {obj | null} obj an obj with params listed below. Defaults to fill
     * object if no parameters given.
     * @param {boolean} [obj.fill]
     * @param {number} [obj.x] x position
     * @param {number} [obj.y] y position
     * @param {number} [obj.w] width
     * @param {number} [obj.h] height
     * @param {Layout.ABS | Layout.PERCENT} [obj.xUnit] x unit type
     * @param {Layout.ABS | Layout.PERCENT} [obj.yUnit] y unit type
     * @param {Layout.ABS | Layout.PERCENT | Layout.PREF} [obj.wUnit] width
     * unit type
     * @param {Layout.ABS | Layout.PERCENT | Layout.PREF} [obj.hUnit] height unit
     * type
     */
    function Layout() {
      var _this;
      var obj = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      _classCallCheck(this, Layout);
      _this = _callSuper(this, Layout);
      if (obj == null || obj.fill) {
        _this.setX(0);
        _this.setY(0);
        _this.setWidth(100);
        _this.setHeight(100);
        _this.setXUnit(Layout.ABS);
        _this.setYUnit(Layout.ABS);
        _this.setWidthUnit(Layout.PERCENT);
        _this.setHeightUnit(Layout.PERCENT);
      } else {
        _this.setX(obj.x || 0);
        _this.setY(obj.y || 0);
        _this.setWidth(obj.w || 0);
        _this.setHeight(obj.h || 0);
        _this.setXUnit(obj.xUnit || Layout.ABS);
        _this.setYUnit(obj.yUnit || Layout.ABS);
        _this.setWidthUnit(obj.wUnit || Layout.ABS);
        _this.setHeightUnit(obj.hUnit || Layout.ABS);
      }
      return _this;
    }

    /**
     * Creates and returns a new Layout object.
     *
     * Refer to constructor for obj description.
     *
     * @param {object|null} obj
     * @returns {Layout}
     */
    _inherits(Layout, _baja$Simple);
    return _createClass(Layout, [{
      key: "make",
      value: function make() {
        return Layout.make.apply(Layout, arguments);
      }

      /**
       * Creates and returns a new Layout object with absolute fields as type.
       *
       * @param {number} x the x position value
       * @param {number} y the y position value
       * @param {number} w the width value
       * @param {number} h the height value
       * @returns {module:nmodule/bajaui/rc/baja/Layout}
       */
    }, {
      key: "getX",
      value:
      /**
       * Gets the current x value
       * @returns {number}
       */
      function getX() {
        return this.$x;
      }

      /**
       * Gets the current y value
       * @returns {number}
       */
    }, {
      key: "getY",
      value: function getY() {
        return this.$y;
      }

      /**
       * Gets the current x unit
       * @returns { Layout.ABS | Layout.PERCENT }
       */
    }, {
      key: "getXUnit",
      value: function getXUnit() {
        return this.$xUnit;
      }

      /**
       * Gets the current y unit
       * @returns { Layout.ABS | Layout.PERCENT }
       */
    }, {
      key: "getYUnit",
      value: function getYUnit() {
        return this.$yUnit;
      }

      /**
       * Sets the current width value
       * @param {number} width
       */
    }, {
      key: "setWidth",
      value: function setWidth(width) {
        this.$w = width;
      }

      /**
       * Gets the current width value
       * @returns {number}
       */
    }, {
      key: "getWidth",
      value: function getWidth() {
        return this.$w;
      }

      /**
       * Sets the current height value
       * @param {number} height
       */
    }, {
      key: "setHeight",
      value: function setHeight(height) {
        this.$h = height;
      }

      /**
       * Gets the current height value
       * @returns {number}
       */
    }, {
      key: "getHeight",
      value: function getHeight() {
        return this.$h;
      }

      /**
       * Gets the current width unit
       * @returns { Layout.ABS | Layout.PERCENT | Layout.PREF }
       */
    }, {
      key: "getWidthUnit",
      value: function getWidthUnit() {
        return this.$wUnit;
      }

      /**
       * Sets the current width unit
       * @param { Layout.PREF | Layout.PERCENT | Layout.ABS } val
       */
    }, {
      key: "setWidthUnit",
      value: function setWidthUnit(val) {
        this.$wUnit = val;
      }

      /**
       * Gets the current width unit
       * @returns { Layout.ABS | Layout.PERCENT | Layout.PREF }
       */
    }, {
      key: "getHeightUnit",
      value: function getHeightUnit() {
        return this.$hUnit;
      }

      /**
       * Sets the current height unit
       * @param { Layout.PREF | Layout.PERCENT | Layout.ABS } val
       */
    }, {
      key: "setHeightUnit",
      value: function setHeightUnit(val) {
        this.$hUnit = val;
      }

      /**
       * Sets the current x value
       * @param {number} x
       */
    }, {
      key: "setX",
      value: function setX(x) {
        this.$x = x;
      }

      /**
       * Sets the current width value
       * @param {number} y
       */
    }, {
      key: "setY",
      value: function setY(y) {
        this.$y = y;
      }

      /**
       * Sets the current x unit
       * @param { Layout.PERCENT | Layout.ABS } val
       */
    }, {
      key: "setXUnit",
      value: function setXUnit(val) {
        this.$xUnit = val;
      }

      /**
       * Sets the current y unit
       * @param { Layout.PERCENT | Layout.ABS } val
       */
    }, {
      key: "setYUnit",
      value: function setYUnit(val) {
        this.$yUnit = val;
      }

      /**
       * Decodes a `Layout` from a string.
       *
       * @param {String} str
       * @returns {Layout}
       */
    }, {
      key: "decodeFromString",
      value: function decodeFromString(str) {
        if (str === "fill") {
          return Layout.FILL;
        } else {
          var parts = str.split(",");
          var xData = decodeLayoutStringPart(parts[0]);
          var yData = decodeLayoutStringPart(parts[1]);
          var widthData = decodeLayoutStringPart(parts[2], true);
          var heightData = decodeLayoutStringPart(parts[3], true);
          return new Layout({
            x: xData.value,
            xUnit: xData.unit,
            y: yData.value,
            yUnit: yData.unit,
            w: widthData.value,
            wUnit: widthData.unit,
            h: heightData.value,
            hUnit: heightData.unit
          });
        }
      }

      /**
       * Encodes this `Layout` to a string.
       *
       * @returns {String}
       */
    }, {
      key: "encodeToString",
      value: function encodeToString() {
        if (this === Layout.FILL) {
          return "fill";
        } else {
          var xPart = encodeLayoutStringPart(this.getX(), this.getXUnit()) + ",";
          var yPart = encodeLayoutStringPart(this.getY(), this.getYUnit()) + ",";
          var widthPart = encodeLayoutStringPart(this.getWidth(), this.getWidthUnit(), true) + ",";
          var heightPart = encodeLayoutStringPart(this.getHeight(), this.getHeightUnit(), true);
          return xPart + yPart + widthPart + heightPart;
        }
      }

      /**
       * Returns a CSS object with `left`, `top`, `width` and `height` properties.
       * `width` and `height` will only be included if they are not set to `PREF`.
       * @returns {object}
       */
    }, {
      key: "toCss",
      value: function toCss() {
        var ABS = Layout.ABS,
          PREF = Layout.PREF;
        var css = {
          left: this.getX() + (this.getXUnit() === ABS ? 'px' : '%'),
          top: this.getY() + (this.getYUnit() === ABS ? 'px' : '%'),
          width: '',
          height: ''
        };
        var widthUnit = this.getWidthUnit();
        var heightUnit = this.getHeightUnit();
        if (widthUnit !== PREF) {
          css.width = this.getWidth() + (widthUnit === ABS ? 'px' : '%');
        }
        if (heightUnit !== PREF) {
          css.height = this.getHeight() + (heightUnit === ABS ? 'px' : '%');
        }
        return css;
      }
    }], [{
      key: "make",
      value: function make(obj) {
        if (!obj || obj.fill) {
          return Layout.FILL;
        }
        return new Layout(obj);
      }
    }, {
      key: "makeAbs",
      value: function makeAbs(x, y, w, h) {
        return new Layout({
          x: x,
          y: y,
          w: w,
          h: h,
          xUnit: Layout.ABS,
          yUnit: Layout.ABS,
          wUnit: Layout.ABS,
          hUnit: Layout.ABS
        });
      }
    }]);
  }(baja.Simple);
  Layout.ABS = 0;
  Layout.PERCENT = 1;
  Layout.PREF = 2;
  Layout.FILL = new Layout();
  Layout.DEFAULT = Layout.FILL;
  return Layout;
});
