function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _superPropGet(t, e, o, r) { var p = _get(_getPrototypeOf(1 & r ? t.prototype : t), e, o); return 2 & r && "function" == typeof p ? function (t) { return p.apply(o, t); } : p; }
function _get() { return _get = "undefined" != typeof Reflect && Reflect.get ? Reflect.get.bind() : function (e, t, r) { var p = _superPropBase(e, t); if (p) { var n = Object.getOwnPropertyDescriptor(p, t); return n.get ? n.get.call(arguments.length < 3 ? e : r) : n.value; } }, _get.apply(null, arguments); }
function _superPropBase(t, o) { for (; !{}.hasOwnProperty.call(t, o) && null !== (t = _getPrototypeOf(t));); return t; }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t["return"] && (u = t["return"](), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
/**
 * @copyright 2020 Tridium, Inc. All Rights Reserved.
 */

/**
 * API Status: **Private**
 * @module nmodule/webEditors/rc/fe/LayoutEditor
 */
define(['baja!', 'baja!bajaui:Layout', 'lex!bajaui', 'bajaux/spandrel', 'bajaux/Widget', 'Promise', 'nmodule/bajaui/rc/baja/Layout', 'nmodule/webEditors/rc/fe/baja/OrderedMapEditor', 'nmodule/webEditors/rc/fe/baja/DisplayOnlyEditor', 'css!nmodule/bajaui/rc/bajaui'], function (baja, types, lexs, spandrel, Widget, Promise, Layout, OrderedMapEditor, DisplayOnlyEditor) {
  'use strict';

  var ABS = Layout.ABS,
    PERCENT = Layout.PERCENT,
    PREF = Layout.PREF,
    FILL = Layout.FILL;
  var _lexs = _slicedToArray(lexs, 1),
    bajauiLex = _lexs[0];
  var XY_UNIT_TYPES = {
    'layoutFE.absolute': ABS,
    'layoutFE.percent': PERCENT
  };
  var WIDTH_HEIGHT_UNIT_TYPES = {
    'layoutFE.absolute': ABS,
    'layoutFE.percent': PERCENT,
    'layoutFE.pref': PREF
  };

  /**
   * Widget layout that is used by Spandrel. Expects a Layout to display.
   */
  function layoutWidget(layout, state) {
    var fill = state.fill,
      x = state.x,
      y = state.y,
      w = state.w,
      h = state.h,
      xUnit = state.xUnit,
      yUnit = state.yUnit,
      wUnit = state.wUnit,
      hUnit = state.hUnit;
    return {
      kids: {
        layoutTable: {
          dom: "<table class=\"ux-table layoutTable ".concat(fill ? 'isFill' : '', "\"/>"),
          kids: {
            headerRow: headerRow({
              valueLabel: bajauiLex.getSafe("layoutFE.value"),
              unitsLabel: bajauiLex.getSafe("layoutFE.units")
            }),
            xRow: coordinateRow({
              name: 'x',
              coordinate: x,
              unit: xUnit,
              label: bajauiLex.getSafe("layoutFE.x")
            }),
            yRow: coordinateRow({
              name: 'y',
              coordinate: y,
              unit: yUnit,
              label: bajauiLex.getSafe("layoutFE.y")
            }),
            widthRow: dimensionRow({
              name: 'w',
              dimension: w,
              unit: wUnit,
              label: bajauiLex.getSafe("sizeFE.width"),
              hideValue: wUnit === PREF
            }),
            heightRow: dimensionRow({
              name: 'h',
              dimension: h,
              unit: hUnit,
              label: bajauiLex.getSafe("sizeFE.height"),
              hideValue: hUnit === PREF
            })
          }
        },
        fill: fillRow({
          fill: fill,
          label: bajauiLex.getSafe("layoutFE.fill")
        })
      }
    };
  }
  function headerRow(_ref) {
    var valueLabel = _ref.valueLabel,
      unitsLabel = _ref.unitsLabel;
    return "\n      <tr class=\"ux-table-head\">\n        <th></th>\n        <th>".concat(valueLabel, "</th>\n        <th>").concat(unitsLabel, "</th>\n      </tr>\n    ");
  }
  function coordinateRow(_ref2) {
    var coordinate = _ref2.coordinate,
      name = _ref2.name,
      unit = _ref2.unit,
      label = _ref2.label;
    return {
      dom: '<tr class="ux-table-row"/>',
      kids: {
        label: "<td>".concat(label, "</td>"),
        value: {
          dom: "<td class=\"dataColumn\" />",
          value: coordinate,
          bindKey: name
        },
        unit: {
          dom: "<td class=\"dataColumn\" />",
          type: OrderedMapEditor,
          value: unit,
          properties: {
            lexicon: 'bajaui',
            map: XY_UNIT_TYPES
          },
          bindKey: name + 'Unit'
        }
      }
    };
  }
  function dimensionRow(_ref3) {
    var dimension = _ref3.dimension,
      unit = _ref3.unit,
      label = _ref3.label,
      hideValue = _ref3.hideValue,
      name = _ref3.name;
    return {
      dom: '<tr class="ux-table-row"/>',
      kids: {
        label: "<td>".concat(label, "</td>"),
        value: {
          dom: "<td class=\"dataColumn ".concat(hideValue ? "hideContents" : "", "\" />"),
          value: dimension,
          bindKey: name
        },
        unit: {
          dom: "<td class=\"dataColumn\" />",
          type: OrderedMapEditor,
          value: unit,
          properties: {
            lexicon: 'bajaui',
            map: WIDTH_HEIGHT_UNIT_TYPES
          },
          bindKey: name + 'Unit'
        }
      }
    };
  }
  function fillRow(_ref4) {
    var fill = _ref4.fill,
      label = _ref4.label;
    return {
      dom: '<tr class="ux-table-row"/>',
      value: fill,
      properties: {
        trueText: label,
        falseText: label
      },
      bindKey: 'fill'
    };
  }
  var widgetDefaults = function widgetDefaults() {
    return {
      properties: {
        rootCssClass: 'LayoutEditor'
      }
    };
  };

  /***
   * A field editor class for bajaui:Layout.  Uses Spandrel to maintain structure.
   *
   * @class
   * @alias module:nmodule/bajaui/rc/fe/LayoutEditor
   * @extends module:bajaux/spandrel/SpandrelWidget
   */
  var LayoutEditor = /*#__PURE__*/function (_spandrel) {
    function LayoutEditor(params) {
      var _this;
      _classCallCheck(this, LayoutEditor);
      _this = _callSuper(this, LayoutEditor, [{
        params: params,
        defaults: widgetDefaults()
      }]);
      if (_this.getFormFactor() === Widget.formfactor.mini) {
        DisplayOnlyEditor.$mixin(_this);
      }
      return _this;
    }
    _inherits(LayoutEditor, _spandrel);
    return _createClass(LayoutEditor, [{
      key: "getFillWidget",
      value: function getFillWidget() {
        return this.queryWidget('fill');
      }
    }, {
      key: "getXPosWidget",
      value: function getXPosWidget() {
        return this.queryWidget('layoutTable/xRow/value');
      }
    }, {
      key: "getYPosWidget",
      value: function getYPosWidget() {
        return this.queryWidget('layoutTable/yRow/value');
      }
    }, {
      key: "getWidthWidget",
      value: function getWidthWidget() {
        return this.queryWidget('layoutTable/widthRow/value');
      }
    }, {
      key: "getHeightWidget",
      value: function getHeightWidget() {
        return this.queryWidget('layoutTable/heightRow/value');
      }
    }, {
      key: "getXUnitWidget",
      value: function getXUnitWidget() {
        return this.queryWidget('layoutTable/xRow/unit');
      }
    }, {
      key: "getYUnitWidget",
      value: function getYUnitWidget() {
        return this.queryWidget('layoutTable/yRow/unit');
      }
    }, {
      key: "getWidthUnitWidget",
      value: function getWidthUnitWidget() {
        return this.queryWidget('layoutTable/widthRow/unit');
      }
    }, {
      key: "getHeightUnitWidget",
      value: function getHeightUnitWidget() {
        return this.queryWidget('layoutTable/heightRow/unit');
      }

      /**
       * Loads a layout into the widget
       * @param {module:nmodule/bajaui/rc/baja/Layout} layout
       * @returns {Promise}
       */
    }, {
      key: "doLoad",
      value: function doLoad(layout) {
        if (!baja.hasType(layout, 'bajaui:Layout')) {
          return Promise.reject(new Error('Input value is not correct type: ' + layout));
        }
        return _superPropGet(LayoutEditor, "doLoad", this, 1).apply(this, arguments);
      }
    }, {
      key: "toState",
      value: function toState(layout) {
        return {
          x: layout.getX(),
          y: layout.getY(),
          w: layout.getWidth(),
          h: layout.getHeight(),
          xUnit: layout.getXUnit(),
          yUnit: layout.getYUnit(),
          wUnit: layout.getWidthUnit(),
          hUnit: layout.getHeightUnit(),
          fill: layout === FILL
        };
      }
    }, {
      key: "fromState",
      value: function fromState(state) {
        if (state.fill) {
          return FILL;
        }
        var x = state.x,
          y = state.y,
          xUnit = state.xUnit,
          yUnit = state.yUnit,
          wUnit = state.wUnit,
          hUnit = state.hUnit;
        var obj = {
          x: x,
          y: y,
          xUnit: xUnit,
          yUnit: yUnit,
          wUnit: wUnit,
          hUnit: hUnit
        };
        if (wUnit !== PREF) {
          obj.w = state.w;
        }
        if (hUnit !== PREF) {
          obj.h = state.h;
        }
        return Layout.make(obj);
      }
    }]);
  }(spandrel(layoutWidget, {
    strategy: 'niagara'
  }));
  return LayoutEditor;
});
